<?php $__env->startSection('title', 'Tenant Activity - ' . $tenant->name); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <!-- Page Header -->
    <div class="mb-8">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-3xl font-bold text-gray-900">Tenant Activity</h1>
                <p class="mt-2 text-gray-600"><?php echo e($tenant->name); ?></p>
            </div>
            <div class="flex space-x-2">
                <a href="<?php echo e(route('developer.tenants')); ?>" 
                   class="text-gray-600 hover:text-gray-900">
                    ← Back to Tenants
                </a>
                <a href="<?php echo e(route('developer.tenants.applications', $tenant->id)); ?>" 
                   class="bg-purple-600 text-white px-4 py-2 rounded-md hover:bg-purple-700 text-sm">
                    View Logs
                </a>
            </div>
        </div>
    </div>

    <!-- Tenant Info -->
    <div class="bg-white shadow rounded-lg mb-6">
        <div class="px-4 py-5 sm:px-6">
            <div class="flex items-center justify-between">
                <div class="flex items-center">
                    <div class="flex-shrink-0 h-12 w-12 rounded-full bg-purple-500 flex items-center justify-center">
                        <span class="text-white font-medium text-lg">
                            <?php echo e(substr($tenant->name, 0, 1)); ?>

                        </span>
                    </div>
                    <div class="ml-4">
                        <h2 class="text-xl font-semibold text-gray-900"><?php echo e($tenant->name); ?></h2>
                        <p class="text-sm text-gray-500"><?php echo e($tenant->domain); ?></p>
                        <div class="flex items-center mt-1">
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium
                                <?php if($tenant->status === 'active'): ?> bg-green-100 text-green-800
                                <?php elseif($tenant->status === 'trialing'): ?> bg-yellow-100 text-yellow-800
                                <?php elseif($tenant->status === 'expired'): ?> bg-red-100 text-red-800
                                <?php else: ?> bg-gray-100 text-gray-800 <?php endif; ?>">
                                <?php echo e(ucfirst($tenant->status)); ?>

                            </span>
                            <span class="ml-2 text-xs text-gray-500">
                                Created <?php echo e($tenant->created_at->format('M d, Y')); ?>

                            </span>
                        </div>
                    </div>
                </div>
                <div class="text-right">
                    <div class="text-sm text-gray-500">ID: <?php echo e($tenant->id); ?></div>
                </div>
            </div>
            
            <!-- Stats -->
            <div class="mt-6 grid grid-cols-1 sm:grid-cols-3 gap-4">
                <div class="bg-gray-50 px-4 py-3 rounded-lg">
                    <div class="text-sm text-gray-500">Total Users</div>
                    <div class="text-2xl font-semibold text-gray-900"><?php echo e($tenant->users->count()); ?></div>
                </div>
                <div class="bg-gray-50 px-4 py-3 rounded-lg">
                    <div class="text-sm text-gray-500">Subscription</div>
                    <div class="text-2xl font-semibold text-gray-900">
                        <?php if($tenant->subscription): ?>
                            <?php echo e($tenant->subscription->plan->name ?? 'No Plan'); ?>

                        <?php else: ?>
                            No Subscription
                        <?php endif; ?>
                    </div>
                </div>
                <div class="bg-gray-50 px-4 py-3 rounded-lg">
                    <div class="text-sm text-gray-500">Chat Sessions</div>
                    <div class="text-2xl font-semibold text-gray-900">
                        <?php echo e(\App\Models\ChatSession::where('tenant_id', $tenant->id)->count()); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Activities Timeline -->
    <div class="bg-white shadow rounded-lg">
        <div class="px-4 py-5 sm:px-6">
            <h3 class="text-lg font-medium text-gray-900">Activity Timeline</h3>
        </div>
        <div class="border-t border-gray-200">
            <div class="divide-y divide-gray-200">
                <?php if($activities->count() > 0): ?>
                    <?php $__currentLoopData = $activities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $activity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="px-4 py-4 sm:px-6">
                            <div class="flex items-start space-x-3">
                                <div class="flex-shrink-0">
                                    <div class="h-8 w-8 rounded-full bg-<?php echo e($activity['color']); ?>-100 flex items-center justify-center">
                                        <svg class="h-4 w-4 text-<?php echo e($activity['color']); ?>" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <?php if($activity['icon'] === 'credit-card'): ?>
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1M4 15h2m5-4v1m-1-1h-1m1-1v1m-1 1h-1m-6-4h1m1 1v1m-1 1h-1m1-1v-1m1 1h-1"></path>
                                            <?php elseif($activity['icon'] === 'message-circle'): ?>
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.009 9.009 0 00-2.012 2.067C13.938 16.038 14 12.07 14 12.07c0 .586-.051 1.17-.141 1.736-.054.574-.112 1.14-.054 1.736-.054.658.005 1.322.054 1.97.054z"></path>
                                            <?php elseif($activity['icon'] === 'user'): ?>
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 01-7 7h14a7 7 0 01-7-7h-14z"></path>
                                            <?php else: ?>
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                            <?php endif; ?>
                                        </svg>
                                    </div>
                                </div>
                                <div class="flex-1 min-w-0">
                                    <div class="text-sm">
                                        <div class="font-medium text-gray-900"><?php echo e(ucfirst($activity['type'])); ?></div>
                                        <div class="text-gray-500"><?php echo e($activity['message']); ?></div>
                                        <?php if(isset($activity['details'])): ?>
                                            <div class="text-xs text-gray-400 mt-1"><?php echo e($activity['details']); ?></div>
                                        <?php endif; ?>
                                    </div>
                                    <div class="text-xs text-gray-500 mt-2">
                                        <?php echo e($activity['timestamp']->format('M d, Y H:i A')); ?>

                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <div class="px-4 py-8 text-center text-gray-500">
                        <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3v-4m0 4l-3-3m3 3V8m0-4l-3-3m9 14a9 9 0 01-18 0 9 9 0 0118 0z"></path>
                        </svg>
                        <p class="mt-2">No activities found</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.developer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\laragon\www\Laravel_gorsary\resources\views/developer/tenants/activity.blade.php ENDPATH**/ ?>