<?php if (isset($component)) { $__componentOriginal3f11930a8702d3d700513f5d743b90ca = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal3f11930a8702d3d700513f5d743b90ca = $attributes; } ?>
<?php $component = App\View\Components\TenantLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('tenant-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\TenantLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            <?php echo e(__('Detailed Reports')); ?>

        </h2>
     <?php $__env->endSlot(); ?>

    <div class="py-12" x-data="{ openModal: false, selectedItem: null }">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <!-- Filters -->
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg mb-6">
                <div class="p-6 bg-white border-b border-gray-200">
                    <form method="GET" action="<?php echo e(route('tenant.reports.detailed')); ?>" class="grid grid-cols-1 md:grid-cols-4 gap-4">
                        
                        <!-- Report Type -->
                        <div>
                            <label for="type" class="block text-sm font-medium text-gray-700">Report Type</label>
                            <select name="type" id="type" onchange="this.form.submit()" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm">
                                <option value="sales" <?php echo e($reportType == 'sales' ? 'selected' : ''); ?>>Sales</option>
                                <option value="purchases" <?php echo e($reportType == 'purchases' ? 'selected' : ''); ?>>Purchases</option>
                                <option value="credit" <?php echo e($reportType == 'credit' ? 'selected' : ''); ?>>Credit / Due</option>
                            </select>
                        </div>

                        <!-- Date Range -->
                        <div>
                            <label for="start_date" class="block text-sm font-medium text-gray-700">Start Date</label>
                            <input type="date" name="start_date" id="start_date" value="<?php echo e($startDate); ?>" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm">
                        </div>
                        <div>
                            <label for="end_date" class="block text-sm font-medium text-gray-700">End Date</label>
                            <input type="date" name="end_date" id="end_date" value="<?php echo e($endDate); ?>" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm">
                        </div>

                        <!-- Specific Filters -->
                        <?php if($reportType == 'sales'): ?>
                            <div>
                                <label for="customer_id" class="block text-sm font-medium text-gray-700">Customer</label>
                                <select name="customer_id" id="customer_id" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm">
                                    <option value="">All Customers</option>
                                    <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($customer->id); ?>" <?php echo e($customerId == $customer->id ? 'selected' : ''); ?>><?php echo e($customer->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        <?php else: ?>
                            <div>
                                <label for="supplier_id" class="block text-sm font-medium text-gray-700">Supplier</label>
                                <select name="supplier_id" id="supplier_id" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm">
                                    <option value="">All Suppliers</option>
                                    <?php $__currentLoopData = $suppliers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supplier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($supplier->id); ?>" <?php echo e($supplierId == $supplier->id ? 'selected' : ''); ?>><?php echo e($supplier->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        <?php endif; ?>

                        <!-- Product Filter -->
                        <div class="md:col-span-2">
                            <label for="variant_id" class="block text-sm font-medium text-gray-700">Product / Variant</label>
                            <select name="variant_id" id="variant_id" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm">
                                <option value="">All Products</option>
                                <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($product->id); ?>" <?php echo e($variantId == $product->id ? 'selected' : ''); ?>><?php echo e($product->full_name); ?> (<?php echo e($product->sku); ?>)</option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <!-- Filter Button -->
                        <div class="flex items-end">
                            <button type="submit" class="w-full bg-indigo-600 border border-transparent rounded-md shadow-sm py-2 px-4 inline-flex justify-center text-sm font-medium text-white hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                                Filter Report
                            </button>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Results Table -->
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 bg-white border-b border-gray-200 overflow-x-auto">
                    <?php if($results->isEmpty()): ?>
                        <div class="text-center py-8 text-gray-500">
                            No records found for the selected criteria.
                        </div>
                    <?php else: ?>
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Date</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                        <?php echo e($reportType == 'sales' ? 'Invoice / Customer' : 'PO / Supplier'); ?>

                                    </th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Items</th>
                                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Total Amount</th>
                                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Paid / Due</th>
                                    <th class="px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                                    <th class="px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">Action</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                <?php $__currentLoopData = $results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                            <?php echo e($row->created_at->format('M d, Y H:i')); ?>

                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">
                                            <?php if($reportType == 'sales'): ?>
                                                <span class="block text-indigo-600">#<?php echo e($row->invoice_no ?? 'N/A'); ?></span>
                                                <span class="text-gray-500"><?php echo e($row->customer->name ?? 'Walk-in Customer'); ?></span>
                                            <?php else: ?>
                                                <span class="block text-indigo-600">#<?php echo e($row->purchase_no ?? 'N/A'); ?></span>
                                                <span class="text-gray-500"><?php echo e($row->supplier->name ?? 'N/A'); ?></span>
                                            <?php endif; ?>
                                        </td>
                                        <td class="px-6 py-4 text-sm text-gray-500">
                                            <ul class="list-disc list-inside">
                                                <?php $__currentLoopData = $row->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if(!$variantId || ($reportType == 'sales' ? $item->variant_id : $item->product_variant_id) == $variantId): ?>
                                                        <li>
                                                            <?php echo e($item->variant->product->name ?? 'Unknown'); ?> 
                                                            <?php if(isset($item->variant) && $item->variant->name !== $item->variant->product->name): ?>
                                                                (<?php echo e($item->variant->name); ?>)
                                                            <?php endif; ?>
                                                            x <?php echo e($item->quantity); ?>

                                                        </li>
                                                    <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </ul>
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-right font-bold text-gray-900">
                                            $<?php echo e(number_format($row->total_amount ?? $row->total ?? 0, 2)); ?>

                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-right">
                                            <div class="text-green-600">Paid: $<?php echo e(number_format($row->paid_amount ?? $row->total ?? 0, 2)); ?></div>
                                            <?php
                                                $total = $row->total_amount ?? $row->total ?? 0;
                                                $paid = $row->paid_amount ?? $row->total ?? 0;
                                                $due = $total - $paid;
                                            ?>
                                            <?php if($due > 0): ?>
                                                <div class="text-red-600 font-bold">Due: $<?php echo e(number_format($due, 2)); ?></div>
                                            <?php endif; ?>
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-center">
                                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full <?php echo e(($row->status ?? 'completed') == 'completed' || ($row->status ?? '') == 'received' ? 'bg-green-100 text-green-800' : 'bg-yellow-100 text-yellow-800'); ?>">
                                                <?php echo e(ucfirst($row->status ?? 'Completed')); ?>

                                            </span>
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-center text-sm font-medium">
                                            <button @click="openModal = true; selectedItem = <?php echo e($row); ?>" class="text-indigo-600 hover:text-indigo-900">
                                                View
                                            </button>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                            <tfoot class="bg-gray-50">
                                <tr>
                                    <td colspan="3" class="px-6 py-3 text-right font-bold text-gray-700">Total:</td>
                                    <td class="px-6 py-3 text-right font-bold text-indigo-600">
                                        $<?php echo e(number_format($results->sum(fn($r) => $r->total_amount ?? $r->total ?? 0), 2)); ?>

                                    </td>
                                    <td colspan="2"></td>
                                </tr>
                            </tfoot>
                        </table>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Details Modal -->
        <div x-show="openModal" class="fixed inset-0 z-50 overflow-y-auto" style="display: none;" x-cloak>
            <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
                <div class="fixed inset-0 transition-opacity" aria-hidden="true" @click="openModal = false">
                    <div class="absolute inset-0 bg-gray-500 opacity-75"></div>
                </div>
                <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>
                <div class="inline-block align-bottom bg-white rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-3xl sm:w-full">
                    <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                        <div class="sm:flex sm:items-start">
                            <div class="mt-3 text-center sm:mt-0 sm:ml-4 sm:text-left w-full">
                                <h3 class="text-lg leading-6 font-medium text-gray-900" id="modal-title">
                                    Transaction Details
                                </h3>
                                <div class="mt-4" x-if="selectedItem">
                                    <div class="grid grid-cols-2 gap-4 mb-4">
                                        <div>
                                            <p class="text-sm font-bold text-gray-500">Invoice / PO</p>
                                            <p class="text-lg font-bold" x-text="selectedItem.invoice_no || selectedItem.purchase_no || 'N/A'"></p>
                                        </div>
                                        <div>
                                            <p class="text-sm font-bold text-gray-500">Date</p>
                                            <p x-text="new Date(selectedItem.created_at).toLocaleDateString() + ' ' + new Date(selectedItem.created_at).toLocaleTimeString()"></p>
                                        </div>
                                        <div>
                                            <p class="text-sm font-bold text-gray-500">Party</p>
                                            <p x-text="(selectedItem.customer ? selectedItem.customer.name : (selectedItem.supplier ? selectedItem.supplier.name : 'Walk-in'))"></p>
                                        </div>
                                        <div>
                                            <p class="text-sm font-bold text-gray-500">Status</p>
                                            <p class="uppercase font-bold" x-text="selectedItem.status"></p>
                                        </div>
                                    </div>

                                    <table class="min-w-full divide-y divide-gray-200 border">
                                        <thead class="bg-gray-50">
                                            <tr>
                                                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Item</th>
                                                <th class="px-4 py-2 text-right text-xs font-medium text-gray-500 uppercase">Price/Cost</th>
                                                <th class="px-4 py-2 text-center text-xs font-medium text-gray-500 uppercase">Qty</th>
                                                <th class="px-4 py-2 text-right text-xs font-medium text-gray-500 uppercase">Total</th>
                                            </tr>
                                        </thead>
                                        <tbody class="bg-white divide-y divide-gray-200">
                                            <template x-for="item in selectedItem.items" :key="item.id">
                                                <tr>
                                                    <td class="px-4 py-2 text-sm text-gray-900">
                                                        <span x-text="item.variant.product.name"></span>
                                                        <span x-show="item.variant.name !== item.variant.product.name" x-text="' (' + item.variant.name + ')'"></span>
                                                    </td>
                                                    <td class="px-4 py-2 text-sm text-gray-900 text-right" x-text="'$' + (parseFloat(item.price || item.unit_cost)).toFixed(2)"></td>
                                                    <td class="px-4 py-2 text-sm text-gray-900 text-center" x-text="item.quantity"></td>
                                                    <td class="px-4 py-2 text-sm text-gray-900 text-right font-medium" x-text="'$' + (parseFloat(item.total)).toFixed(2)"></td>
                                                </tr>
                                            </template>
                                        </tbody>
                                        <tfoot>
                                            <tr class="bg-gray-50 font-bold">
                                                <td colspan="3" class="px-4 py-2 text-right">Total:</td>
                                                <td class="px-4 py-2 text-right" x-text="'$' + (parseFloat(selectedItem.total || selectedItem.total_amount)).toFixed(2)"></td>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="bg-gray-50 px-4 py-3 sm:px-6 sm:flex sm:flex-row-reverse">
                        <button type="button" @click="openModal = false" class="mt-3 w-full inline-flex justify-center rounded-md border border-gray-300 shadow-sm px-4 py-2 bg-white text-base font-medium text-gray-700 hover:bg-gray-50 sm:mt-0 sm:ml-3 sm:w-auto sm:text-sm">
                            Close
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal3f11930a8702d3d700513f5d743b90ca)): ?>
<?php $attributes = $__attributesOriginal3f11930a8702d3d700513f5d743b90ca; ?>
<?php unset($__attributesOriginal3f11930a8702d3d700513f5d743b90ca); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal3f11930a8702d3d700513f5d743b90ca)): ?>
<?php $component = $__componentOriginal3f11930a8702d3d700513f5d743b90ca; ?>
<?php unset($__componentOriginal3f11930a8702d3d700513f5d743b90ca); ?>
<?php endif; ?>
<?php /**PATH D:\laragon\www\Laravel_gorsary\resources\views/tenant/reports/detailed.blade.php ENDPATH**/ ?>