<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title><?php echo e(config('app.name', 'Grocery SaaS')); ?></title>
        <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
        <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
        <style>
            body { font-family: 'Inter', sans-serif; }
        </style>
    </head>
    <body class="antialiased text-gray-900 bg-white">
        
        <!-- Navigation -->
        <nav class="bg-white border-b border-gray-100 fixed w-full z-50 top-0">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="flex justify-between h-16">
                    <div class="flex">
                        <div class="flex-shrink-0 flex items-center">
                            <div class="h-10 w-10 bg-green-500 rounded-lg flex items-center justify-center text-white text-xl font-bold shadow-sm">
                                🛒
                            </div>
                            <span class="ml-3 font-bold text-xl text-gray-900">Grocery<span class="text-green-600">SaaS</span></span>
                        </div>
                    </div>
                    <div class="flex items-center space-x-4">
                        <?php if(Route::has('login')): ?>
                            <?php if(auth()->guard()->check()): ?>
                                <a href="<?php echo e(url('/dashboard')); ?>" class="text-gray-600 hover:text-green-600 font-medium transition">Dashboard</a>
                            <?php else: ?>
                                <a href="<?php echo e(route('login')); ?>" class="text-gray-600 hover:text-green-600 font-medium transition">Log in</a>
                                <?php if(Route::has('register')): ?>
                                    <a href="<?php echo e(route('register')); ?>" class="px-4 py-2 rounded-md bg-green-600 text-white hover:bg-green-700 font-medium transition shadow-sm">Get Started</a>
                                <?php endif; ?>
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </nav>

        <!-- Hero Section -->
        <div class="relative pt-24 pb-16 sm:pt-32 sm:pb-24 overflow-hidden">
            <div class="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
                <h1 class="text-4xl tracking-tight font-extrabold text-gray-900 sm:text-5xl md:text-6xl">
                    <span class="block">Manage your grocery business</span>
                    <span class="block text-green-600">with ease and efficiency</span>
                </h1>
                <p class="mt-3 max-w-md mx-auto text-base text-gray-500 sm:text-lg md:mt-5 md:text-xl md:max-w-3xl">
                    The all-in-one platform for grocery stores. Inventory management, point of sale, customer analytics, and multi-store support—all in one place.
                </p>
                <div class="mt-5 max-w-md mx-auto sm:flex sm:justify-center md:mt-8">
                    <div class="rounded-md shadow">
                        <a href="<?php echo e(route('register')); ?>" class="w-full flex items-center justify-center px-8 py-3 border border-transparent text-base font-medium rounded-md text-white bg-green-600 hover:bg-green-700 md:py-4 md:text-lg md:px-10">
                            Start Free Trial
                        </a>
                    </div>
                    <div class="mt-3 rounded-md shadow sm:mt-0 sm:ml-3">
                        <a href="<?php echo e(route('login')); ?>" class="w-full flex items-center justify-center px-8 py-3 border border-transparent text-base font-medium rounded-md text-green-600 bg-white hover:bg-gray-50 md:py-4 md:text-lg md:px-10">
                            Live Demo
                        </a>
                    </div>
                </div>
            </div>
            
            <!-- Abstract background blob -->
            <div class="absolute top-0 left-1/2 transform -translate-x-1/2 -z-10 opacity-30">
                <svg viewBox="0 0 100 100" width="800" height="800" fill="url(#gradient)">
                    <defs>
                        <linearGradient id="gradient" x1="0%" y1="0%" x2="100%" y2="100%">
                            <stop offset="0%" style="stop-color:#4ade80;stop-opacity:1" />
                            <stop offset="100%" style="stop-color:#22c55e;stop-opacity:1" />
                        </linearGradient>
                    </defs>
                    <circle cx="50" cy="50" r="40" />
                </svg>
            </div>
        </div>

        <!-- Features Section -->
        <div class="py-12 bg-gray-50">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="lg:text-center">
                    <h2 class="text-base text-green-600 font-semibold tracking-wide uppercase">Features</h2>
                    <p class="mt-2 text-3xl leading-8 font-extrabold tracking-tight text-gray-900 sm:text-4xl">
                        Everything you need to run your store
                    </p>
                    <p class="mt-4 max-w-2xl text-xl text-gray-500 lg:mx-auto">
                        Powerful tools designed specifically for the modern grocery retailer.
                    </p>
                </div>

                <div class="mt-10">
                    <dl class="space-y-10 md:space-y-0 md:grid md:grid-cols-3 md:gap-x-8 md:gap-y-10">
                        <div class="relative">
                            <dt>
                                <div class="absolute flex items-center justify-center h-12 w-12 rounded-md bg-green-500 text-white text-2xl">
                                    🛍️
                                </div>
                                <p class="ml-16 text-lg leading-6 font-medium text-gray-900">Point of Sale</p>
                            </dt>
                            <dd class="mt-2 ml-16 text-base text-gray-500">
                                Fast, reliable, and easy-to-use checkout interface that works on any device.
                            </dd>
                        </div>

                        <div class="relative">
                            <dt>
                                <div class="absolute flex items-center justify-center h-12 w-12 rounded-md bg-green-500 text-white text-2xl">
                                    📦
                                </div>
                                <p class="ml-16 text-lg leading-6 font-medium text-gray-900">Inventory Management</p>
                            </dt>
                            <dd class="mt-2 ml-16 text-base text-gray-500">
                                Real-time tracking of stock levels, low stock alerts, and automated reordering.
                            </dd>
                        </div>

                        <div class="relative">
                            <dt>
                                <div class="absolute flex items-center justify-center h-12 w-12 rounded-md bg-green-500 text-white text-2xl">
                                    📊
                                </div>
                                <p class="ml-16 text-lg leading-6 font-medium text-gray-900">Advanced Analytics</p>
                            </dt>
                            <dd class="mt-2 ml-16 text-base text-gray-500">
                                Gain insights into your best-selling products, peak hours, and customer trends.
                            </dd>
                        </div>
                         <div class="relative">
                            <dt>
                                <div class="absolute flex items-center justify-center h-12 w-12 rounded-md bg-green-500 text-white text-2xl">
                                    🏢
                                </div>
                                <p class="ml-16 text-lg leading-6 font-medium text-gray-900">Multi-Store Support</p>
                            </dt>
                            <dd class="mt-2 ml-16 text-base text-gray-500">
                                Seamlessly manage multiple branches from a single centralized dashboard.
                            </dd>
                        </div>
                        <div class="relative">
                            <dt>
                                <div class="absolute flex items-center justify-center h-12 w-12 rounded-md bg-green-500 text-white text-2xl">
                                    👥
                                </div>
                                <p class="ml-16 text-lg leading-6 font-medium text-gray-900">Customer Loyalty</p>
                            </dt>
                            <dd class="mt-2 ml-16 text-base text-gray-500">
                                Build relationships with built-in CRM and loyalty program features.
                            </dd>
                        </div>
                         <div class="relative">
                            <dt>
                                <div class="absolute flex items-center justify-center h-12 w-12 rounded-md bg-green-500 text-white text-2xl">
                                    ☁️
                                </div>
                                <p class="ml-16 text-lg leading-6 font-medium text-gray-900">Cloud Based</p>
                            </dt>
                            <dd class="mt-2 ml-16 text-base text-gray-500">
                                Access your business data from anywhere, anytime, securely in the cloud.
                            </dd>
                        </div>
                    </dl>
                </div>
            </div>
        </div>

        <!-- Footer -->
        <footer class="bg-gray-800 text-white py-12">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="md:flex md:justify-between">
                    <div class="mb-8 md:mb-0">
                        <div class="flex items-center">
                            <div class="h-8 w-8 bg-green-500 rounded flex items-center justify-center text-white text-sm font-bold">
                                🛒
                            </div>
                            <span class="ml-2 font-bold text-xl">GrocerySaaS</span>
                        </div>
                        <p class="mt-2 text-gray-400 text-sm">Empowering grocery businesses worldwide.</p>
                    </div>
                    <div class="flex space-x-8">
                        <a href="#" class="text-gray-400 hover:text-white">Privacy</a>
                        <a href="#" class="text-gray-400 hover:text-white">Terms</a>
                        <a href="#" class="text-gray-400 hover:text-white">Contact</a>
                    </div>
                </div>
                <div class="mt-8 border-t border-gray-700 pt-8 text-center text-sm text-gray-400">
                    &copy; <?php echo e(date('Y')); ?> GrocerySaaS Inc. All rights reserved.
                </div>
            </div>
        </footer>
    </body>
</html>
<?php /**PATH D:\laragon\www\Laravel_gorsary\resources\views/welcome.blade.php ENDPATH**/ ?>