<?php if (isset($component)) { $__componentOriginal91fdd17964e43374ae18c674f95cdaa3 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal91fdd17964e43374ae18c674f95cdaa3 = $attributes; } ?>
<?php $component = App\View\Components\AdminLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('admin-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AdminLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            Customer Reports
        </h2>
     <?php $__env->endSlot(); ?>

    <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
        <!-- Filters -->
        <div class="bg-white shadow-sm rounded-lg mb-6">
            <div class="p-6">
                <form method="GET" action="<?php echo e(route('admin.reports.customers')); ?>">
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Search</label>
                            <input type="text" name="search" value="<?php echo e($search); ?>" placeholder="Search by name or email" 
                                   class="w-full rounded-md border-gray-300 shadow-sm focus:border-green-500 focus:ring focus:ring-green-200 focus:ring-opacity-50">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Status</label>
                            <select name="status" class="w-full rounded-md border-gray-300 shadow-sm focus:border-green-500 focus:ring focus:ring-green-200 focus:ring-opacity-50">
                                <option value="all" <?php echo e($status == 'all' ? 'selected' : ''); ?>>All</option>
                                <option value="active" <?php echo e($status == 'active' ? 'selected' : ''); ?>>Active</option>
                                <option value="expired" <?php echo e($status == 'expired' ? 'selected' : ''); ?>>Expired</option>
                                <option value="trial" <?php echo e($status == 'trial' ? 'selected' : ''); ?>>Trial</option>
                            </select>
                        </div>
                        <div class="flex items-end">
                            <button type="submit" class="bg-green-600 text-white px-4 py-2 rounded-md hover:bg-green-700">
                                Apply Filters
                            </button>
                            <a href="<?php echo e(route('admin.reports.customers')); ?>" class="ml-2 text-gray-600 hover:text-gray-800">
                                Clear
                            </a>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <!-- Statistics Cards -->
        <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-6">
            <div class="bg-white overflow-hidden shadow-sm rounded-lg">
                <div class="p-6">
                    <div class="text-sm font-medium text-gray-500">Total Tenants</div>
                    <div class="text-2xl font-bold text-gray-900"><?php echo e($totalTenants); ?></div>
                </div>
            </div>
            <div class="bg-white overflow-hidden shadow-sm rounded-lg">
                <div class="p-6">
                    <div class="text-sm font-medium text-gray-500">Active</div>
                    <div class="text-2xl font-bold text-green-600"><?php echo e($activeTenants); ?></div>
                </div>
            </div>
            <div class="bg-white overflow-hidden shadow-sm rounded-lg">
                <div class="p-6">
                    <div class="text-sm font-medium text-gray-500">Expired</div>
                    <div class="text-2xl font-bold text-red-600"><?php echo e($expiredTenants); ?></div>
                </div>
            </div>
            <div class="bg-white overflow-hidden shadow-sm rounded-lg">
                <div class="p-6">
                    <div class="text-sm font-medium text-gray-500">Trial</div>
                    <div class="text-2xl font-bold text-yellow-600"><?php echo e($trialTenants); ?></div>
                </div>
            </div>
        </div>

        <!-- Customers Table -->
        <div class="bg-white shadow-sm rounded-lg">
            <div class="p-6">
                <h3 class="text-lg font-medium text-gray-900 mb-4">Customer List</h3>
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Name</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Email</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Plan</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Ends At</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Users</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            <?php $__currentLoopData = $tenants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tenant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="text-sm font-medium text-gray-900"><?php echo e($tenant->name); ?></div>
                                        <div class="text-sm text-gray-500">ID: <?php echo e($tenant->id); ?></div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                        <?php echo e($tenant->email); ?>

                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                        <?php if($tenant->subscription): ?>
                                            <?php echo e($tenant->subscription->plan->name); ?>

                                        <?php else: ?>
                                            <span class="text-gray-400">No Plan</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <?php if($tenant->subscription): ?>
                                            <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full
                                                <?php if($tenant->subscription->status === 'active' && $tenant->subscription->ends_at && $tenant->subscription->ends_at > now()): ?> bg-green-100 text-green-800
                                                <?php elseif($tenant->subscription->ends_at && $tenant->subscription->ends_at < now()): ?> bg-red-100 text-red-800
                                                <?php elseif($tenant->subscription->status === 'trialing'): ?> bg-yellow-100 text-yellow-800
                                                <?php else: ?> bg-gray-100 text-gray-800 <?php endif; ?>">
                                                <?php if($tenant->subscription->status === 'active' && $tenant->subscription->ends_at && $tenant->subscription->ends_at > now()): ?>
                                                    Active
                                                <?php elseif($tenant->subscription->ends_at && $tenant->subscription->ends_at < now()): ?>
                                                    Expired
                                                <?php elseif($tenant->subscription->status === 'trialing'): ?>
                                                    Trial
                                                <?php else: ?>
                                                    <?php echo e(ucfirst($tenant->subscription->status)); ?>

                                                <?php endif; ?>
                                            </span>
                                        <?php else: ?>
                                            <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-gray-100 text-gray-800">
                                                No Subscription
                                            </span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                        <?php if($tenant->subscription && $tenant->subscription->ends_at): ?>
                                            <?php echo e($tenant->subscription->ends_at->format('M d, Y')); ?>

                                        <?php else: ?>
                                            <span class="text-gray-400">No end date</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                        <?php echo e($tenant->users->count()); ?>

                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                        <a href="<?php echo e(route('admin.reports.customer-details', $tenant->id)); ?>" 
                                           class="text-green-600 hover:text-green-900 mr-3">View Details</a>
                                        <button onclick="startChat(<?php echo e($tenant->id); ?>)" 
                                                class="text-blue-600 hover:text-blue-900">Chat</button>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
                
                <!-- Pagination -->
                <div class="mt-4">
                    <?php echo e($tenants->links()); ?>

                </div>
            </div>
        </div>
    </div>

    <!-- Start Chat Modal -->
    <div id="startChatModal" class="hidden fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50">
        <div class="relative top-20 mx-auto p-5 border w-96 shadow-lg rounded-md bg-white">
            <div class="mt-3">
                <h3 class="text-lg font-medium text-gray-900">Start Chat</h3>
                <div class="mt-2 text-sm text-gray-500">
                    Are you sure you want to start a chat with this tenant?
                </div>
                <div class="mt-4 flex justify-end space-x-3">
                    <button onclick="closeChatModal()" 
                            class="px-4 py-2 bg-gray-300 text-gray-800 rounded hover:bg-gray-400">
                        Cancel
                    </button>
                    <button onclick="confirmStartChat()" 
                            class="px-4 py-2 bg-blue-600 text-white rounded hover:bg-blue-700">
                        Start Chat
                    </button>
                </div>
            </div>
        </div>
    </div>

    <script>
        let selectedTenantId = null;

        function startChat(tenantId) {
            selectedTenantId = tenantId;
            document.getElementById('startChatModal').classList.remove('hidden');
        }

        function closeChatModal() {
            document.getElementById('startChatModal').classList.add('hidden');
            selectedTenantId = null;
        }

        function confirmStartChat() {
            if (selectedTenantId) {
                const form = document.createElement('form');
                form.method = 'POST';
                form.action = '<?php echo e(route('admin.chat.start')); ?>';
                
                const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
                const csrfInput = document.createElement('input');
                csrfInput.type = 'hidden';
                csrfInput.name = '_token';
                csrfInput.value = csrfToken;
                form.appendChild(csrfInput);
                
                const tenantInput = document.createElement('input');
                tenantInput.type = 'hidden';
                tenantInput.name = 'tenant_id';
                tenantInput.value = selectedTenantId;
                form.appendChild(tenantInput);
                
                document.body.appendChild(form);
                form.submit();
            }
        }
    </script>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal91fdd17964e43374ae18c674f95cdaa3)): ?>
<?php $attributes = $__attributesOriginal91fdd17964e43374ae18c674f95cdaa3; ?>
<?php unset($__attributesOriginal91fdd17964e43374ae18c674f95cdaa3); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal91fdd17964e43374ae18c674f95cdaa3)): ?>
<?php $component = $__componentOriginal91fdd17964e43374ae18c674f95cdaa3; ?>
<?php unset($__componentOriginal91fdd17964e43374ae18c674f95cdaa3); ?>
<?php endif; ?>
<?php /**PATH D:\laragon\www\Laravel_gorsary\resources\views/admin/reports/customers.blade.php ENDPATH**/ ?>