<?php if (isset($component)) { $__componentOriginal91fdd17964e43374ae18c674f95cdaa3 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal91fdd17964e43374ae18c674f95cdaa3 = $attributes; } ?>
<?php $component = App\View\Components\AdminLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('admin-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AdminLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            Notifications
            <?php if($unreadCount > 0): ?>
                <span class="ml-2 inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-red-100 text-red-800">
                    <?php echo e($unreadCount); ?> unread
                </span>
            <?php endif; ?>
        </h2>
     <?php $__env->endSlot(); ?>

    <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
        <!-- Actions -->
        <div class="mb-6 flex justify-between items-center">
            <div>
                <a href="<?php echo e(route('admin.notifications.create')); ?>" 
                   class="bg-blue-600 text-white px-4 py-2 rounded-md hover:bg-blue-700">
                    Send New Notification
                </a>
                <?php if($unreadCount > 0): ?>
                    <button onclick="markAllAsRead()" 
                            class="ml-3 text-gray-600 hover:text-gray-800">
                        Mark All as Read
                    </button>
                <?php endif; ?>
            </div>
            <div class="text-sm text-gray-500">
                Total: <?php echo e($notifications->total()); ?> notifications
            </div>
        </div>

        <!-- Notifications List -->
        <div class="bg-white shadow-sm rounded-lg">
            <div class="divide-y divide-gray-200">
                <?php $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="p-6 hover:bg-gray-50 <?php echo e(!$notification->is_read ? 'bg-blue-50' : ''); ?>">
                        <div class="flex items-start justify-between">
                            <div class="flex-1">
                                <div class="flex items-center">
                                    <div class="flex-shrink-0">
                                        <div class="inline-flex items-center justify-center w-8 h-8 rounded-full
                                            <?php if($notification->type === 'info'): ?> bg-blue-100 text-blue-600
                                            <?php elseif($notification->type === 'success'): ?> bg-green-100 text-green-600
                                            <?php elseif($notification->type === 'warning'): ?> bg-yellow-100 text-yellow-600
                                            <?php elseif($notification->type === 'error'): ?> bg-red-100 text-red-600
                                            <?php else: ?> bg-gray-100 text-gray-600 <?php endif; ?>">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <?php if($notification->type === 'info'): ?>
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                                <?php elseif($notification->type === 'success'): ?>
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                                <?php elseif($notification->type === 'warning'): ?>
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L4.082 15.5c-.77.833.192 2.5 1.732 2.5z"></path>
                                                <?php elseif($notification->type === 'error'): ?>
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                                <?php else: ?>
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                                <?php endif; ?>
                                            </svg>
                                        </div>
                                    </div>
                                    <div class="ml-3">
                                        <h3 class="text-lg font-medium text-gray-900">
                                            <?php echo e($notification->title); ?>

                                            <?php if(!$notification->is_read): ?>
                                                <span class="ml-2 inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
                                                    New
                                                </span>
                                            <?php endif; ?>
                                        </h3>
                                        <p class="mt-1 text-sm text-gray-600"><?php echo e($notification->message); ?></p>
                                        <div class="mt-2 flex items-center space-x-4 text-xs text-gray-500">
                                            <span>
                                                <?php if($notification->target_type === 'all'): ?>
                                                    All tenants
                                                <?php elseif($notification->target_type === 'tenant'): ?>
                                                    Specific tenant
                                                <?php else: ?>
                                                    Customer
                                                <?php endif; ?>
                                            </span>
                                            <span>Sent by <?php echo e($notification->sender->name ?? 'System'); ?></span>
                                            <span><?php echo e($notification->sent_at->diffForHumans()); ?></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="ml-4 flex-shrink-0 flex space-x-2">
                                <a href="<?php echo e(route('admin.notifications.show', $notification->id)); ?>" 
                                   class="text-blue-600 hover:text-blue-900 text-sm">
                                    View
                                </a>
                                <?php if(!$notification->is_read): ?>
                                    <button onclick="markAsRead(<?php echo e($notification->id); ?>)" 
                                            class="text-green-600 hover:text-green-900 text-sm">
                                        Mark Read
                                    </button>
                                <?php endif; ?>
                                <form action="<?php echo e(route('admin.notifications.destroy', $notification->id)); ?>" 
                                      method="POST" onsubmit="return confirm('Are you sure?')">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="text-red-600 hover:text-red-900 text-sm">
                                        Delete
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <!-- Pagination -->
            <div class="p-4 border-t">
                <?php echo e($notifications->links()); ?>

            </div>
        </div>
    </div>

    <script>
        function markAsRead(id) {
            fetch(`<?php echo e(route('admin.notifications.read', ':id')); ?>`.replace(':id', id), {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    location.reload();
                }
            });
        }

        function markAllAsRead() {
            if (confirm('Mark all notifications as read?')) {
                fetch('<?php echo e(route('admin.notifications.read-all')); ?>', {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                    }
                })
                .then(() => {
                    location.reload();
                });
            }
        }
    </script>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal91fdd17964e43374ae18c674f95cdaa3)): ?>
<?php $attributes = $__attributesOriginal91fdd17964e43374ae18c674f95cdaa3; ?>
<?php unset($__attributesOriginal91fdd17964e43374ae18c674f95cdaa3); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal91fdd17964e43374ae18c674f95cdaa3)): ?>
<?php $component = $__componentOriginal91fdd17964e43374ae18c674f95cdaa3; ?>
<?php unset($__componentOriginal91fdd17964e43374ae18c674f95cdaa3); ?>
<?php endif; ?>
<?php /**PATH D:\laragon\www\Laravel_gorsary\resources\views/admin/notifications/index.blade.php ENDPATH**/ ?>