<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
        <title><?php echo e(config('app.name', 'SaaS Admin')); ?> - Developer Dashboard</title>
        <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
        <style>
            [x-cloak] { display: none !important; }
        </style>
    </head>
    <body class="font-sans antialiased text-gray-900 bg-gray-100" x-data="{ sidebarOpen: true }">
        <div class="flex h-screen overflow-hidden">
            <!-- Sidebar -->
            <div :class="sidebarOpen ? 'w-64' : 'w-20'" class="bg-purple-900 text-white flex-shrink-0 flex flex-col h-full transition-all duration-300">
                <div class="flex-shrink-0 flex items-center" :class="sidebarOpen ? 'p-6 justify-between' : 'p-4 justify-center'">
                    <div x-show="sidebarOpen" class="overflow-hidden whitespace-nowrap">
                        <h1 class="text-2xl font-bold text-white">Developer</h1>
                        <p class="text-xs text-purple-300 mt-1">Developer Console</p>
                    </div>
                    <button @click="sidebarOpen = !sidebarOpen" class="text-purple-300 hover:text-white focus:outline-none" :class="sidebarOpen ? '' : 'mb-4'">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                        </svg>
                    </button>
                </div>
                
                <!-- Scrollable Navigation -->
                <div class="flex-1 overflow-y-auto scrollbar-thin scrollbar-thumb-purple-700 scrollbar-track-purple-900">
                    <nav class="mt-2 space-y-1 px-2 pb-4">
                        <a href="<?php echo e(route('developer.dashboard')); ?>" class="block py-3 rounded transition flex items-center <?php echo e(request()->routeIs('developer.dashboard') ? 'bg-purple-800 text-white' : 'text-purple-200 hover:bg-purple-800 hover:text-white'); ?>" :class="sidebarOpen ? 'px-4' : 'px-2 justify-center'" :title="!sidebarOpen ? 'Dashboard' : ''">
                            <span class="inline-block w-5 text-center text-xl" :class="sidebarOpen ? 'mr-2' : ''">📊</span> 
                            <span x-show="sidebarOpen" class="whitespace-nowrap">Dashboard</span>
                        </a>
                        <a href="<?php echo e(route('developer.tenants')); ?>" class="block py-3 rounded transition flex items-center <?php echo e(request()->routeIs('developer.tenants.*') ? 'bg-purple-800 text-white' : 'text-purple-200 hover:bg-purple-800 hover:text-white'); ?>" :class="sidebarOpen ? 'px-4' : 'px-2 justify-center'" :title="!sidebarOpen ? 'Tenants' : ''">
                            <span class="inline-block w-5 text-center text-xl" :class="sidebarOpen ? 'mr-2' : ''">🏢</span>
                            <span x-show="sidebarOpen" class="whitespace-nowrap">Tenants</span>
                        </a>
                        <a href="<?php echo e(route('developer.database')); ?>" class="block py-3 rounded transition flex items-center <?php echo e(request()->routeIs('developer.database') ? 'bg-purple-800 text-white' : 'text-purple-200 hover:bg-purple-800 hover:text-white'); ?>" :class="sidebarOpen ? 'px-4' : 'px-2 justify-center'" :title="!sidebarOpen ? 'Database' : ''">
                            <span class="inline-block w-5 text-center text-xl" :class="sidebarOpen ? 'mr-2' : ''">🗄️</span>
                            <span x-show="sidebarOpen" class="whitespace-nowrap">Database</span>
                        </a>
                        <a href="<?php echo e(route('developer.logs')); ?>" class="block py-3 rounded transition flex items-center <?php echo e(request()->routeIs('developer.logs') ? 'bg-purple-800 text-white' : 'text-purple-200 hover:bg-purple-800 hover:text-white'); ?>" :class="sidebarOpen ? 'px-4' : 'px-2 justify-center'" :title="!sidebarOpen ? 'Logs' : ''">
                            <span class="inline-block w-5 text-center text-xl" :class="sidebarOpen ? 'mr-2' : ''">📋</span>
                            <span x-show="sidebarOpen" class="whitespace-nowrap">Logs</span>
                        </a>

                        <div x-show="sidebarOpen" class="px-4 py-2 text-xs font-semibold text-purple-300 uppercase tracking-wider mt-2">
                            Developer Tools
                        </div>
                        <a href="<?php echo e(route('developer.roles.index')); ?>" class="block py-3 rounded transition flex items-center <?php echo e(request()->routeIs('developer.roles.*') ? 'bg-purple-800 text-white' : 'text-purple-200 hover:bg-purple-800 hover:text-white'); ?>" :class="sidebarOpen ? 'px-4' : 'px-2 justify-center'" :title="!sidebarOpen ? 'Roles & Permissions' : ''">
                            <span class="inline-block w-5 text-center text-xl" :class="sidebarOpen ? 'mr-2' : ''">🛡️</span>
                            <span x-show="sidebarOpen" class="whitespace-nowrap">Roles & Permissions</span>
                        </a>
                        <a href="<?php echo e(route('developer.users.index')); ?>" class="block py-3 rounded transition flex items-center <?php echo e(request()->routeIs('developer.users.*') ? 'bg-purple-800 text-white' : 'text-purple-200 hover:bg-purple-800 hover:text-white'); ?>" :class="sidebarOpen ? 'px-4' : 'px-2 justify-center'" :title="!sidebarOpen ? 'Users' : ''">
                            <span class="inline-block w-5 text-center text-xl" :class="sidebarOpen ? 'mr-2' : ''">👥</span>
                            <span x-show="sidebarOpen" class="whitespace-nowrap">Users</span>
                        </a>
                        <a href="<?php echo e(route('developer.server.config')); ?>" class="block py-3 rounded transition flex items-center <?php echo e(request()->routeIs('developer.server.config') ? 'bg-purple-800 text-white' : 'text-purple-200 hover:bg-purple-800 hover:text-white'); ?>" :class="sidebarOpen ? 'px-4' : 'px-2 justify-center'" :title="!sidebarOpen ? 'Server Config' : ''">
                            <span class="inline-block w-5 text-center text-xl" :class="sidebarOpen ? 'mr-2' : ''">⚙️</span>
                            <span x-show="sidebarOpen" class="whitespace-nowrap">Server Config</span>
                        </a>

                        <div x-show="sidebarOpen" class="px-4 py-2 text-xs font-semibold text-purple-300 uppercase tracking-wider mt-2">
                            Monitoring & DB
                        </div>
                        <a href="<?php echo e(route('developer.monitoring')); ?>" class="block py-3 rounded transition flex items-center <?php echo e(request()->routeIs('developer.monitoring') && !request()->query('view') ? 'bg-purple-800 text-white' : 'text-purple-200 hover:bg-purple-800 hover:text-white'); ?>" :class="sidebarOpen ? 'px-4' : 'px-2 justify-center'" :title="!sidebarOpen ? 'App Monitoring' : ''">
                            <span class="inline-block w-5 text-center text-xl" :class="sidebarOpen ? 'mr-2' : ''">🖥️</span>
                            <span x-show="sidebarOpen" class="whitespace-nowrap">App Monitoring</span>
                        </a>
                        <a href="<?php echo e(route('developer.requests.index')); ?>" class="block py-3 rounded transition flex items-center <?php echo e(request()->routeIs('developer.requests.*') ? 'bg-purple-800 text-white' : 'text-purple-200 hover:bg-purple-800 hover:text-white'); ?>" :class="sidebarOpen ? 'px-4' : 'px-2 justify-center'" :title="!sidebarOpen ? 'Request Monitor' : ''">
                            <span class="inline-block w-5 text-center text-xl" :class="sidebarOpen ? 'mr-2' : ''">📡</span>
                            <span x-show="sidebarOpen" class="whitespace-nowrap">Request Monitor</span>
                        </a>
                        <a href="<?php echo e(route('developer.monitoring')); ?>?view=queries" class="block py-3 rounded transition flex items-center <?php echo e(request()->query('view') === 'queries' ? 'bg-purple-800 text-white' : 'text-purple-200 hover:bg-purple-800 hover:text-white'); ?>" :class="sidebarOpen ? 'px-4' : 'px-2 justify-center'" :title="!sidebarOpen ? 'Active Queries' : ''">
                            <span class="inline-block w-5 text-center text-xl" :class="sidebarOpen ? 'mr-2' : ''">⚡</span>
                            <span x-show="sidebarOpen" class="whitespace-nowrap">Active Queries</span>
                        </a>
                        <a href="<?php echo e(route('developer.chat.index')); ?>" class="block py-3 rounded transition flex items-center <?php echo e(request()->routeIs('developer.chat.*') ? 'bg-purple-800 text-white' : 'text-purple-200 hover:bg-purple-800 hover:text-white'); ?>" :class="sidebarOpen ? 'px-4' : 'px-2 justify-center'" :title="!sidebarOpen ? 'Chat Monitor' : ''">
                            <span class="inline-block w-5 text-center text-xl" :class="sidebarOpen ? 'mr-2' : ''">💬</span>
                            <span x-show="sidebarOpen" class="whitespace-nowrap">Chat Monitor</span>
                        </a>
                        <a href="<?php echo e(route('developer.reports.analytics')); ?>" class="block py-3 rounded transition flex items-center <?php echo e(request()->routeIs('developer.reports.*') ? 'bg-purple-800 text-white' : 'text-purple-200 hover:bg-purple-800 hover:text-white'); ?>" :class="sidebarOpen ? 'px-4' : 'px-2 justify-center'" :title="!sidebarOpen ? 'Analytics' : ''">
                            <span class="inline-block w-5 text-center text-xl" :class="sidebarOpen ? 'mr-2' : ''">📊</span>
                            <span x-show="sidebarOpen" class="whitespace-nowrap">Analytics</span>
                        </a>
                    </nav>
                </div>

                <!-- Footer User Profile -->
                <div class="bg-purple-900 border-t border-purple-800 flex-shrink-0" :class="sidebarOpen ? 'p-6' : 'p-2'">
                    <div class="flex items-center mb-4 hover:bg-purple-800 rounded p-2 transition" :class="sidebarOpen ? '' : 'justify-center mb-0'">
                        <div class="h-8 w-8 rounded-full bg-purple-500 flex items-center justify-center text-white font-bold" :class="sidebarOpen ? 'mr-3' : ''">
                            <?php echo e(substr(Auth::user()->name, 0, 1)); ?>

                        </div>
                        <div x-show="sidebarOpen">
                            <p class="text-sm font-medium text-white"><?php echo e(Auth::user()->name); ?></p>
                            <p class="text-xs text-purple-300">Developer</p>
                        </div>
                    </div>
                    <form method="POST" action="<?php echo e(route('logout')); ?>" x-show="sidebarOpen">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="flex items-center text-purple-300 hover:text-white transition text-sm">
                            <span class="mr-2">🚪</span> Logout
                        </button>
                    </form>
                    <form method="POST" action="<?php echo e(route('logout')); ?>" x-show="!sidebarOpen" class="flex justify-center">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="text-purple-300 hover:text-white transition" title="Logout">
                            <span class="text-xl">🚪</span>
                        </button>
                    </form>
                </div>
            </div>

            <!-- Main Content -->
            <div class="flex-1 flex flex-col overflow-hidden">
                <!-- Top Header -->
                <header class="bg-white shadow-sm z-10">
                    <div class="max-w-7xl mx-auto py-4 px-4 sm:px-6 lg:px-8 flex items-center justify-between">
                        <div>
                            <h1 class="text-2xl font-semibold text-gray-900">Developer Dashboard</h1>
                            <p class="text-sm text-gray-500">Monitor and manage system components</p>
                        </div>
                        <div class="flex items-center space-x-4">
                            <span class="text-sm text-gray-500">
                                <?php echo e(now()->format('M j, Y H:i A')); ?>

                            </span>
                        </div>
                    </div>
                </header>

                <!-- Page Content -->
                <main class="flex-1 overflow-x-hidden overflow-y-auto bg-gray-100 p-6">
                    <?php if(session('success')): ?>
                        <div class="max-w-7xl mx-auto mb-4 px-4 sm:px-6 lg:px-8">
                            <div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 rounded shadow-sm flex items-center justify-between" role="alert">
                                <div class="flex items-center">
                                    <span class="mr-2">✅</span>
                                    <p><?php echo e(session('success')); ?></p>
                                </div>
                                <button onclick="this.parentElement.remove()" class="text-green-700 hover:text-green-900">
                                    <svg class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                                    </svg>
                                </button>
                            </div>
                        </div>
                    <?php endif; ?>

                    <?php if(session('error')): ?>
                        <div class="max-w-7xl mx-auto mb-4 px-4 sm:px-6 lg:px-8">
                            <div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 rounded shadow-sm flex items-center justify-between" role="alert">
                                <div class="flex items-center">
                                    <span class="mr-2">❌</span>
                                    <p><?php echo e(session('error')); ?></p>
                                </div>
                                <button onclick="this.parentElement.remove()" class="text-red-700 hover:text-red-900">
                                    <svg class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                                    </svg>
                                </button>
                            </div>
                        </div>
                    <?php endif; ?>

                    <?php echo $__env->yieldContent('content'); ?>
                </main>
            </div>
        </div>
        <?php echo $__env->yieldPushContent('scripts'); ?>
    </body>
</html>
<?php /**PATH D:\laragon\www\Laravel_gorsary\resources\views/layouts/developer.blade.php ENDPATH**/ ?>