<?php if (isset($component)) { $__componentOriginal3f11930a8702d3d700513f5d743b90ca = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal3f11930a8702d3d700513f5d743b90ca = $attributes; } ?>
<?php $component = App\View\Components\TenantLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('tenant-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\TenantLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <h2 class="text-xl font-semibold text-gray-800">
            Notifications
            <?php if($unreadCount > 0): ?>
                <span class="ml-2 inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
                    <?php echo e($unreadCount); ?> unread
                </span>
            <?php endif; ?>
        </h2>
     <?php $__env->endSlot(); ?>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Actions -->
        <div class="mb-6 flex justify-between items-center">
            <div class="flex items-center space-x-4">
                <button onclick="markAllAsRead()" 
                        class="text-gray-600 hover:text-gray-800 text-sm">
                    Mark All as Read
                </button>
                <button onclick="refreshNotifications()" 
                        class="text-gray-600 hover:text-gray-800 text-sm">
                    Refresh
                </button>
            </div>
            <div class="text-sm text-gray-500">
                Total: <?php echo e($notifications->total()); ?> notifications
            </div>
        </div>

        <!-- Notifications List -->
        <div class="bg-white shadow-sm rounded-lg">
            <div class="divide-y divide-gray-200">
                <?php $__empty_1 = true; $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="p-6 hover:bg-gray-50 <?php echo e(!$notification->is_read ? 'bg-blue-50' : ''); ?> cursor-pointer" 
                         onclick="viewNotification(<?php echo e($notification->id); ?>)">
                        <div class="flex items-start justify-between">
                            <div class="flex-1">
                                <div class="flex items-center">
                                    <div class="flex-shrink-0">
                                        <div class="inline-flex items-center justify-center w-8 h-8 rounded-full
                                            <?php if($notification->type === 'info'): ?> bg-blue-100 text-blue-600
                                            <?php elseif($notification->type === 'success'): ?> bg-green-100 text-green-600
                                            <?php elseif($notification->type === 'warning'): ?> bg-yellow-100 text-yellow-600
                                            <?php elseif($notification->type === 'error'): ?> bg-red-100 text-red-600
                                            <?php else: ?> bg-gray-100 text-gray-600 <?php endif; ?>">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <?php if($notification->type === 'info'): ?>
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                                <?php elseif($notification->type === 'success'): ?>
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                                <?php elseif($notification->type === 'warning'): ?>
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L4.082 15.5c-.77.833.192 2.5 1.732 2.5z"></path>
                                                <?php elseif($notification->type === 'error'): ?>
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                                <?php else: ?>
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                                <?php endif; ?>
                                            </svg>
                                        </div>
                                    </div>
                                    <div class="ml-3">
                                        <h3 class="text-lg font-medium text-gray-900">
                                            <?php echo e($notification->title); ?>

                                            <?php if(!$notification->is_read): ?>
                                                <span class="ml-2 inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
                                                    New
                                                </span>
                                            <?php endif; ?>
                                        </h3>
                                        <p class="mt-1 text-sm text-gray-600"><?php echo e($notification->message); ?></p>
                                        <div class="mt-2 flex items-center space-x-4 text-xs text-gray-500">
                                            <span>From: Admin</span>
                                            <span><?php echo e($notification->sent_at->diffForHumans()); ?></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="ml-4 flex-shrink-0 flex space-x-2">
                                <?php if(!$notification->is_read): ?>
                                    <button onclick="event.stopPropagation(); markAsRead(<?php echo e($notification->id); ?>)" 
                                            class="text-green-600 hover:text-green-900 text-sm">
                                        Mark Read
                                    </button>
                                <?php endif; ?>
                                <button onclick="event.stopPropagation(); deleteNotification(<?php echo e($notification->id); ?>)" 
                                        class="text-red-600 hover:text-red-900 text-sm">
                                    Delete
                                </button>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="p-6 text-center">
                        <div class="text-gray-400">
                            <svg class="w-12 h-12 mx-auto mb-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9"></path>
                            </svg>
                            <p class="text-sm">No notifications found</p>
                        </div>
                    </div>
                <?php endif; ?>
            </div>

            <!-- Pagination -->
            <?php if($notifications->hasPages()): ?>
                <div class="p-4 border-t">
                    <?php echo e($notifications->links()); ?>

                </div>
            <?php endif; ?>
        </div>
    </div>

    <script>
        function viewNotification(id) {
            window.location.href = `<?php echo e(route('tenant.notifications.show', ':id')); ?>`.replace(':id', id);
        }

        function markAsRead(id) {
            fetch(`<?php echo e(route('tenant.notifications.read', ':id')); ?>`.replace(':id', id), {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    location.reload();
                }
            });
        }

        function markAllAsRead() {
            if (confirm('Mark all notifications as read?')) {
                fetch('<?php echo e(route('tenant.notifications.read-all')); ?>', {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                    }
                })
                .then(() => {
                    location.reload();
                });
            }
        }

        function deleteNotification(id) {
            if (confirm('Are you sure you want to delete this notification?')) {
                fetch(`<?php echo e(route('tenant.notifications.show', ':id')); ?>`.replace(':id', id), {
                    method: 'DELETE',
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                    }
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        location.reload();
                    }
                });
            }
        }

        function refreshNotifications() {
            location.reload();
        }

        // Auto-refresh every 30 seconds
        setInterval(() => {
            fetch('<?php echo e(route('tenant.notifications.unread-count')); ?>')
                .then(response => response.json())
                .then(data => {
                    // Update unread count in header if it changes
                    const currentCount = parseInt('<?php echo e($unreadCount); ?>');
                    if (data.count !== currentCount) {
                        location.reload();
                    }
                });
        }, 30000);
    </script>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal3f11930a8702d3d700513f5d743b90ca)): ?>
<?php $attributes = $__attributesOriginal3f11930a8702d3d700513f5d743b90ca; ?>
<?php unset($__attributesOriginal3f11930a8702d3d700513f5d743b90ca); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal3f11930a8702d3d700513f5d743b90ca)): ?>
<?php $component = $__componentOriginal3f11930a8702d3d700513f5d743b90ca; ?>
<?php unset($__componentOriginal3f11930a8702d3d700513f5d743b90ca); ?>
<?php endif; ?>
<?php /**PATH D:\laragon\www\Laravel_gorsary\resources\views/tenant/notifications/index.blade.php ENDPATH**/ ?>