<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Register Your Grocery Business - Grocery SaaS Platform</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        .grocery-gradient {
            background: linear-gradient(135deg, #22c55e 0%, #16a34a 50%, #15803d 100%);
        }
        .floating {
            animation: float 6s ease-in-out infinite;
        }
        @keyframes float {
            0%, 100% { transform: translateY(0px); }
            50% { transform: translateY(-20px); }
        }
        .slide-in {
            animation: slideIn 0.5s ease-out;
        }
        @keyframes slideIn {
            from { transform: translateX(-100%); opacity: 0; }
            to { transform: translateX(0); opacity: 1; }
        }
    </style>
</head>
<body class="min-h-screen bg-gray-50">
    <!-- Background Pattern -->
    <div class="fixed inset-0 opacity-5">
        <div class="absolute inset-0" style="background-image: url('data:image/svg+xml,%3Csvg width="60" height="60" viewBox="0 0 60 60" xmlns="http://www.w3.org/2000/svg"%3E%3Cg fill="none" fill-rule="evenodd"%3E%3Cg fill="%23000000" fill-opacity="0.4"%3E%3Cpath d="M36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v2h4v4h2V6h4V4H6z"/%3E%3C/g%3E%3C/g%3E%3C/svg%3E');"></div>
    </div>

    <!-- Header -->
    <header class="relative grocery-gradient text-white">
        <div class="container mx-auto px-4 py-6">
            <div class="flex items-center justify-between">
                <div class="flex items-center space-x-3">
                    <div class="bg-white rounded-lg p-2">
                        <i class="fas fa-store text-green-600 text-2xl"></i>
                    </div>
                    <div>
                        <h1 class="text-2xl font-bold">Grocery SaaS</h1>
                        <p class="text-green-100 text-sm">Complete POS & Inventory Management</p>
                    </div>
                </div>
                <nav class="hidden md:flex space-x-6">
                    <a href="#" class="hover:text-green-200 transition">Features</a>
                    <a href="#" class="hover:text-green-200 transition">Pricing</a>
                    <a href="<?php echo e(route('login')); ?>" class="hover:text-green-200 transition">Login</a>
                </nav>
            </div>
        </div>
    </header>

    <!-- Main Content -->
    <main class="relative py-12">
        <div class="container mx-auto px-4">
            <div class="max-w-6xl mx-auto">
                <div class="grid lg:grid-cols-2 gap-12 items-center">
                    
                    <!-- Left Side - Hero Content -->
                    <div class="slide-in">
                        <div class="floating">
                            <div class="bg-green-100 rounded-2xl p-8 mb-8">
                                <i class="fas fa-shopping-cart text-green-600 text-6xl mb-6"></i>
                                <h2 class="text-3xl font-bold text-gray-800 mb-4">
                                    Start Your Grocery Business Today
                                </h2>
                                <p class="text-gray-600 mb-6">
                                    Join thousands of grocery stores using our comprehensive POS and inventory management system. 
                                    Manage products, track sales, handle variants, and grow your business with ease.
                                </p>
                                
                                <!-- Features List -->
                                <div class="space-y-4 mb-8">
                                    <div class="flex items-center space-x-3">
                                        <div class="bg-green-500 text-white rounded-full p-2">
                                            <i class="fas fa-check text-sm"></i>
                                        </div>
                                        <span class="text-gray-700">Complete POS System</span>
                                    </div>
                                    <div class="flex items-center space-x-3">
                                        <div class="bg-green-500 text-white rounded-full p-2">
                                            <i class="fas fa-check text-sm"></i>
                                        </div>
                                        <span class="text-gray-700">Product Variant Management</span>
                                    </div>
                                    <div class="flex items-center space-x-3">
                                        <div class="bg-green-500 text-white rounded-full p-2">
                                            <i class="fas fa-check text-sm"></i>
                                        </div>
                                        <span class="text-gray-700">Real-time Inventory Tracking</span>
                                    </div>
                                    <div class="flex items-center space-x-3">
                                        <div class="bg-green-500 text-white rounded-full p-2">
                                            <i class="fas fa-check text-sm"></i>
                                        </div>
                                        <span class="text-gray-700">Multi-tenant Architecture</span>
                                    </div>
                                </div>

                                <!-- Stats -->
                                <div class="grid grid-cols-3 gap-4 text-center">
                                    <div class="bg-white rounded-lg p-4">
                                        <div class="text-2xl font-bold text-green-600">1000+</div>
                                        <div class="text-sm text-gray-600">Active Stores</div>
                                    </div>
                                    <div class="bg-white rounded-lg p-4">
                                        <div class="text-2xl font-bold text-green-600">50K+</div>
                                        <div class="text-sm text-gray-600">Products Managed</div>
                                    </div>
                                    <div class="bg-white rounded-lg p-4">
                                        <div class="text-2xl font-bold text-green-600">99.9%</div>
                                        <div class="text-sm text-gray-600">Uptime</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Right Side - Registration Form -->
                    <div class="slide-in" style="animation-delay: 0.2s;">
                        <div class="bg-white rounded-2xl shadow-xl p-8">
                            <div class="text-center mb-8">
                                <div class="bg-green-100 rounded-full p-4 w-20 h-20 mx-auto mb-4 flex items-center justify-center">
                                    <i class="fas fa-store text-green-600 text-3xl"></i>
                                </div>
                                <h3 class="text-2xl font-bold text-gray-800 mb-2">Register Your Business</h3>
                                <p class="text-gray-600">Create your grocery store in minutes</p>
                            </div>

                            <form method="POST" action="<?php echo e(route('register')); ?>" class="space-y-6">
                                <?php echo csrf_field(); ?>

                                <!-- Business Name -->
                                <div>
                                    <label for="business_name" class="block text-sm font-medium text-gray-700 mb-2">
                                        <i class="fas fa-store text-green-600 mr-2"></i>
                                        Business Name
                                    </label>
                                    <input id="business_name" 
                                           class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-green-500 focus:border-transparent transition" 
                                           type="text" 
                                           name="business_name" 
                                           value="<?php echo e(old('business_name')); ?>" 
                                           placeholder="e.g., Fresh Mart Grocery" 
                                           required 
                                           autofocus />
                                    <?php $__errorArgs = ['business_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <p class="mt-2 text-sm text-red-600 flex items-center">
                                            <i class="fas fa-exclamation-circle mr-1"></i>
                                            <?php echo e($message); ?>

                                        </p>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <!-- Domain (Subdomain) -->
                                <div>
                                    <label for="domain" class="block text-sm font-medium text-gray-700 mb-2">
                                        <i class="fas fa-globe text-green-600 mr-2"></i>
                                        Store Domain (Auto-generated)
                                    </label>
                                    <div class="flex">
                                        <input id="domain" 
                                               class="flex-1 px-4 py-3 border border-gray-300 rounded-l-lg focus:ring-2 focus:ring-green-500 focus:border-transparent transition bg-gray-50" 
                                               type="text" 
                                               name="domain" 
                                               value="<?php echo e(old('domain')); ?>" 
                                               placeholder="yourstore" 
                                               required />
                                        <span class="inline-flex items-center px-4 rounded-r-lg border border-l-0 border-gray-300 bg-gray-100 text-gray-600 text-sm font-medium">
                                            .grocery-saas.local
                                        </span>
                                    </div>
                                    <p class="mt-2 text-xs text-gray-500">This will be your unique store URL</p>
                                    <?php $__errorArgs = ['domain'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <p class="mt-2 text-sm text-red-600 flex items-center">
                                            <i class="fas fa-exclamation-circle mr-1"></i>
                                            <?php echo e($message); ?>

                                        </p>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <!-- Full Name -->
                                <div>
                                    <label for="name" class="block text-sm font-medium text-gray-700 mb-2">
                                        <i class="fas fa-user text-green-600 mr-2"></i>
                                        Your Full Name
                                    </label>
                                    <input id="name" 
                                           class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-green-500 focus:border-transparent transition" 
                                           type="text" 
                                           name="name" 
                                           value="<?php echo e(old('name')); ?>" 
                                           placeholder="John Doe" 
                                           required />
                                    <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <p class="mt-2 text-sm text-red-600 flex items-center">
                                            <i class="fas fa-exclamation-circle mr-1"></i>
                                            <?php echo e($message); ?>

                                        </p>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <!-- Email Address -->
                                <div>
                                    <label for="email" class="block text-sm font-medium text-gray-700 mb-2">
                                        <i class="fas fa-envelope text-green-600 mr-2"></i>
                                        Email Address
                                    </label>
                                    <input id="email" 
                                           class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-green-500 focus:border-transparent transition" 
                                           type="email" 
                                           name="email" 
                                           value="<?php echo e(old('email')); ?>" 
                                           placeholder="john@example.com" 
                                           required />
                                    <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <p class="mt-2 text-sm text-red-600 flex items-center">
                                            <i class="fas fa-exclamation-circle mr-1"></i>
                                            <?php echo e($message); ?>

                                        </p>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <!-- Phone Number -->
                                <div>
                                    <label for="phone_number" class="block text-sm font-medium text-gray-700 mb-2">
                                        <i class="fas fa-phone text-green-600 mr-2"></i>
                                        Phone Number (Bangladesh Format)
                                    </label>
                                    <input id="phone_number" 
                                           class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-green-500 focus:border-transparent transition" 
                                           type="text" 
                                           name="phone_number" 
                                           value="<?php echo e(old('phone_number')); ?>" 
                                           placeholder="01712345678" 
                                           pattern="01[3-9][0-9]{8}"
                                           title="Please enter a valid Bangladesh phone number (e.g., 01712345678)"
                                           required />
                                    <?php $__errorArgs = ['phone_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <p class="mt-2 text-sm text-red-600 flex items-center">
                                            <i class="fas fa-exclamation-circle mr-1"></i>
                                            <?php echo e($message); ?>

                                        </p>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                

                                <!-- Terms and Conditions -->
                                <div class="flex items-start">
                                    <input id="terms" 
                                           class="mt-1 w-4 h-4 text-green-600 border-gray-300 rounded focus:ring-green-500" 
                                           type="checkbox" 
                                           name="terms" 
                                           required />
                                    <label for="terms" class="ml-2 text-sm text-gray-600">
                                        I agree to the <a href="javascript:void(0)" onclick="openModal('terms')" class="text-green-600 hover:text-green-500">Terms of Service</a> 
                                        and <a href="javascript:void(0)" onclick="openModal('privacy')" class="text-green-600 hover:text-green-500">Privacy Policy</a>
                                    </label>
                                </div>

                                <!-- Submit Button -->
                                <div class="space-y-4">
                                    <button type="submit" 
                                            class="w-full grocery-gradient text-white font-semibold py-4 px-6 rounded-lg hover:opacity-90 transition duration-200 flex items-center justify-center space-x-2">
                                        <i class="fas fa-rocket"></i>
                                        <span>Create Your Grocery Store</span>
                                    </button>

                                    <div class="text-center">
                                        <span class="text-gray-600">Already have an account?</span>
                                        <a href="<?php echo e(route('login')); ?>" class="ml-1 text-green-600 hover:text-green-500 font-medium">
                                            Sign In
                                        </a>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <!-- Footer -->
    <footer class="bg-gray-800 text-white py-8 mt-16">
        <div class="container mx-auto px-4">
            <div class="text-center">
                <div class="flex items-center justify-center space-x-2 mb-4">
                    <i class="fas fa-store text-green-400"></i>
                    <span class="text-xl font-bold">Grocery SaaS</span>
                </div>
                <p class="text-gray-400 mb-4">Complete POS & Inventory Management for Grocery Stores</p>
                <div class="flex justify-center space-x-6 text-gray-400">
                    <a href="#" class="hover:text-green-400 transition">Privacy Policy</a>
                    <a href="#" class="hover:text-green-400 transition">Terms of Service</a>
                    <a href="#" class="hover:text-green-400 transition">Contact</a>
                    <a href="#" class="hover:text-green-400 transition">Support</a>
                </div>
                <p class="text-gray-500 text-sm mt-6">© 2026 Grocery SaaS Platform. All rights reserved.</p>
            </div>
        </div>
    </footer>

    <!-- Success Modal (Hidden by default) -->
    <div id="successModal" class="fixed inset-0 bg-black bg-opacity-50 hidden items-center justify-center z-50">
        <div class="bg-white rounded-2xl p-8 max-w-md mx-4 text-center">
            <div class="bg-green-100 rounded-full p-4 w-20 h-20 mx-auto mb-4 flex items-center justify-center">
                <i class="fas fa-check text-green-600 text-3xl"></i>
            </div>
            <h3 class="text-2xl font-bold text-gray-800 mb-2">Registration Successful!</h3>
            <p class="text-gray-600 mb-6">Your grocery store is being set up. You'll be redirected to your dashboard shortly.</p>
            <div class="bg-green-50 rounded-lg p-4">
                <p class="text-sm text-green-800">Store URL: <strong id="storeUrl"></strong></p>
            </div>
        </div>
    </div>

    <!-- Policy Modal -->
    <div id="policyModal" class="fixed inset-0 bg-black bg-opacity-50 hidden items-center justify-center z-[60]">
        <div class="bg-white rounded-2xl p-8 max-w-2xl mx-4 w-full max-h-[80vh] flex flex-col">
            <div class="flex justify-between items-center mb-6">
                <h3 id="modalTitle" class="text-2xl font-bold text-gray-800">Policy</h3>
                <button onclick="closeModal()" class="text-gray-500 hover:text-gray-700">
                    <i class="fas fa-times text-xl"></i>
                </button>
            </div>
            <div id="modalContent" class="overflow-y-auto pr-4 text-gray-600 space-y-4 text-sm leading-relaxed">
                <!-- Content will be injected here -->
            </div>
            <div class="mt-8 text-right">
                <button onclick="closeModal()" class="grocery-gradient text-white px-6 py-2 rounded-lg font-semibold">
                    Close
                </button>
            </div>
        </div>
    </div>

    <!-- Loading Overlay -->
    <div id="loadingOverlay" class="fixed inset-0 bg-black bg-opacity-50 hidden items-center justify-center z-[70]">
        <div class="bg-white p-8 rounded-2xl flex flex-col items-center shadow-2xl">
            <div class="animate-spin rounded-full h-16 w-16 border-t-4 border-b-4 border-green-600 mb-4"></div>
            <h3 class="text-xl font-bold text-gray-800">Creating Your Store...</h3>
            <p class="text-gray-600 mt-2">Setting up your database and default users.</p>
        </div>
    </div>

    <script>
        const policies = {
            terms: {
                title: "Terms of Service",
                content: `
                    <div class="space-y-4">
                        <p class="font-bold">Last Updated: February 2, 2026</p>
                        <p>Welcome to Grocery SaaS. By using our platform, you agree to comply with and be bound by the following terms and conditions, which are formulated in accordance with the <strong>ICT Act 2006</strong> of Bangladesh.</p>
                        
                        <h4 class="font-bold text-gray-800">1. Account Responsibility</h4>
                        <p>You are responsible for maintaining the confidentiality of your account credentials. Any activity under your account is your responsibility.</p>
                        
                        <h4 class="font-bold text-gray-800">2. Lawful Use</h4>
                        <p>Users must not use the platform for any fraudulent or illegal activities that violate the laws of the People's Republic of Bangladesh.</p>
                        
                        <h4 class="font-bold text-gray-800">3. Service Availability</h4>
                        <p>While we strive for 99.9% uptime, we are not liable for any temporary service interruptions due to maintenance or factors beyond our control.</p>
                        
                        <h4 class="font-bold text-gray-800">4. Intellectual Property</h4>
                        <p>All content, trademarks, and data on this platform are the property of Grocery SaaS unless otherwise stated.</p>
                    </div>
                `
            },
            privacy: {
                title: "Data Privacy and Policy",
                content: `
                    <div class="space-y-4">
                        <p class="font-bold text-green-700">Compliant with Bangladesh Digital Security Act 2018</p>
                        <p>This Privacy Policy describes how we collect, use, and protect your data in accordance with the <strong>Digital Security Act 2018</strong> and the <strong>Draft Data Protection Act (DPA)</strong> of Bangladesh.</p>
                        
                        <h4 class="font-bold text-gray-800">1. Data Collection</h4>
                        <p>We collect essential business information (Business Name, Domain) and personal identifiers (Name, Email, Phone Number) to provide our services.</p>
                        
                        <h4 class="font-bold text-gray-800">2. Purpose of Processing</h4>
                        <p>Your data is used solely for account management, service communication, and platform improvement. We do not sell your data to third parties.</p>
                        
                        <h4 class="font-bold text-gray-800">3. Data Security</h4>
                        <p>We implement industry-standard encryption and security measures to protect your data from unauthorized access, in compliance with Bangladesh's national cyber security standards.</p>
                        
                        <h4 class="font-bold text-gray-800">4. User Rights</h4>
                        <p>As per the laws of Bangladesh, you have the right to access, correct, or request the deletion of your personal information from our system.</p>
                        
                        <h4 class="font-bold text-gray-800">5. Government Compliance</h4>
                        <p>We may disclose information if required by the law enforcement agencies of Bangladesh under the prevailing legal framework.</p>
                    </div>
                `
            }
        };

        function openModal(type) {
            const modal = document.getElementById('policyModal');
            const title = document.getElementById('modalTitle');
            const content = document.getElementById('modalContent');
            
            title.innerText = policies[type].title;
            content.innerHTML = policies[type].content;
            
            modal.classList.remove('hidden');
            modal.classList.add('flex');
            document.body.style.overflow = 'hidden';
        }

        function closeModal() {
            const modal = document.getElementById('policyModal');
            modal.classList.add('hidden');
            modal.classList.remove('flex');
            document.body.style.overflow = 'auto';
        }

        // Close modal when clicking outside
        window.onclick = function(event) {
            const modal = document.getElementById('policyModal');
            if (event.target == modal) {
                closeModal();
            }
        }

        // Add some interactivity
        document.addEventListener('DOMContentLoaded', function() {
            const form = document.querySelector('form');
            const loadingOverlay = document.getElementById('loadingOverlay');

            if (form && loadingOverlay) {
                form.addEventListener('submit', function() {
                    loadingOverlay.classList.remove('hidden');
                    loadingOverlay.classList.add('flex');
                });
            }

            const businessNameInput = document.getElementById('business_name');
            const domainInput = document.getElementById('domain');

            if (businessNameInput && domainInput) {
                businessNameInput.addEventListener('input', function() {
                    // Slugify business name: lowercase, replace spaces/special chars with hyphens
                    const slug = this.value
                        .toLowerCase()
                        .trim()
                        .replace(/[^\w\s-]/g, '')
                        .replace(/[\s_-]+/g, '-')
                        .replace(/^-+|-+$/g, '');
                    
                    domainInput.value = slug;
                });

                // Still allow manual adjustment if needed, but auto-format it
                domainInput.addEventListener('input', function(e) {
                    e.target.value = e.target.value.toLowerCase().replace(/[^a-z0-9-]/g, '');
                });
            }
        });
    </script>
</body>
</html>
<?php /**PATH D:\laragon\www\Laravel_gorsary\resources\views/auth/register.blade.php ENDPATH**/ ?>