<?php $__env->startSection('title', 'Application Request Monitor'); ?>

<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-4 py-6" x-data="requestMonitor()">
    <!-- Header -->
    <div class="flex flex-col md:flex-row md:items-center justify-between gap-4 mb-6">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">Application Request Monitor</h1>
            <p class="text-gray-600">Track and analyze incoming application requests in real-time.</p>
        </div>
        <div class="flex items-center gap-2">
            <button @click="refreshData()" class="px-4 py-2 bg-purple-600 text-white rounded-lg hover:bg-purple-700 transition flex items-center gap-2">
                <span :class="{'animate-spin': loading}">🔄</span> Refresh
            </button>
            <form action="<?php echo e(route('developer.requests.clear')); ?>" method="POST" onsubmit="return confirm('Are you sure you want to clear all request logs?')">
                <?php echo csrf_field(); ?>
                <button type="submit" class="px-4 py-2 bg-red-100 text-red-600 rounded-lg hover:bg-red-200 transition">
                    🗑️ Clear Logs
                </button>
            </form>
        </div>
    </div>

    <!-- Stats Overview -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-8">
        <div class="bg-white p-6 rounded-xl shadow-sm border border-gray-100">
            <div class="text-sm text-gray-500 mb-1">Total Requests</div>
            <div class="text-2xl font-bold text-gray-900"><?php echo e(number_format($stats['total_requests'])); ?></div>
        </div>
        <div class="bg-white p-6 rounded-xl shadow-sm border border-gray-100">
            <div class="text-sm text-gray-500 mb-1">Avg. Duration</div>
            <div class="text-2xl font-bold text-purple-600"><?php echo e($stats['avg_duration']); ?>ms</div>
        </div>
        <div class="bg-white p-6 rounded-xl shadow-sm border border-gray-100">
            <div class="text-sm text-gray-500 mb-1">Error Rate</div>
            <div class="text-2xl font-bold text-red-600"><?php echo e($stats['error_rate']); ?>%</div>
        </div>
        <div class="bg-white p-6 rounded-xl shadow-sm border border-gray-100">
            <div class="text-sm text-gray-500 mb-1">Active View</div>
            <div class="text-lg font-semibold text-gray-900 capitalize"><?php echo e($view); ?> Monitoring</div>
        </div>
    </div>

    <!-- Filters & Navigation -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-100 mb-6">
        <div class="flex flex-wrap border-b">
            <a href="<?php echo e(route('developer.requests.index', ['view' => 'all'])); ?>" 
               class="px-6 py-4 text-sm font-medium border-b-2 transition <?php echo e($view === 'all' ? 'border-purple-600 text-purple-600' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300'); ?>">
                All Requests
            </a>
            <a href="<?php echo e(route('developer.requests.index', ['view' => 'tenant'])); ?>" 
               class="px-6 py-4 text-sm font-medium border-b-2 transition <?php echo e($view === 'tenant' ? 'border-purple-600 text-purple-600' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300'); ?>">
                Tenant Requests
            </a>
            <a href="<?php echo e(route('developer.requests.index', ['view' => 'server'])); ?>" 
               class="px-6 py-4 text-sm font-medium border-b-2 transition <?php echo e($view === 'server' ? 'border-purple-600 text-purple-600' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300'); ?>">
                Server Monitoring
            </a>
        </div>
        
        <?php if($view === 'tenant'): ?>
        <div class="p-4 bg-gray-50 rounded-b-xl border-t border-gray-100">
            <div class="flex items-center gap-4">
                <label class="text-sm font-medium text-gray-700">Filter by Tenant:</label>
                <select onchange="window.location.href='<?php echo e(route('developer.requests.index', ['view' => 'tenant'])); ?>&tenant_id=' + this.value" 
                        class="text-sm border-gray-300 rounded-md focus:ring-purple-500 focus:border-purple-500">
                    <option value="">Select Tenant</option>
                    <?php $__currentLoopData = $tenants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tenant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($tenant->id); ?>" <?php echo e($tenantId == $tenant->id ? 'selected' : ''); ?>><?php echo e($tenant->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
        </div>
        <?php endif; ?>
    </div>

    <!-- Requests Table -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-100 overflow-hidden">
        <div class="overflow-x-auto">
            <table class="w-full text-left">
                <thead>
                    <tr class="bg-gray-50 border-b border-gray-100">
                        <th class="px-6 py-4 text-xs font-semibold text-gray-500 uppercase tracking-wider">Status</th>
                        <th class="px-6 py-4 text-xs font-semibold text-gray-500 uppercase tracking-wider">Method & URL</th>
                        <th class="px-6 py-4 text-xs font-semibold text-gray-500 uppercase tracking-wider">Tenant/User</th>
                        <th class="px-6 py-4 text-xs font-semibold text-gray-500 uppercase tracking-wider">Duration</th>
                        <th class="px-6 py-4 text-xs font-semibold text-gray-500 uppercase tracking-wider">Time</th>
                        <th class="px-6 py-4 text-xs font-semibold text-gray-500 uppercase tracking-wider">Details</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-100">
                    <?php $__empty_1 = true; $__currentLoopData = $logs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="hover:bg-gray-50 transition">
                            <td class="px-6 py-4">
                                <span class="px-2 py-1 text-xs font-bold rounded-full <?php echo e($log->status_code >= 400 ? 'bg-red-100 text-red-700' : 'bg-green-100 text-green-700'); ?>">
                                    <?php echo e($log->status_code); ?>

                                </span>
                            </td>
                            <td class="px-6 py-4">
                                <div class="flex flex-col">
                                    <span class="text-sm font-bold text-gray-900"><?php echo e($log->method); ?></span>
                                    <a href="<?php echo e($log->url); ?>" target="_blank" class="text-xs text-purple-600 hover:text-purple-800 hover:underline truncate max-w-md" title="<?php echo e($log->url); ?>">
                                        <?php echo e($log->url); ?>

                                    </a>
                                </div>
                            </td>
                            <td class="px-6 py-4">
                                <div class="flex flex-col">
                                    <?php if($log->tenant_id): ?>
                                        <a href="<?php echo e(route('developer.tenants.activity', $log->tenant_id)); ?>" class="text-sm font-medium text-purple-600 hover:underline">
                                            <?php echo e($log->tenant_name); ?>

                                        </a>
                                    <?php else: ?>
                                        <span class="text-sm font-medium text-gray-900">System/Server</span>
                                    <?php endif; ?>
                                    
                                    <?php if($log->user_id): ?>
                                        <a href="<?php echo e(route('developer.users.edit', $log->user_id)); ?>" class="text-xs text-gray-500 hover:text-purple-600 hover:underline">
                                            <?php echo e($log->user_name); ?>

                                        </a>
                                    <?php else: ?>
                                        <span class="text-xs text-gray-500">Guest</span>
                                    <?php endif; ?>
                                </div>
                            </td>
                            <td class="px-6 py-4">
                                <span class="text-sm <?php echo e($log->duration_ms > 500 ? 'text-orange-600 font-bold' : 'text-gray-600'); ?>">
                                    <?php echo e($log->duration_ms); ?>ms
                                </span>
                            </td>
                            <td class="px-6 py-4">
                                <span class="text-xs text-gray-500"><?php echo e(\Carbon\Carbon::parse($log->created_at)->diffForHumans()); ?></span>
                            </td>
                            <td class="px-6 py-4">
                                <a 
                                    href="javascript:void(0)"
                                    @click="showDetails(<?php echo \Illuminate\Support\Js::from($log)->toHtml() ?>)" 
                                    class="inline-flex items-center px-3 py-1 bg-purple-50 text-purple-700 hover:bg-purple-100 rounded-md transition duration-150 text-sm font-medium cursor-pointer"
                                >
                                    <span class="mr-1">👁️</span> View Details
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="6" class="px-6 py-12 text-center">
                                <div class="text-4xl mb-4">🔍</div>
                                <p class="text-gray-500">No requests found matching your criteria.</p>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <div class="px-6 py-4 border-t border-gray-100">
            <?php echo e($logs->links()); ?>

        </div>
    </div>

    <!-- Request Details Modal -->
    <div x-show="detailsModal" 
         class="fixed inset-0 z-50 overflow-y-auto" 
         x-cloak>
        <div class="flex items-center justify-center min-h-screen px-4 pt-4 pb-20 text-center sm:block sm:p-0">
            <div x-show="detailsModal" 
                 @click="detailsModal = false"
                 x-transition:enter="ease-out duration-300" 
                 x-transition:enter-start="opacity-0" 
                 x-transition:enter-end="opacity-100" 
                 x-transition:leave="ease-in duration-200" 
                 x-transition:leave-start="opacity-100" 
                 x-transition:leave-end="opacity-0" 
                 class="fixed inset-0 transition-opacity" 
                 aria-hidden="true">
                <div class="absolute inset-0 bg-gray-500 opacity-60"></div>
            </div>

            <div x-show="detailsModal" 
                 x-transition:enter="ease-out duration-300" 
                 x-transition:enter-start="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95" 
                 x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100" 
                 x-transition:leave="ease-in duration-200" 
                 x-transition:leave-start="opacity-100 translate-y-0 sm:scale-100" 
                 x-transition:leave-end="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95" 
                 class="inline-block align-bottom bg-white rounded-xl text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-4xl sm:w-full">
                
                <div class="bg-white px-6 py-4 border-b border-gray-100 flex items-center justify-between">
                    <h3 class="text-lg font-bold text-gray-900">Request Details</h3>
                    <button @click="detailsModal = false" class="text-gray-400 hover:text-gray-600 text-2xl">&times;</button>
                </div>

                <div class="p-6 bg-gray-50 max-h-[80vh] overflow-y-auto">
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-6">
                        <!-- Main Info (2/3) -->
                        <div class="md:col-span-2 space-y-6">
                            <div class="bg-white p-4 rounded-lg border border-gray-200 shadow-sm">
                                <label class="text-xs font-bold text-gray-400 uppercase tracking-wider">Request Endpoint</label>
                                <div class="mt-2 flex items-center gap-3">
                                    <span class="px-3 py-1 text-sm font-bold rounded-md" :class="selectedLog?.status_code >= 400 ? 'bg-red-100 text-red-700' : 'bg-green-100 text-green-700'" x-text="selectedLog?.status_code"></span>
                                    <span class="px-2 py-1 bg-gray-100 text-gray-700 rounded text-sm font-mono font-bold" x-text="selectedLog?.method"></span>
                                </div>
                                <div class="mt-3 flex items-start gap-2">
                                    <div class="flex-1 bg-gray-50 p-3 rounded border border-gray-100 font-mono text-xs break-all text-purple-700" x-text="selectedLog?.url"></div>
                                    <button @click="copyToClipboard(selectedLog?.url)" class="p-2 text-gray-400 hover:text-purple-600 transition" title="Copy URL">
                                        📋
                                    </button>
                                </div>
                            </div>

                            <div class="bg-white p-4 rounded-lg border border-gray-200 shadow-sm">
                                <div class="flex items-center justify-between mb-3">
                                    <label class="text-xs font-bold text-gray-400 uppercase tracking-wider">Request Payload</label>
                                    <button @click="copyToClipboard(formatJSON(selectedLog?.payload))" class="text-xs text-purple-600 hover:underline font-medium">
                                        Copy JSON
                                    </button>
                                </div>
                                <pre class="text-xs bg-gray-900 text-green-400 p-4 rounded-lg overflow-x-auto shadow-inner min-h-[100px] max-h-[300px]" x-text="formatJSON(selectedLog?.payload)"></pre>
                            </div>
                        </div>

                        <!-- Sidebar Info (1/3) -->
                        <div class="space-y-6">
                            <div class="bg-white p-4 rounded-lg border border-gray-200 shadow-sm space-y-4">
                                <div>
                                    <label class="text-xs font-bold text-gray-400 uppercase tracking-wider">Performance</label>
                                    <div class="mt-1 text-sm font-medium text-gray-900 flex items-center gap-2">
                                        ⏱️ <span :class="selectedLog?.duration_ms > 500 ? 'text-red-600 font-bold' : ''" x-text="selectedLog?.duration_ms + ' ms'"></span>
                                    </div>
                                </div>
                                <div>
                                    <label class="text-xs font-bold text-gray-400 uppercase tracking-wider">Route & Action</label>
                                    <div class="mt-1 text-xs space-y-2">
                                        <p class="text-gray-900 font-medium">Name: <span class="text-purple-600" x-text="selectedLog?.route_name || 'N/A'"></span></p>
                                        <p class="text-gray-500 break-all" x-text="selectedLog?.controller_action"></p>
                                    </div>
                                </div>
                            </div>

                            <div class="bg-white p-4 rounded-lg border border-gray-200 shadow-sm space-y-4">
                                <div>
                                    <label class="text-xs font-bold text-gray-400 uppercase tracking-wider">Client Details</label>
                                    <div class="mt-2 text-xs space-y-3">
                                        <div>
                                            <p class="text-gray-400 mb-1">IP Address</p>
                                            <p class="text-gray-900 font-mono bg-gray-50 p-1 rounded" x-text="selectedLog?.ip_address"></p>
                                        </div>
                                        <div>
                                            <p class="text-gray-400 mb-1">User Agent</p>
                                            <p class="text-gray-600 italic leading-relaxed" x-text="selectedLog?.user_agent"></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="bg-gray-50 px-6 py-4 border-t border-gray-100 flex justify-end">
                    <button @click="detailsModal = false" class="px-4 py-2 bg-white border border-gray-300 text-gray-700 rounded-lg hover:bg-gray-50 transition">
                        Close
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    function requestMonitor() {
        return {
            loading: false,
            detailsModal: false,
            selectedLog: null,

            refreshData() {
                this.loading = true;
                window.location.reload();
            },

            showDetails(log) {
                console.log('Showing details for log:', log);
                this.selectedLog = log;
                this.detailsModal = true;
            },

            copyToClipboard(text) {
                if (!text) return;
                
                if (navigator.clipboard && window.isSecureContext) {
                    navigator.clipboard.writeText(text).then(() => {
                        alert('Copied to clipboard!');
                    });
                } else {
                    // Fallback
                    const textArea = document.createElement("textarea");
                    textArea.value = text;
                    document.body.appendChild(textArea);
                    textArea.select();
                    try {
                        document.execCommand('copy');
                        alert('Copied to clipboard!');
                    } catch (err) {
                        console.error('Fallback: Oops, unable to copy', err);
                    }
                    document.body.removeChild(textArea);
                }
            },

            formatJSON(json) {
                if (!json) return 'No payload';
                try {
                    const data = typeof json === 'string' ? JSON.parse(json) : json;
                    return JSON.stringify(data, null, 2);
                } catch (e) {
                    return json;
                }
            }
        }
    }
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.developer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\laragon\www\Laravel_gorsary\resources\views/developer/requests/index.blade.php ENDPATH**/ ?>