<?php $__env->startSection('title', 'Tenant Applications - ' . $tenant->name); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <!-- Page Header -->
    <div class="mb-8">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-3xl font-bold text-gray-900">Tenant Applications</h1>
                <p class="mt-2 text-gray-600"><?php echo e($tenant->name); ?> - Application Logs</p>
            </div>
            <div class="flex space-x-2">
                <a href="<?php echo e(route('developer.tenants')); ?>" 
                   class="text-gray-600 hover:text-gray-900">
                    ← Back to Tenants
                </a>
                <a href="<?php echo e(route('developer.tenants.activity', $tenant->id)); ?>" 
                   class="bg-purple-600 text-white px-4 py-2 rounded-md hover:bg-purple-700 text-sm">
                    View Activity
                </a>
            </div>
        </div>
    </div>

    <!-- Tenant Info -->
    <div class="bg-white shadow rounded-lg mb-6">
        <div class="px-4 py-5 sm:px-6">
            <div class="flex items-center justify-between">
                <div class="flex items-center">
                    <div class="flex-shrink-0 h-12 w-12 rounded-full bg-purple-500 flex items-center justify-center">
                        <span class="text-white font-medium text-lg">
                            <?php echo e(substr($tenant->name, 0, 1)); ?>

                        </span>
                    </div>
                    <div class="ml-4">
                        <h2 class="text-xl font-semibold text-gray-900"><?php echo e($tenant->name); ?></h2>
                        <p class="text-sm text-gray-500"><?php echo e($tenant->domain); ?></p>
                    </div>
                </div>
                <div class="text-right">
                    <div class="text-sm text-gray-500">ID: <?php echo e($tenant->id); ?></div>
                </div>
            </div>
        </div>
    </div>

    <!-- Application Logs -->
    <div class="bg-white shadow rounded-lg">
        <div class="px-4 py-5 sm:px-6">
            <div class="flex items-center justify-between">
                <h3 class="text-lg font-medium text-gray-900">Application Logs</h3>
                <div class="flex space-x-2">
                    <select id="logLevel" class="block px-3 py-2 border border-gray-300 rounded-md text-sm leading-5 bg-white focus:outline-none focus:ring-1 focus:ring-purple-500 focus:border-purple-500">
                        <option value="all">All Levels</option>
                        <option value="error">Error</option>
                        <option value="info">Info</option>
                        <option value="debug">Debug</option>
                        <option value="warning">Warning</option>
                    </select>
                    <button onclick="refreshLogs()" class="px-4 py-2 bg-purple-600 text-white text-sm font-medium rounded-md hover:bg-purple-700">
                        Refresh
                    </button>
                </div>
            </div>
        </div>
        <div class="border-t border-gray-200">
            <div class="divide-y divide-gray-200">
                <?php if($logs->count() > 0): ?>
                    <?php $__currentLoopData = $logs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="px-4 py-3 sm:px-6">
                            <div class="flex items-start space-x-3">
                                <div class="flex-shrink-0">
                                    <div class="h-8 w-8 rounded-full flex items-center justify-center
                                        <?php if($log['level'] === 'error'): ?> bg-red-100
                                        <?php elseif($log['level'] === 'warning'): ?> bg-yellow-100
                                        <?php elseif($log['level'] === 'info'): ?> bg-blue-100
                                        <?php elseif($log['level'] === 'debug'): ?> bg-gray-100
                                        <?php else: ?> bg-green-100 <?php endif; ?>">
                                        <span class="text-xs font-medium uppercase">
                                            <?php echo e(substr($log['level'], 0, 1)); ?>

                                        </span>
                                    </div>
                                </div>
                                <div class="flex-1 min-w-0">
                                    <div class="text-sm">
                                        <div class="font-mono text-gray-900"><?php echo e($log['message']); ?></div>
                                        <?php if($log['context']): ?>
                                            <div class="text-xs text-gray-400 mt-1">Context: <?php echo e($log['context']); ?></div>
                                        <?php endif; ?>
                                    </div>
                                    <div class="text-xs text-gray-500 mt-2">
                                        <?php echo e($log['timestamp']->format('M d, Y H:i:s A')); ?>

                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <div class="px-4 py-8 text-center text-gray-500">
                        <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h4a2 2 0 012 2v8a2 2 0 002 2h4a2 2 0 012-2v-8a2 2 0 00-2-2H6a2 2 0 00-2 2v8a2 2 0 002 2z"></path>
                        </svg>
                        <p class="mt-2">No logs found</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Database Info -->
    <div class="mt-6 bg-white shadow rounded-lg">
        <div class="px-4 py-5 sm:px-6">
            <h3 class="text-lg font-medium text-gray-900">Database Information</h3>
        </div>
        <div class="border-t border-gray-200">
            <div class="px-4 py-5 sm:px-6">
                <dl class="grid grid-cols-1 sm:grid-cols-2 gap-x-4 gap-y-4 sm:grid-cols-4">
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Database Name</dt>
                        <dd class="mt-1 text-sm text-gray-900"><?php echo e($databaseInfo['connection']['database']); ?></dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Connection</dt>
                        <dd class="mt-1 text-sm text-gray-900"><?php echo e($databaseInfo['connection']['host']); ?>:<?php echo e($databaseInfo['connection']['port']); ?></dd>
                    </div>
                    <div>
                        <dt class="text font-medium text-gray-500">Charset</dt>
                        <dd class="mt-1 text-sm text-gray-900"><?php echo e($databaseInfo['connection']['charset']); ?></dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Total Tables</dt>
                        <dd class="mt-1 text-sm text-gray-900"><?php echo e($databaseInfo['total_tables']); ?></dd>
                    </div>
                </dl>
                
                <?php if($databaseInfo['error']): ?>
                    <div class="mt-4 p-4 bg-red-50 border border-red-200 rounded-md">
                        <div class="text-sm text-red-800">
                            <strong>Error:</strong> <?php echo e($databaseInfo['error']); ?>

                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<script>
function refreshLogs() {
    // In a real implementation, you would fetch new logs from the server
    // For now, we'll just reload the page
    location.reload();
}

// Filter logs by level
document.getElementById('logLevel').addEventListener('change', function() {
    const level = this.value;
    const rows = document.querySelectorAll('.divide-y > div');
    
    rows.forEach(row => {
        const levelSpan = row.querySelector('.uppercase');
        const rowLevel = levelSpan ? levelSpan.textContent.toLowerCase() : '';
        
        if (level === 'all' || rowLevel === level) {
            row.style.display = '';
        } else {
            row.style.display = 'none';
        }
    });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.developer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\laragon\www\Laravel_gorsary\resources\views/developer/tenants/applications.blade.php ENDPATH**/ ?>