<?php if (isset($component)) { $__componentOriginal91fdd17964e43374ae18c674f95cdaa3 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal91fdd17964e43374ae18c674f95cdaa3 = $attributes; } ?>
<?php $component = App\View\Components\AdminLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('admin-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AdminLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                <?php echo e(__('Tenant Details')); ?>

            </h2>
            <a href="<?php echo e(route('admin.tenants.index')); ?>" class="text-sm text-indigo-600 hover:text-indigo-900">Back to List</a>
        </div>
     <?php $__env->endSlot(); ?>

    <div class="py-6">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <!-- Tenant Info Card -->
            <div class="bg-white shadow rounded-lg mb-6 overflow-hidden">
                <div class="px-6 py-5 border-b border-gray-200 flex justify-between items-center bg-gray-50">
                    <div>
                        <h3 class="text-lg leading-6 font-medium text-gray-900"><?php echo e($tenant->name); ?></h3>
                        <p class="mt-1 max-w-2xl text-sm text-gray-500"><?php echo e($tenant->domain); ?></p>
                    </div>
                    <span class="px-3 py-1 inline-flex text-sm leading-5 font-semibold rounded-full <?php echo e($tenant->status === 'active' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800'); ?>">
                        <?php echo e(ucfirst($tenant->status)); ?>

                    </span>
                </div>
                <div class="px-6 py-5 grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Database Name</dt>
                        <dd class="mt-1 text-sm text-gray-900"><?php echo e($tenant->database_name); ?></dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Registered On</dt>
                        <dd class="mt-1 text-sm text-gray-900"><?php echo e($tenant->created_at->format('F d, Y H:i')); ?></dd>
                    </div>
                </div>
            </div>

            <!-- Subscription Card -->
            <div class="bg-white shadow rounded-lg mb-6 overflow-hidden">
                <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                    <h3 class="text-lg leading-6 font-medium text-gray-900">Subscription Status</h3>
                </div>
                <div class="px-6 py-5">
                    <?php if($tenant->subscription): ?>
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Current Plan</dt>
                                <dd class="mt-1 text-lg font-semibold text-indigo-600"><?php echo e($tenant->subscription->plan->name ?? 'Unknown Plan'); ?></dd>
                            </div>
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Status</dt>
                                <dd class="mt-1 text-sm text-gray-900"><?php echo e(ucfirst($tenant->subscription->status)); ?></dd>
                            </div>
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Renews / Ends</dt>
                                <dd class="mt-1 text-sm text-gray-900"><?php echo e($tenant->subscription->ends_at ? $tenant->subscription->ends_at->format('M d, Y') : 'Never'); ?></dd>
                            </div>
                        </div>
                    <?php else: ?>
                        <p class="text-gray-500 italic">No active subscription found.</p>
                        <button class="mt-3 text-indigo-600 hover:text-indigo-900 text-sm font-medium">Assign Plan</button>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Users Card -->
            <div class="bg-white shadow rounded-lg overflow-hidden">
                <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                    <h3 class="text-lg leading-6 font-medium text-gray-900">Users</h3>
                </div>
                <ul class="divide-y divide-gray-200">
                    <?php if($tenant->users && $tenant->users->count() > 0): ?>
                        <?php $__currentLoopData = $tenant->users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="px-6 py-4 flex items-center justify-between">
                            <div>
                                <p class="text-sm font-medium text-gray-900"><?php echo e($user->name); ?></p>
                                <p class="text-sm text-gray-500"><?php echo e($user->email); ?></p>
                            </div>
                            <div class="flex items-center">
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-800 mr-4">
                                    <?php echo e($user->getRoleNames()->first() ?? 'No Role'); ?>

                                </span>
                                <a href="#" class="text-gray-400 hover:text-gray-600">Edit</a>
                            </div>
                        </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <li class="px-6 py-4 text-center text-gray-500 italic">No users found.</li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal91fdd17964e43374ae18c674f95cdaa3)): ?>
<?php $attributes = $__attributesOriginal91fdd17964e43374ae18c674f95cdaa3; ?>
<?php unset($__attributesOriginal91fdd17964e43374ae18c674f95cdaa3); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal91fdd17964e43374ae18c674f95cdaa3)): ?>
<?php $component = $__componentOriginal91fdd17964e43374ae18c674f95cdaa3; ?>
<?php unset($__componentOriginal91fdd17964e43374ae18c674f95cdaa3); ?>
<?php endif; ?>
<?php /**PATH D:\laragon\www\Laravel_gorsary\resources\views/admin/tenants/show.blade.php ENDPATH**/ ?>