<?php if (isset($component)) { $__componentOriginal3f11930a8702d3d700513f5d743b90ca = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal3f11930a8702d3d700513f5d743b90ca = $attributes; } ?>
<?php $component = App\View\Components\TenantLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('tenant-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\TenantLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            <?php echo e(__('Process Purchase Order')); ?> (From <?php echo e($requisition->requisition_no); ?>)
        </h2>
     <?php $__env->endSlot(); ?>

    <div class="py-12" x-data="{ paidAmount: <?php echo e($requisition->total_amount); ?>, total: <?php echo e($requisition->total_amount); ?> }">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 bg-white border-b border-gray-200">
                    <form method="POST" action="<?php echo e(route('tenant.purchases.store')); ?>">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="purchase_requisition_id" value="<?php echo e($requisition->id); ?>">
                        <input type="hidden" name="supplier_id" value="<?php echo e($requisition->supplier_id); ?>">

                        <div class="mb-6">
                            <h3 class="text-lg font-bold text-gray-900 mb-2">Review Items</h3>
                            <p class="text-sm text-gray-500 mb-4">Verify quantities and costs before finalizing stock entry.</p>
                            
                            <table class="min-w-full divide-y divide-gray-200 border">
                                <thead class="bg-gray-50">
                                    <tr>
                                        <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Product</th>
                                        <th class="px-4 py-2 text-right text-xs font-medium text-gray-500 uppercase">Cost</th>
                                        <th class="px-4 py-2 text-center text-xs font-medium text-gray-500 uppercase">Qty</th>
                                        <th class="px-4 py-2 text-right text-xs font-medium text-gray-500 uppercase">Total</th>
                                    </tr>
                                </thead>
                                <tbody class="divide-y divide-gray-200">
                                    <?php $__currentLoopData = $requisition->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td class="px-4 py-2 text-sm text-gray-900">
                                            <input type="hidden" name="items[<?php echo e($index); ?>][variant_id]" value="<?php echo e($item->product_variant_id); ?>">
                                            <?php echo e($item->variant->product->name); ?> 
                                            <?php if($item->variant->name !== $item->variant->product->name): ?>
                                                - <?php echo e($item->variant->name); ?>

                                            <?php endif; ?>
                                        </td>
                                        <td class="px-4 py-2 text-right">
                                            <input type="number" step="0.01" name="items[<?php echo e($index); ?>][unit_cost]" value="<?php echo e($item->cost_price); ?>" class="w-24 text-right border-gray-300 rounded-md text-sm p-1" readonly>
                                        </td>
                                        <td class="px-4 py-2 text-center">
                                            <input type="number" step="1" name="items[<?php echo e($index); ?>][quantity]" value="<?php echo e($item->quantity); ?>" class="w-20 text-center border-gray-300 rounded-md text-sm p-1" readonly>
                                        </td>
                                        <td class="px-4 py-2 text-right text-sm font-medium">
                                            $<?php echo e(number_format($item->total, 2)); ?>

                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Total Amount</label>
                                <div class="mt-1 text-2xl font-bold text-gray-900">$<?php echo e(number_format($requisition->total_amount, 2)); ?></div>
                            </div>
                            <div>
                                <label for="paid_amount" class="block text-sm font-medium text-gray-700">Paid Amount</label>
                                <input type="number" step="0.01" name="paid_amount" id="paid_amount" x-model="paidAmount" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-green-500 focus:ring focus:ring-green-200 focus:ring-opacity-50">
                                <p class="mt-1 text-xs text-gray-500" x-show="paidAmount < total">Remaining balance will be added to supplier dues.</p>
                            </div>
                        </div>

                        <div class="flex items-center justify-end">
                            <a href="<?php echo e(route('tenant.requisitions.index')); ?>" class="text-gray-600 hover:text-gray-900 mr-4">Cancel</a>
                            <button type="submit" class="bg-green-600 hover:bg-green-700 text-white font-bold py-2 px-4 rounded">
                                Confirm Purchase & Update Stock
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal3f11930a8702d3d700513f5d743b90ca)): ?>
<?php $attributes = $__attributesOriginal3f11930a8702d3d700513f5d743b90ca; ?>
<?php unset($__attributesOriginal3f11930a8702d3d700513f5d743b90ca); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal3f11930a8702d3d700513f5d743b90ca)): ?>
<?php $component = $__componentOriginal3f11930a8702d3d700513f5d743b90ca; ?>
<?php unset($__componentOriginal3f11930a8702d3d700513f5d743b90ca); ?>
<?php endif; ?>
<?php /**PATH D:\laragon\www\Laravel_gorsary\resources\views/tenant/inventory/purchases/create_from_pr.blade.php ENDPATH**/ ?>