<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\API\AuthController;

use App\Http\Controllers\API\BillingController;

Route::get('/user', function (Request $request) {
    return $request->user();
})->middleware('auth:sanctum');

Route::post('/register', [AuthController::class, 'register']);
Route::post('/login', [AuthController::class, 'login']);

Route::get('/menu', [\App\Http\Controllers\API\MenuController::class, 'index'])->middleware('auth:sanctum');

Route::middleware(['auth:sanctum'])->group(function () {
    
    // SaaS Admin Routes
    Route::group(['prefix' => 'admin', 'middleware' => ['role:Admin']], function () {
        Route::post('/activate-user', [AuthController::class, 'activateUser']);
    });

    // Billing Routes (Tenant Manager)
    Route::group(['prefix' => 'billing'], function () {
        Route::post('/subscribe', [BillingController::class, 'subscribe']);
        Route::get('/invoices', [BillingController::class, 'invoices']);
    });

    // Tenant Scoped Routes (Example)
    Route::middleware(['tenant'])->group(function () {
        Route::get('/products', [\App\Http\Controllers\API\Tenant\ProductController::class, 'index']);
        Route::get('/products/search', [\App\Http\Controllers\API\Tenant\ProductController::class, 'search'])->name('tenant.api.products.search');
        Route::post('/products', [\App\Http\Controllers\API\Tenant\ProductController::class, 'store']);
        Route::post('/sales', [\App\Http\Controllers\API\Tenant\SaleController::class, 'store']);
        
        // Reports
        Route::get('/reports/transactions', [\App\Http\Controllers\API\Tenant\ReportController::class, 'transactions']);

        // Categories API
        Route::get('/categories', [\App\Http\Controllers\API\Tenant\CategoryController::class, 'index'])->name('tenant.api.categories.index');
        Route::get('/categories/{parentId}/subcategories', [\App\Http\Controllers\API\Tenant\CategoryController::class, 'subcategories'])->name('tenant.api.categories.subcategories');
    });

});
