<x-tenant-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            Subscription Plans
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 bg-white border-b border-gray-200">
                    <h2 class="text-2xl font-bold text-gray-800 mb-6">Choose Your Plan</h2>
                    
                    @if(session('error'))
                        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4" role="alert">
                            <span class="block sm:inline">{{ session('error') }}</span>
                        </div>
                    @endif

                    @if(session('success'))
                        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-4" role="alert">
                            <span class="block sm:inline">{{ session('success') }}</span>
                        </div>
                    @endif

                    @if(empty($gateways))
                        <div class="bg-yellow-100 border border-yellow-400 text-yellow-700 px-4 py-3 rounded relative mb-6" role="alert">
                            <strong class="font-bold">Payment Gateways Not Configured!</strong>
                            <span class="block sm:inline mt-2">Please contact the administrator to configure payment gateways before purchasing a subscription.</span>
                        </div>
                    @endif

                    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                        @foreach($plans as $plan)
                            <div class="border rounded-lg shadow-sm hover:shadow-md transition-shadow duration-200 overflow-hidden">
                                <div class="bg-gray-50 p-4 border-b">
                                    <h3 class="text-xl font-semibold text-gray-900">{{ $plan->name }}</h3>
                                    <p class="text-gray-500 text-sm">{{ $plan->description }}</p>
                                </div>
                                <div class="p-6">
                                    <div class="flex items-baseline mb-4">
                                        <span class="text-3xl font-bold text-gray-900">${{ number_format($plan->price, 2) }}</span>
                                        <span class="text-gray-500 ml-1">/ {{ $plan->interval === 'daily' ? 'day' : ($plan->interval === 'monthly' ? 'month' : 'year') }}</span>
                                    </div>
                                    <ul class="text-sm text-gray-600 space-y-2 mb-6">
                                        @if($plan->features && is_array($plan->features))
                                            @foreach($plan->features as $feature)
                                                <li class="flex items-center">
                                                    <svg class="w-4 h-4 text-green-500 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path></svg>
                                                    {{ $feature }}
                                                </li>
                                            @endforeach
                                        @else
                                            <li class="flex items-center">
                                                <svg class="w-4 h-4 text-green-500 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path></svg>
                                                Full Access
                                            </li>
                                            <li class="flex items-center">
                                                <svg class="w-4 h-4 text-green-500 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path></svg>
                                                Unlimited Products
                                            </li>
                                            <li class="flex items-center">
                                                <svg class="w-4 h-4 text-green-500 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path></svg>
                                                Priority Support
                                            </li>
                                        @endif
                                    </ul>
                                    
                                    @if(!empty($gateways))
                                        <form action="{{ route('tenant.subscriptions.store', $plan->id) }}" method="POST">
                                            @csrf
                                            
                                            <!-- Payment Gateway Selection -->
                                            <div class="mb-4">
                                                <label class="block text-sm font-medium text-gray-700 mb-2">Select Payment Method</label>
                                                <div class="space-y-2">
                                                    @foreach($gateways as $gateway => $config)
                                                        <label class="flex items-center p-3 border rounded-lg cursor-pointer hover:bg-gray-50">
                                                            <input type="radio" name="payment_gateway" value="{{ $gateway }}" 
                                                                   {{ $loop->first ? 'checked' : '' }}
                                                                   class="h-4 w-4 text-green-600 focus:ring-green-500 border-gray-300">
                                                            <div class="ml-3">
                                                                <div class="flex items-center">
                                                                    <span class="font-medium text-gray-900">{{ $config['name'] }}</span>
                                                                    @if($config['type'] === 'manual')
                                                                        <span class="ml-2 inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-yellow-100 text-yellow-800">
                                                                            Manual
                                                                        </span>
                                                                    @else
                                                                        <span class="ml-2 inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                                                            Online
                                                                        </span>
                                                                    @endif
                                                                </div>
                                                                @if($config['type'] === 'manual')
                                                                    <p class="text-sm text-gray-500">Pay to {{ $config['number'] }}</p>
                                                                @endif
                                                                @if(isset($config['sandbox']) && $config['sandbox'])
                                                                    <p class="text-xs text-gray-400">Sandbox Mode</p>
                                                                @endif
                                                            </div>
                                                        </label>
                                                    @endforeach
                                                </div>
                                            </div>
                                            
                                            <button type="submit" class="w-full bg-blue-600 text-white py-2 px-4 rounded hover:bg-blue-700 transition duration-150">
                                                Subscribe Now
                                            </button>
                                        </form>
                                    @else
                                        <button disabled class="w-full bg-gray-400 text-white py-2 px-4 rounded cursor-not-allowed">
                                            Payment Gateways Not Available
                                        </button>
                                    @endif
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-tenant-layout>
