<x-tenant-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                {{ __('MRR Report') }} - {{ $purchase->mrr_no }}
            </h2>
            <div class="flex space-x-2">
                <button onclick="window.print()" class="inline-flex items-center px-4 py-2 bg-gray-800 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-gray-700 active:bg-gray-900 focus:outline-none focus:border-gray-900 focus:ring ring-gray-300 disabled:opacity-25 transition ease-in-out duration-150">
                    <svg class="h-4 w-4 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 17h2a2 2 0 002-2v-4a2 2 0 00-2-2H5a2 2 0 00-2 2v4a2 2 0 002 2h2m2 4h6a2 2 0 002-2v-4a2 2 0 00-2-2H9a2 2 0 00-2 2v4a2 2 0 002 2zm8-12V5a2 2 0 00-2-2H9a2 2 0 00-2 2v4h10z" />
                    </svg>
                    Print Report
                </button>
                <a href="{{ route('tenant.stock.in.index') }}" class="inline-flex items-center px-4 py-2 bg-white border border-gray-300 rounded-md font-semibold text-xs text-gray-700 uppercase tracking-widest shadow-sm hover:text-gray-500 focus:outline-none focus:border-blue-300 focus:ring focus:ring-blue-200 active:text-gray-800 active:bg-gray-50 disabled:opacity-25 transition ease-in-out duration-150">
                    Back to Stock In
                </a>
            </div>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg p-8 print:p-0 print:shadow-none">
                <!-- Header Info -->
                <div class="flex justify-between border-b pb-6 mb-6">
                    <div>
                        <h1 class="text-2xl font-bold text-gray-900">MATERIAL RECEIPT REPORT (MRR)</h1>
                        <p class="text-gray-600">Generated on: {{ now()->format('d M, Y h:i A') }}</p>
                    </div>
                    <div class="text-right">
                        <p class="font-bold text-lg">{{ $purchase->mrr_no }}</p>
                        <p class="text-gray-600">Challan No: {{ $purchase->challan_no }}</p>
                        <p class="text-gray-600">Date: {{ $purchase->created_at->format('d M, Y') }}</p>
                    </div>
                </div>

                <div class="grid grid-cols-2 gap-8 mb-8">
                    <div>
                        <h3 class="text-gray-500 uppercase text-xs font-bold tracking-wider mb-2">Supplier Details</h3>
                        <p class="text-gray-900 font-semibold">{{ $purchase->supplier->name ?? 'N/A' }}</p>
                        @if($purchase->supplier)
                            <p class="text-gray-600 text-sm">{{ $purchase->supplier->email }}</p>
                            <p class="text-gray-600 text-sm">{{ $purchase->supplier->phone }}</p>
                            <p class="text-gray-600 text-sm">{{ $purchase->supplier->address }}</p>
                        @endif
                    </div>
                    <div class="text-right">
                        <h3 class="text-gray-500 uppercase text-xs font-bold tracking-wider mb-2">Reference Info</h3>
                        <p class="text-gray-600 text-sm">Location: <span class="text-gray-900 font-semibold">{{ $purchase->location->name ?? 'N/A' }}</span></p>
                        <p class="text-gray-600 text-sm">Status: <span class="px-2 py-1 bg-green-100 text-green-800 rounded-full text-xs font-semibold uppercase">{{ $purchase->status }}</span></p>
                        @if($purchase->attachment)
                            <p class="text-gray-600 text-sm mt-2">
                                <a href="{{ Storage::url($purchase->attachment) }}" target="_blank" class="text-indigo-600 hover:text-indigo-900 underline">
                                    View Attached Challan/Bill
                                </a>
                            </p>
                        @endif
                    </div>
                </div>

                <!-- Items Table -->
                <div class="mb-8">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-4 py-3 text-left text-xs font-bold text-gray-500 uppercase tracking-wider">#</th>
                                <th class="px-4 py-3 text-left text-xs font-bold text-gray-500 uppercase tracking-wider">Product Description</th>
                                <th class="px-4 py-3 text-center text-xs font-bold text-gray-500 uppercase tracking-wider">Quantity</th>
                                <th class="px-4 py-3 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">Unit Price</th>
                                <th class="px-4 py-3 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">Total</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @foreach($purchase->items as $index => $item)
                                <tr>
                                    <td class="px-4 py-4 text-sm text-gray-500">{{ $index + 1 }}</td>
                                    <td class="px-4 py-4">
                                        <div class="text-sm font-medium text-gray-900">{{ $item->variant->product->name }}</div>
                                        <div class="text-xs text-gray-500">
                                            Variant: {{ $item->variant->name }} | 
                                            SKU: {{ $item->variant->sku }}
                                            @if($item->brand) | Brand: {{ $item->brand->name }} @endif
                                            @if($item->manufacturer) | Mfg: {{ $item->manufacturer->name }} @endif
                                        </div>
                                    </td>
                                    <td class="px-4 py-4 text-sm text-center text-gray-900">
                                        {{ number_format($item->quantity, 2) }} {{ $item->unit->name ?? 'Units' }}
                                    </td>
                                    <td class="px-4 py-4 text-sm text-right text-gray-900">
                                        {{ number_format($item->unit_price, 2) }}
                                    </td>
                                    <td class="px-4 py-4 text-sm text-right text-gray-900 font-semibold">
                                        {{ number_format($item->total, 2) }}
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr class="bg-gray-50">
                                <td colspan="4" class="px-4 py-4 text-right text-sm font-bold text-gray-900 uppercase">Grand Total</td>
                                <td class="px-4 py-4 text-right text-sm font-bold text-gray-900">
                                    {{ number_format($purchase->total_amount, 2) }}
                                </td>
                            </tr>
                        </tfoot>
                    </table>
                </div>

                @if($purchase->notes)
                    <div class="mb-8">
                        <h3 class="text-gray-500 uppercase text-xs font-bold tracking-wider mb-2">Notes</h3>
                        <p class="text-gray-700 text-sm italic">{{ $purchase->notes }}</p>
                    </div>
                @endif

                <!-- Footer Signatures -->
                <div class="mt-20 flex justify-between">
                    <div class="text-center w-48">
                        <div class="border-t border-gray-400 pt-2">
                            <p class="text-sm font-bold">Prepared By</p>
                        </div>
                    </div>
                    <div class="text-center w-48">
                        <div class="border-t border-gray-400 pt-2">
                            <p class="text-sm font-bold">Received By</p>
                        </div>
                    </div>
                    <div class="text-center w-48">
                        <div class="border-t border-gray-400 pt-2">
                            <p class="text-sm font-bold">Authorized Signatory</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <style>
        @media print {
            body { background-color: white !important; }
            .no-print { display: none !important; }
            header, nav, footer, button, .flex.space-x-2 { display: none !important; }
            .py-12 { padding-top: 0 !important; padding-bottom: 0 !important; }
            .max-w-7xl { max-width: 100% !important; }
            .sm\:px-6, .lg\:px-8 { padding-left: 0 !important; padding-right: 0 !important; }
            .bg-white { box-shadow: none !important; border: none !important; }
            .shadow-sm { box-shadow: none !important; }
        }
    </style>
    @push('scripts')
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const urlParams = new URLSearchParams(window.location.search);
            if (urlParams.has('print')) {
                window.print();
            }
        });
    </script>
    @endpush
</x-tenant-layout>
