<x-tenant-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Stock In / MRR') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <!-- MRR Search Section -->
            <div class="mb-6 bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-4">
                        <div class="flex-1">
                            <label for="mrr_search" class="block text-sm font-medium text-gray-700 mb-1">Search & View Saved MRR</label>
                            <select id="mrr_search" class="block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm">
                                <option value="">Search MRR No...</option>
                            </select>
                        </div>
                        <div class="flex gap-2 pt-6">
                            <button id="view_mrr_report" class="inline-flex items-center px-4 py-2 bg-blue-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-blue-700 active:bg-blue-900 focus:outline-none focus:border-blue-900 focus:ring ring-blue-300 disabled:opacity-25 transition ease-in-out duration-150" disabled>
                                View MRR Report
                            </button>
                            <button id="print_mrr_pdf" class="inline-flex items-center px-4 py-2 bg-green-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-green-700 active:bg-green-900 focus:outline-none focus:border-green-900 focus:ring ring-green-300 disabled:opacity-25 transition ease-in-out duration-150" disabled>
                                Print PDF
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Manual Stock In Form -->
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 bg-white border-b border-gray-200">
                    <form action="{{ route('tenant.stock.in.store') }}" method="POST" id="stock-in-form" enctype="multipart/form-data">
                        @csrf
                        
                        <!-- Header Information -->
                        <div class="flex flex-wrap md:flex-nowrap items-end gap-2 mb-6 bg-gray-50 p-3 rounded-lg border border-gray-200 shadow-sm divide-x divide-gray-300">
                            <div class="flex-1 min-w-[150px] px-2">
                                <label class="block text-[10px] font-bold text-gray-500 uppercase mb-1">Location</label>
                                <select name="location_id" id="location_id" class="block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-xs">
                                    <option value="">Select Location</option>
                                    @foreach($locations as $location)
                                        <option value="{{ $location->id }}" {{ old('location_id') == $location->id ? 'selected' : '' }}>
                                            {{ $location->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="flex-1 min-w-[180px] px-2">
                                <label class="block text-[10px] font-bold text-gray-500 uppercase mb-1">Supplier</label>
                                <select name="supplier_id" id="supplier_id" class="block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-xs select2">
                                    <option value="">Select Supplier</option>
                                    @foreach($suppliers as $supplier)
                                        <option value="{{ $supplier->id }}" {{ ($defaultSupplier && $defaultSupplier->id == $supplier->id) || old('supplier_id') == $supplier->id ? 'selected' : '' }}>
                                            {{ $supplier->name }}
                                        </option>
                                    @endforeach
                                    @if(!$defaultSupplier || $suppliers->where('name', 'Outsourcing')->isEmpty())
                                        <option value="outsourcing" {{ old('supplier_id') == 'outsourcing' ? 'selected' : '' }}>Outsourcing</option>
                                    @endif
                                </select>
                            </div>
                            <div class="flex-1 min-w-[120px] px-2">
                                <label class="block text-[10px] font-bold text-gray-500 uppercase mb-1">MRR No</label>
                                <input type="text" name="mrr_no" value="{{ $mrrNo }}" class="block w-full rounded-md border-gray-300 bg-gray-100 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-xs font-mono" readonly required>
                            </div>
                            <div class="flex-1 min-w-[120px] px-2">
                                <label class="block text-[10px] font-bold text-gray-500 uppercase mb-1">Challan No</label>
                                <input type="text" name="challan_no" value="{{ old('challan_no') }}" class="block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-xs" placeholder="Challan No" required>
                            </div>
                            <div class="flex-1 min-w-[150px] px-2">
                                <label class="block text-[10px] font-bold text-gray-500 uppercase mb-1">Attachment</label>
                                <input type="file" name="attachment" class="block w-full text-[10px] text-gray-500 file:mr-1 file:py-1 file:px-2 file:rounded file:border-0 file:text-[10px] file:font-semibold file:bg-indigo-50 file:text-indigo-700 hover:file:bg-indigo-100">
                            </div>
                        </div>

                        <!-- Items Table -->
                        <div class="overflow-x-auto">
                            <table class="min-w-full divide-y divide-gray-200" id="items-table">
                                <thead class="bg-gray-50">
                                    <tr>
                                        <th class="px-3 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider w-1/4">Product / Variant</th>
                                        <th class="px-3 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Manufacturer</th>
                                        <th class="px-3 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Brand</th>
                                        <th class="px-3 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider w-32">Unit</th>
                                        <th class="px-3 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider w-24">Qty</th>
                                        <th class="px-3 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider w-32">Unit Price</th>
                                        <th class="px-3 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider w-32">Total</th>
                                        <th class="px-3 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider w-10"></th>
                                    </tr>
                                </thead>
                                <tbody id="items-container" class="bg-white divide-y divide-gray-200">
                                    <tr class="item-row">
                                        <td class="px-3 py-4">
                                            <input type="hidden" name="items[0][product_id]" class="product-id">
                                            <select name="items[0][variant_id]" class="variant-select block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm" required>
                                                <option value="">Search Product...</option>
                                            </select>
                                        </td>
                                        <td class="px-3 py-4">
                                            <select name="items[0][manufacturer_id]" class="manufacturer-select block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm">
                                                <option value="n/a">n/a</option>
                                                @foreach($manufacturers as $manufacturer)
                                                    <option value="{{ $manufacturer->id }}">{{ $manufacturer->name }}</option>
                                                @endforeach
                                            </select>
                                        </td>
                                        <td class="px-3 py-4">
                                            <select name="items[0][brand_id]" class="brand-select block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm">
                                                <option value="n/a">n/a</option>
                                                @foreach($brands as $brand)
                                                    <option value="{{ $brand->id }}">{{ $brand->name }}</option>
                                                @endforeach
                                            </select>
                                        </td>
                                        <td class="px-3 py-4">
                                            <select name="items[0][unit_id]" class="unit-select block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm" required>
                                                @foreach($units as $unit)
                                                    <option value="{{ $unit->id }}">{{ $unit->name }}</option>
                                                @endforeach
                                            </select>
                                        </td>
                                        <td class="px-3 py-4">
                                            <input type="number" step="0.01" name="items[0][quantity]" class="qty-input block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm" placeholder="0.00" required>
                                        </td>
                                        <td class="px-3 py-4">
                                            <input type="number" step="0.01" name="items[0][unit_price]" class="price-input block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm" placeholder="0.00" required>
                                        </td>
                                        <td class="px-3 py-4">
                                            <input type="number" step="0.01" class="total-input block w-full rounded-md border-gray-100 bg-gray-50 sm:text-sm" placeholder="0.00" readonly>
                                        </td>
                                        <td class="px-3 py-4 text-center">
                                            <button type="button" class="remove-item text-red-600 hover:text-red-900">
                                                <svg class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" />
                                                </svg>
                                            </button>
                                        </td>
                                    </tr>
                                </tbody>
                                <tfoot>
                                    <tr class="bg-gray-50 font-bold">
                                        <td colspan="6" class="px-3 py-4 text-right">Grand Total:</td>
                                        <td class="px-3 py-4">
                                            <span id="grand-total">0.00</span>
                                        </td>
                                        <td></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>

                        <div class="mt-6 flex justify-between items-center">
                            <button type="button" id="add-item" class="inline-flex items-center px-4 py-2 bg-gray-800 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-gray-700 active:bg-gray-900 focus:outline-none focus:border-gray-900 focus:ring ring-gray-300 disabled:opacity-25 transition ease-in-out duration-150">
                                <svg class="h-4 w-4 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4" />
                                </svg>
                                Add Another Item
                            </button>
                            
                            <div class="flex items-center space-x-4">
                                <div class="w-64">
                                    <label class="block text-sm font-medium text-gray-700">Notes (Optional)</label>
                                    <input type="text" name="notes" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm" placeholder="Batch #, Supplier info, etc.">
                                </div>
                                <button type="submit" class="inline-flex items-center px-6 py-2 bg-indigo-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-indigo-700 active:bg-indigo-900 focus:outline-none focus:border-indigo-900 focus:ring ring-indigo-300 disabled:opacity-25 transition ease-in-out duration-150">
                                    Process Stock In / MRR
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Hidden Templates for JS -->
            <div id="templates" class="hidden">
                <select class="tpl-manufacturer">
                    <option value="n/a">n/a</option>
                    @foreach($manufacturers as $manufacturer)
                        <option value="{{ $manufacturer->id }}">{{ $manufacturer->name }}</option>
                    @endforeach
                </select>
                <select class="tpl-brand">
                    <option value="n/a">n/a</option>
                    @foreach($brands as $brand)
                        <option value="{{ $brand->id }}">{{ $brand->name }}</option>
                    @endforeach
                </select>
                <select class="tpl-unit">
                    @foreach($units as $unit)
                        <option value="{{ $unit->id }}">{{ $unit->name }}</option>
                    @endforeach
                </select>
            </div>

            <!-- Excel Import -->
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 bg-white border-b border-gray-200">
                    <h3 class="text-lg font-medium text-gray-900 mb-4">2. Quick Upload (Excel)</h3>
                    
                    <form action="{{ route('tenant.stock.in.import') }}" method="POST" enctype="multipart/form-data" class="flex items-end space-x-4">
                        @csrf
                        <div class="flex-1">
                            <label class="block text-sm font-medium text-gray-700">Choose Excel/CSV File</label>
                            <input type="file" name="file" class="mt-1 block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-md file:border-0 file:text-sm file:font-semibold file:bg-indigo-50 file:text-indigo-700 hover:file:bg-indigo-100" required>
                            <p class="mt-1 text-xs text-gray-500">Required columns: <span class="font-bold">sku</span>, <span class="font-bold">quantity</span>. Optional: <span class="font-bold">notes</span>.</p>
                        </div>
                        <button type="submit" class="inline-flex items-center px-4 py-2 bg-green-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-green-700 active:bg-green-900 focus:outline-none focus:border-green-900 focus:ring ring-green-300 disabled:opacity-25 transition ease-in-out duration-150">
                            Upload & Import
                        </button>
                    </form>
                </div>
            </div>

        </div>
    </div>

    @push('scripts')
    <script>
        function checkJQuery() {
            if (window.jQuery && window.jQuery.fn && window.jQuery.fn.select2) {
                initPage();
            } else {
                setTimeout(checkJQuery, 50);
            }
        }

        // Start checking without using $ directly
        checkJQuery();

        function initPage() {
            const jQuery = window.jQuery; // Capture the jQuery instance that has Select2
            let itemIndex = 1;

            function initSelect2(element) {
                jQuery(element).select2({
                    width: '100%'
                });
            }

            function initProductSelect2(element) {
                jQuery(element).select2({
                    width: '100%',
                    ajax: {
                        url: '{{ route("tenant.stock.in.search-products") }}',
                        dataType: 'json',
                        delay: 250,
                        data: function(params) {
                            return {
                                q: params.term
                            };
                        },
                        processResults: function(data) {
                            return {
                                results: data
                            };
                        },
                        cache: true
                    },
                    minimumInputLength: 0,
                    placeholder: 'Search Product...',
                    allowClear: true,
                    language: {
                        inputTooShort: function() {
                            return "Please enter 1 or more characters to search";
                        },
                        noResults: function() {
                            return "No products found";
                        },
                        searching: function() {
                            return "Searching...";
                        }
                    },
                    escapeMarkup: function(markup) { return markup; },
                    templateResult: function(product) {
                        if (product.loading) return product.text;
                        if (!product.id) return product.text; // For "No products found" debug message
                        return product.text;
                    },
                    templateSelection: function(product) {
                        return product.text || "Search Product...";
                    }
                });
            }

            // Initialize existing variant selects
            jQuery('.variant-select').each(function() {
                initProductSelect2(this);
            });

            // MRR Search Initialization
            jQuery('#mrr_search').select2({
                width: '100%',
                ajax: {
                    url: '{{ route("tenant.stock.in.search-mrrs") }}',
                    dataType: 'json',
                    delay: 250,
                    data: function(params) {
                        return {
                            q: params.term || ''
                        };
                    },
                    processResults: function(data) {
                        return {
                            results: data
                        };
                    },
                    cache: true,
                    error: function (jqXHR, textStatus, errorThrown) {
                        console.error("MRR Search AJAX Error:", textStatus, errorThrown);
                    }
                },
                minimumInputLength: 0,
                placeholder: 'Search MRR No...',
                allowClear: true,
                escapeMarkup: function(markup) { return markup; },
                templateResult: function(data) {
                    if (data.loading) return data.text;
                    return data.text;
                },
                templateSelection: function(data) {
                    return data.text || "Search MRR No...";
                }
            });

            jQuery('#mrr_search').on('select2:select', function(e) {
                const data = e.params.data;
                if (data.id) {
                    jQuery('#view_mrr_report').prop('disabled', false);
                    jQuery('#print_mrr_pdf').prop('disabled', false);
                }
            });

            jQuery('#view_mrr_report').click(function() {
                const mrrId = jQuery('#mrr_search').val();
                if (mrrId) {
                    window.location.href = `/tenant/stock/in/${mrrId}/report`;
                }
            });

            jQuery('#print_mrr_pdf').click(function() {
                const mrrId = jQuery('#mrr_search').val();
                if (mrrId) {
                    const printUrl = `/tenant/stock/in/${mrrId}/report?print=1`;
                    const printWindow = window.open(printUrl, '_blank');
                    printWindow.onload = function() {
                        printWindow.print();
                    };
                }
            });

            initSelect2('.select2');
            
            // Handle Product/Variant Selection
            jQuery(document).on('select2:select', '.variant-select', function(e) {
                const data = e.params.data;
                const $row = jQuery(this).closest('.item-row');
                
                // Set Product ID hidden field
                $row.find('.product-id').val(data.product_id);

                // Set Manufacturer
                if (data.manufacturer_id && data.manufacturer_id !== 'n/a') {
                    $row.find('.manufacturer-select').val(data.manufacturer_id);
                } else {
                    $row.find('.manufacturer-select').val('n/a');
                }

                // Set Brand
                if (data.brand_id && data.brand_id !== 'n/a') {
                    $row.find('.brand-select').val(data.brand_id);
                } else {
                    $row.find('.brand-select').val('n/a');
                }

                // Set Unit
                if (data.unit_id) {
                    $row.find('.unit-select').val(data.unit_id);
                }
            });

            // Auto Sum Logic
            jQuery(document).on('input', '.qty-input, .price-input', function() {
                const $row = jQuery(this).closest('.item-row');
                const qty = parseFloat($row.find('.qty-input').val()) || 0;
                const price = parseFloat($row.find('.price-input').val()) || 0;
                const total = (qty * price).toFixed(2);
                
                $row.find('.total-input').val(total);
                calculateGrandTotal();
            });

            function calculateGrandTotal() {
                let grandTotal = 0;
                jQuery('.total-input').each(function() {
                    grandTotal += parseFloat(jQuery(this).val()) || 0;
                });
                jQuery('#grand-total').text(grandTotal.toFixed(2));
            }

            jQuery('#add-item').click(function() {
                const manufacturerOptions = jQuery('#templates .tpl-manufacturer').html();
                const brandOptions = jQuery('#templates .tpl-brand').html();
                const unitOptions = jQuery('#templates .tpl-unit').html();

                const newRow = `
                    <tr class="item-row border-b border-gray-100">
                        <td class="px-3 py-4">
                            <input type="hidden" name="items[${itemIndex}][product_id]" class="product-id">
                            <select name="items[${itemIndex}][variant_id]" class="variant-select block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm" required>
                                <option value="">Search Product...</option>
                            </select>
                        </td>
                        <td class="px-3 py-4">
                            <select name="items[${itemIndex}][manufacturer_id]" class="manufacturer-select block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm">
                                ${manufacturerOptions}
                            </select>
                        </td>
                        <td class="px-3 py-4">
                            <select name="items[${itemIndex}][brand_id]" class="brand-select block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm">
                                ${brandOptions}
                            </select>
                        </td>
                        <td class="px-3 py-4">
                            <select name="items[${itemIndex}][unit_id]" class="unit-select block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm" required>
                                ${unitOptions}
                            </select>
                        </td>
                        <td class="px-3 py-4">
                            <input type="number" step="0.01" name="items[${itemIndex}][quantity]" class="qty-input block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm" placeholder="0.00" required>
                        </td>
                        <td class="px-3 py-4">
                            <input type="number" step="0.01" name="items[${itemIndex}][unit_price]" class="price-input block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm" placeholder="0.00" required>
                        </td>
                        <td class="px-3 py-4">
                            <input type="number" step="0.01" class="total-input block w-full rounded-md border-gray-100 bg-gray-50 sm:text-sm" placeholder="0.00" readonly>
                        </td>
                        <td class="px-3 py-4 text-center">
                            <button type="button" class="remove-item text-red-600 hover:text-red-900">
                                <svg class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" />
                                </svg>
                            </button>
                        </td>
                    </tr>
                `;
                jQuery('#items-container').append(newRow);
                initProductSelect2(jQuery(`#items-container .item-row:last .variant-select`));
                itemIndex++;
            });

            jQuery(document).on('click', '.remove-item', function() {
                if (jQuery('.item-row').length > 1) {
                    jQuery(this).closest('.item-row').remove();
                    calculateGrandTotal();
                } else {
                    alert('At least one item is required.');
                }
            });
        }
    </script>
    <style>
        .select2-container--default .select2-selection--single {
            border-color: #D1D5DB;
            height: 38px;
            padding-top: 4px;
        }
        .select2-container--default .select2-selection--single .select2-selection__arrow {
            height: 36px;
        }
    </style>
    @endpush
</x-tenant-layout>
