<x-tenant-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Stock Adjustments') }}
        </h2>
    </x-slot>

    <div class="py-6">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h4>Stock Adjustments</h4>
                <div>
                    <a href="{{ route('tenant.reports.stock') }}" class="btn btn-outline-primary">
                        <i class="fas fa-chart-bar"></i> Stock Report
                    </a>
                    <a href="{{ route('tenant.stock.adjustments.history') }}" class="btn btn-outline-info">
                        <i class="fas fa-history"></i> Adjustment History
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Make Stock Adjustment</h5>
                </div>
                <div class="card-body">
                    <form id="stockAdjustmentForm">
                        <div class="mb-3">
                            <label for="variant_id" class="form-label">Product Variant *</label>
                            <select class="form-select" id="variant_id" name="variant_id" required>
                                <option value="">Select Product Variant</option>
                                @foreach($variants as $variant)
                                    <option value="{{ $variant->id }}" data-stock="{{ $variant->stock }}">
                                        {{ $variant->full_name }} (Current Stock: {{ $variant->stock }})
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <div class="mb-3">
                            <label for="adjustment_type" class="form-label">Adjustment Type *</label>
                            <select class="form-select" id="adjustment_type" name="adjustment_type" required>
                                <option value="add">Add Stock</option>
                                <option value="subtract">Subtract Stock</option>
                                <option value="set">Set Stock Level</option>
                            </select>
                        </div>

                        <div class="mb-3">
                            <label for="quantity" class="form-label">Quantity *</label>
                            <input type="number" class="form-control" id="quantity" name="quantity" 
                                   min="0" step="0.01" required>
                            <div class="form-text" id="quantityHelp"></div>
                        </div>

                        <div class="mb-3">
                            <label for="reason" class="form-label">Reason *</label>
                            <textarea class="form-control" id="reason" name="reason" rows="3" 
                                      placeholder="e.g., Stock count, Damaged items, New inventory received" required></textarea>
                        </div>

                        <div class="alert alert-info" id="previewAlert" style="display: none;">
                            <strong>Preview:</strong> <span id="previewText"></span>
                        </div>

                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> Process Adjustment
                        </button>
                        <button type="reset" class="btn btn-outline-secondary">
                            <i class="fas fa-times"></i> Clear
                        </button>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Quick Stock Status</h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>Product</th>
                                    <th>Current Stock</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($variants->take(10) as $variant)
                                    <tr>
                                        <td>{{ $variant->full_name }}</td>
                                        <td>{{ $variant->stock }}</td>
                                        <td>
                                            @if($variant->stock <= 0)
                                                <span class="badge bg-danger">Out of Stock</span>
                                            @elseif($variant->stock < 10)
                                                <span class="badge bg-warning">Low Stock</span>
                                            @else
                                                <span class="badge bg-success">Normal</span>
                                            @endif
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    @if($variants->count() > 10)
                        <div class="text-center mt-2">
                            <small class="text-muted">Showing 10 of {{ $variants->count() }} variants</small>
                        </div>
                    @endif
                </div>
            </div>

            <div class="card mt-3">
                <div class="card-header">
                    <h5 class="mb-0">Adjustment Guidelines</h5>
                </div>
                <div class="card-body">
                    <ul class="list-unstyled mb-0">
                        <li class="mb-2">
                            <i class="fas fa-plus-circle text-success"></i>
                            <strong>Add Stock:</strong> Increase inventory quantity
                        </li>
                        <li class="mb-2">
                            <i class="fas fa-minus-circle text-danger"></i>
                            <strong>Subtract Stock:</strong> Decrease inventory quantity
                        </li>
                        <li class="mb-2">
                            <i class="fas fa-edit text-warning"></i>
                            <strong>Set Stock:</strong> Set exact stock level
                        </li>
                        <li class="mb-0">
                            <i class="fas fa-info-circle text-info"></i>
                            <strong>Important:</strong> All adjustments are logged for audit purposes
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
</x-tenant-layout>
