<x-tenant-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Stock Adjustment History') }}
        </h2>
    </x-slot>

    <div class="py-6">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h4>Stock Adjustment History</h4>
                <div>
                    <a href="{{ route('tenant.stock.adjustments.index') }}" class="btn btn-primary">
                        <i class="fas fa-plus"></i> New Adjustment
                    </a>
                    <a href="{{ route('tenant.reports.stock-movement') }}" class="btn btn-outline-info">
                        <i class="fas fa-exchange-alt"></i> All Stock Movements
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Filters -->
    <div class="card mb-4">
        <div class="card-header">
            <h5 class="mb-0">Filters</h5>
        </div>
        <div class="card-body">
            <form method="GET" action="{{ route('tenant.stock.adjustments.history') }}">
                <div class="row">
                    <div class="col-md-4">
                        <label for="variant_id" class="form-label">Product Variant</label>
                        <select class="form-select" id="variant_id" name="variant_id">
                            <option value="">All Variants</option>
                            @foreach(\App\Models\Tenant\ProductVariant::with('product')->get() as $variant)
                                <option value="{{ $variant->id }}" {{ $variantId == $variant->id ? 'selected' : '' }}>
                                    {{ $variant->product->name }} - {{ $variant->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">&nbsp;</label>
                        <div class="d-block">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-filter"></i> Apply Filters
                            </button>
                            <a href="{{ route('tenant.stock.adjustments.history') }}" class="btn btn-outline-secondary">
                                <i class="fas fa-times"></i> Clear
                            </a>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Adjustment History Table -->
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Adjustment Records</h5>
            <div>
                <button class="btn btn-success btn-sm" onclick="exportHistory()">
                    <i class="fas fa-download"></i> Export
                </button>
                <button class="btn btn-info btn-sm" onclick="printHistory()">
                    <i class="fas fa-print"></i> Print
                </button>
            </div>
        </div>
        <div class="card-body">
            @if($movements->count() > 0)
                <div class="table-responsive">
                    <table class="table table-striped" id="historyTable">
                        <thead>
                            <tr>
                                <th>Date & Time</th>
                                <th>Product</th>
                                <th>Variant</th>
                                <th>Quantity</th>
                                <th>Reason</th>
                                <th>User</th>
                                <th>Notes</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($movements as $movement)
                                <tr>
                                    <td>{{ $movement->created_at->format('Y-m-d H:i:s') }}</td>
                                    <td>{{ $movement->variant->product->name }}</td>
                                    <td>{{ $movement->variant->name }}</td>
                                    <td>
                                        <span class="badge bg-info">
                                            +{{ number_format($movement->quantity, 2) }}
                                        </span>
                                    </td>
                                    <td>{{ $movement->notes ? explode('(', $movement->notes)[0] : '-' }}</td>
                                    <td>{{ $movement->user->name ?? 'System' }}</td>
                                    <td>
                                        <button class="btn btn-sm btn-outline-primary" onclick="showDetails({{ $movement->id }})">
                                            <i class="fas fa-eye"></i> Details
                                        </button>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="d-flex justify-content-between align-items-center mt-3">
                    <div>
                        Showing {{ $movements->firstItem() }} to {{ $movements->lastItem() }} 
                        of {{ $movements->total() }} entries
                    </div>
                    <div>
                        {{ $movements->links() }}
                    </div>
                </div>
            @else
                <div class="text-center py-4">
                    <i class="fas fa-history fa-3x text-muted mb-3"></i>
                    <h5 class="text-muted">No adjustment history found</h5>
                    <p class="text-muted">Stock adjustments will appear here once made.</p>
                </div>
            @endif
        </div>
    </div>
</div>
</x-tenant-layout>
