<x-tenant-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Settings') }}
        </h2>
    </x-slot>

    <div class="py-6">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <h3 class="text-lg font-medium text-gray-900 border-b pb-2 mb-4">Store Settings</h3>
                    
                    <form action="{{ route('tenant.settings.update') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        @method('PUT')
                        <div class="grid grid-cols-1 gap-6">
                            <!-- Logo & Icon -->
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Store Logo</label>
                                    @if($logo)
                                        <div class="mt-2 mb-2">
                                            <img src="{{ Storage::url($logo) }}" alt="Logo" class="h-16 object-contain">
                                        </div>
                                    @endif
                                    <input type="file" name="tenant_logo" class="mt-1 block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-md file:border-0 file:text-sm file:font-semibold file:bg-indigo-50 file:text-indigo-700 hover:file:bg-indigo-100">
                                    <p class="text-xs text-gray-500 mt-1">Recommended height: 64px</p>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Store Icon (Favicon)</label>
                                    @if($icon)
                                        <div class="mt-2 mb-2">
                                            <img src="{{ Storage::url($icon) }}" alt="Icon" class="h-8 w-8 object-contain">
                                        </div>
                                    @endif
                                    <input type="file" name="tenant_icon" class="mt-1 block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-md file:border-0 file:text-sm file:font-semibold file:bg-indigo-50 file:text-indigo-700 hover:file:bg-indigo-100">
                                </div>
                            </div>

                            <!-- Basic Info -->
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Store Name</label>
                                    <input type="text" name="store_name" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" value="{{ $storeName }}">
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Theme Color</label>
                                    <div class="flex mt-1">
                                        <input type="color" name="theme_color" class="h-10 w-10 border-0 p-0 rounded overflow-hidden" value="{{ $themeColor }}">
                                        <input type="text" name="theme_color" class="ml-2 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 uppercase" value="{{ $themeColor }}">
                                    </div>
                                </div>
                            </div>

                            <!-- Localization -->
                            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Currency Code</label>
                                    <select name="currency" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                        <option value="USD" {{ $currency == 'USD' ? 'selected' : '' }}>USD</option>
                                        <option value="EUR" {{ $currency == 'EUR' ? 'selected' : '' }}>EUR</option>
                                        <option value="GBP" {{ $currency == 'GBP' ? 'selected' : '' }}>GBP</option>
                                        <option value="INR" {{ $currency == 'INR' ? 'selected' : '' }}>INR</option>
                                        <option value="BDT" {{ $currency == 'BDT' ? 'selected' : '' }}>BDT</option>
                                    </select>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Currency Symbol</label>
                                    <input type="text" name="currency_symbol" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" value="{{ $currencySymbol }}">
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Date Format</label>
                                    <select name="date_format" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                        <option value="Y-m-d" {{ $dateFormat == 'Y-m-d' ? 'selected' : '' }}>YYYY-MM-DD (2024-12-31)</option>
                                        <option value="d/m/Y" {{ $dateFormat == 'd/m/Y' ? 'selected' : '' }}>DD/MM/YYYY (31/12/2024)</option>
                                        <option value="m/d/Y" {{ $dateFormat == 'm/d/Y' ? 'selected' : '' }}>MM/DD/YYYY (12/31/2024)</option>
                                        <option value="d-M-Y" {{ $dateFormat == 'd-M-Y' ? 'selected' : '' }}>DD-MMM-YYYY (31-Dec-2024)</option>
                                    </select>
                                </div>
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700">Timezone</label>
                                <select name="timezone" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                    @foreach(timezone_identifiers_list() as $tz)
                                        <option value="{{ $tz }}" {{ $timezone == $tz ? 'selected' : '' }}>{{ $tz }}</option>
                                    @endforeach
                                </select>
                            </div>

                            <!-- Reports -->
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Report Header (HTML Supported)</label>
                                <textarea name="report_header" rows="3" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">{{ $reportHeader }}</textarea>
                            </div>

                             <div>
                                <label class="block text-sm font-medium text-gray-700">Report Footer (HTML Supported)</label>
                                <textarea name="report_footer" rows="2" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">{{ $reportFooter }}</textarea>
                            </div>
                            
                            <div>
                                <button type="submit" class="bg-indigo-600 text-white font-bold py-2 px-4 rounded hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                                    Save Store Settings
                                </button>
                            </div>
                        </div>
                    </form>

                    <h3 class="text-lg font-medium text-gray-900 border-b pb-2 mb-4 mt-8">Loyalty Program Settings</h3>
                    <form action="{{ route('tenant.settings.update') }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="grid grid-cols-1 gap-6">
                             <div class="flex items-center">
                                <input type="checkbox" name="loyalty_enabled" id="loyalty_enabled" value="1" {{ $loyaltyEnabled == '1' ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm focus:ring-indigo-500">
                                <label for="loyalty_enabled" class="ml-2 block text-sm font-medium text-gray-700">Enable Loyalty Program</label>
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700">Conversion Rate (Points needed for 1 Currency Unit)</label>
                                <div class="mt-1 flex rounded-md shadow-sm">
                                    <input type="number" name="loyalty_conversion_rate" value="{{ $conversionRate }}" min="1" class="block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm">
                                    <span class="inline-flex items-center px-3 rounded-r-md border border-l-0 border-gray-300 bg-gray-50 text-gray-500 text-sm">
                                        Points = 1 {{ config('app.currency', '$') }}
                                    </span>
                                </div>
                                <p class="text-xs text-gray-500 mt-1">Example: If set to 100, customer needs 100 points to get 1 Currency Unit in wallet balance.</p>
                            </div>
                            
                            <div>
                                <button type="submit" class="bg-indigo-600 text-white font-bold py-2 px-4 rounded hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                                    Save Loyalty Settings
                                </button>
                            </div>
                        </div>
                    </form>

                    <h3 class="text-lg font-medium text-gray-900 border-b pb-2 mb-4 mt-8">Data Management</h3>
                    <div class="bg-gray-50 p-4 rounded-lg border border-gray-200">
                        <p class="text-sm text-gray-600 mb-4">Manage your store's data. You can generate demo data to test features or clean all data to start fresh.</p>
                        
                        <div class="flex flex-col sm:flex-row gap-4">
                            <!-- Generate Demo Data -->
                            <form action="{{ route('tenant.settings.generate-demo') }}" method="POST" onsubmit="return confirm('This will generate sample products, customers, and sales. Continue?');">
                                @csrf
                                <button type="submit" class="bg-green-600 text-white font-bold py-2 px-4 rounded hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500 flex items-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19.428 15.428a2 2 0 00-1.022-.547l-2.384-.477a6 6 0 00-3.86.517l-.318.158a6 6 0 01-3.86.517L6.05 15.21a2 2 0 00-1.806.547M8 4h8l-1 1v5.172a2 2 0 00.586 1.414l5 5c1.26 1.26.367 3.414-1.415 3.414H4.828c-1.782 0-2.674-2.154-1.414-3.414l5-5A2 2 0 009 10.172V5L8 4z" />
                                    </svg>
                                    Generate Demo Data
                                </button>
                            </form>

                            <!-- Clean Data -->
                            <form action="{{ route('tenant.settings.clean-data') }}" method="POST" onsubmit="return confirm('WARNING: This will DELETE ALL products, customers, sales, and inventory data. This action cannot be undone. Are you sure?');">
                                @csrf
                                <button type="submit" class="bg-red-600 text-white font-bold py-2 px-4 rounded hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500 flex items-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" />
                                    </svg>
                                    Clean All Data
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-tenant-layout>
