<x-tenant-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Stock Report') }}
        </h2>
    </x-slot>

    <div class="py-6">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="row">
                <div class="col-12">


                    <div class="d-flex justify-content-between align-items-center mb-4">
                        <h4>Stock Report</h4>
                        <div>
                            <a href="{{ route('tenant.reports.index') }}" class="btn btn-outline-secondary">
                                <i class="fas fa-arrow-left"></i> Back to Reports
                            </a>
                            <button type="button" class="btn btn-success ml-2" onclick="exportStockReport()">
                                <i class="fas fa-file-excel"></i> Export to Excel
                            </button>
                        </div>
                    </div>

                    <div class="card mb-4">
                        <div class="card-header">
                            Filters
                        </div>
                        <div class="card-body">
                            <form id="stockReportFilterForm" method="GET" action="{{ route('tenant.reports.stock') }}"
                                class="row g-3 align-items-end">
                                <div class="col-md-3">
                                    <label for="start_date" class="form-label">Start Date</label>
                                    <input type="date" name="start_date" id="start_date" class="form-control"
                                        value="{{ $startDate ?? '' }}">
                                </div>
                                <div class="col-md-3">
                                    <label for="end_date" class="form-label">End Date</label>
                                    <input type="date" name="end_date" id="end_date" class="form-control"
                                        value="{{ $endDate ?? '' }}">
                                </div>
                                <div class="col-md-3">
                                    <label for="category_id" class="form-label">Category</label>
                                    <select name="category_id" id="category_id" class="form-select">
                                        <option value="">All Categories</option>
                                        @foreach ($categories as $id => $name)
                                            <option value="{{ $id }}"
                                                {{ (string) $id === (string) $categoryId ? 'selected' : '' }}>
                                                {{ $name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3">
                                    <label for="subcategory_id" class="form-label">Subcategory</label>
                                    <select name="subcategory_id" id="subcategory_id" class="form-select" disabled>
                                        <option value="">All Subcategories</option>
                                    </select>
                                </div>
                                <div class="col-md-3">
                                    <label for="stock_status" class="form-label">Stock Status</label>
                                    <select name="stock_status" id="stock_status" class="form-select">
                                        <option value="all" {{ $stockStatus == 'all' ? 'selected' : '' }}>All
                                        </option>
                                        <option value="low" {{ $stockStatus == 'low' ? 'selected' : '' }}>Low Stock
                                        </option>
                                        <option value="out" {{ $stockStatus == 'out' ? 'selected' : '' }}>Out of
                                            Stock</option>
                                        <option value="normal" {{ $stockStatus == 'normal' ? 'selected' : '' }}>Normal
                                            Stock</option>
                                    </select>
                                </div>
                                <div class="col-md-3">
                            <label for="product_search" class="form-label">Product Search</label>
                            <select name="product_id" id="product_search" class="form-select">
                                <option value="">Search for a product...</option>
                                @if ($selectedProduct)
                                    <option value="{{ $selectedProduct->id }}" selected>
                                        {{ $selectedProduct->name }}</option>
                                @endif
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label for="location" class="form-label">Location</label>
                            <input type="text" name="location" id="location" class="form-control"
                                placeholder="All Locations">
                        </div>
                                <div class="col-md-3">
                                    <button type="submit" class="btn btn-primary w-100">Apply Filters</button>
                                </div>
                                <div class="col-md-3">
                                    <a href="{{ route('tenant.reports.stock') }}"
                                        class="btn btn-outline-secondary w-100">Clear Filters</a>
                                </div>
                            </form>
                        </div>
                    </div>
                    @push('scripts')
                        <script>
                            function exportStockReport() {
                                const form = document.getElementById('stockReportFilterForm');
                                const formData = new FormData(form);
                                const params = new URLSearchParams(formData).toString();
                                window.location.href = "{{ route('tenant.reports.stock.export') }}?" + params;
                            }

                            $(document).ready(function() {
                                // Initialize Select2 for product search
                                $('#product_search').select2({
                                    placeholder: 'Search for products...',
                                    minimumInputLength: 2,
                                    ajax: {
                                        url: '{{ route('tenant.api.products.search') }}',
                                        dataType: 'json',
                                        delay: 250,
                                        data: function(params) {
                                            const categoryId = $('#category_id').val();
                                            const subcategoryId = $('#subcategory_id').val();
                                            return {
                                                q: params.term, // search term
                                                page: params.page,
                                                category_id: categoryId,
                                                subcategory_id: subcategoryId
                                            };
                                        },
                                        processResults: function(data, params) {
                                            params.page = params.page || 1;
                                            return {
                                                results: data.data,
                                                pagination: {
                                                    more: (params.page * 30) < data.total
                                                }
                                            };
                                        },
                                        cache: true
                                    },
                                    templateResult: function(product) {
                                        if (product.loading) return product.text;
                                        return product.name + (product.sku ? ' (SKU: ' + product.sku + ')' : '');
                                    },
                                    templateSelection: function(product) {
                                        return product.name || product.text;
                                    }
                                });

                                // Function to load subcategories
                                function loadSubcategories(categoryId, selectedSubcategoryId = null) {
                                    const subcategorySelect = $('#subcategory_id');
                                    subcategorySelect.empty().append('<option value="">All Subcategories</option>');
                                    if (categoryId) {
                                        subcategorySelect.prop('disabled', false);
                                        $.ajax({
                                            url: `/api/categories/${categoryId}/subcategories`,
                                            type: 'GET',
                                            dataType: 'json',
                                            success: function(data) {
                                                $.each(data, function(key, value) {
                                                    subcategorySelect.append('<option value="' + value.id + '">' +
                                                        value.name + '</option>');
                                                });
                                                if (selectedSubcategoryId) {
                                                    subcategorySelect.val(selectedSubcategoryId).trigger('change');
                                                }
                                            }
                                        });
                                    } else {
                                        subcategorySelect.prop('disabled', true);
                                    }
                                }

                                // Initial load of subcategories if a category is already selected
                                const initialCategoryId = $('#category_id').val();
                                const initialSubcategoryId = "{{ request('subcategory_id') }}";
                                if (initialCategoryId) {
                                    loadSubcategories(initialCategoryId, initialSubcategoryId);
                                }

                                // Event listener for category change
                                $('#category_id').on('change', function() {
                                    const categoryId = $(this).val();
                                    loadSubcategories(categoryId);
                                    $('#product_search').val(null).trigger('change'); // Clear product search
                                });

                                // Event listener for subcategory change
                                $('#subcategory_id').on('change', function() {
                                    $('#product_search').val(null).trigger('change'); // Clear product search
                                });
                            });
                        </script>
                    @endpush

                    <!-- Summary Cards -->
                    <div class="flex flex-wrap -mx-3 mb-6">
                        <div class="w-1/4 px-3 mb-6">
                            <div class="bg-gray-800 text-white rounded-lg shadow-md p-4">
                                <div class="flex justify-between">
                                    <div>
                                        <h4 class="text-xl font-bold mb-0">{{ $totalProducts }}</h4>
                                        <p class="text-base mb-0">Total Products</p>
                                    </div>
                                    <div class="self-center">
                                        <i class="fas fa-box fa-2x"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="w-1/4 px-3 mb-6">
                            <div class="bg-gray-600 text-white rounded-lg shadow-md p-4">
                                <div class="flex justify-between">
                                    <div>
                                        <h4 class="text-xl font-bold mb-0">{{ $totalVariants }}</h4>
                                        <p class="text-base mb-0">Total Variants</p>
                                    </div>
                                    <div class="self-center">
                                        <i class="fas fa-tags fa-2x"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="w-1/4 px-3 mb-6">
                            <div class="bg-green-500 text-white rounded-lg shadow-md p-4">
                                <div class="flex justify-between">
                                    <div>
                                        <h4 class="text-xl font-bold mb-0">${{ number_format($totalStockValue, 2) }}
                                        </h4>
                                        <p class="text-base mb-0">Total Stock Value</p>
                                    </div>
                                    <div class="self-center">
                                        <i class="fas fa-dollar-sign fa-2x"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="w-1/4 px-3 mb-6">
                            <div class="bg-yellow-500 text-white rounded-lg shadow-md p-4">
                                <div class="flex justify-between">
                                    <div>
                                        <h4 class="text-xl font-bold mb-0">{{ $lowStockCount + $outOfStockCount }}
                                        </h4>
                                        <p class="text-base mb-0">Stock Alerts</p>
                                    </div>
                                    <div class="self-center">
                                        <i class="fas fa-exclamation-triangle fa-2x"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>


                    <!-- Stock Report Table -->
                    <div class="bg-white shadow-md rounded-lg overflow-hidden">
                        <div class="px-6 py-4 bg-gray-100 border-b border-gray-200 flex justify-between items-center">
                            <h5 class="text-lg font-semibold text-gray-800">Stock Details</h5>
                            <div>
                                <button
                                    class="bg-green-500 hover:bg-green-600 text-white font-bold py-2 px-4 rounded text-sm"
                                    onclick="exportStockReport()">
                                    <i class="fas fa-download"></i> Export
                                </button>
                                <button
                                    class="bg-blue-500 hover:bg-blue-600 text-white font-bold py-2 px-4 rounded text-sm ml-2"
                                    onclick="printStockReport()">
                                    <i class="fas fa-print"></i> Print
                                </button>
                            </div>
                        </div>
                        <div class="p-4">
                            @if ($products->count() > 0)
                                <div class="overflow-x-auto">
                                    <table class="min-w-full divide-y divide-gray-200" id="stockTable">
                                        <thead class="bg-gray-50">
                                            <tr>
                                                <th scope="col"
                                                    class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                                    Product</th>
                                                <th scope="col"
                                                    class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                                    Category</th>
                                                <th scope="col"
                                                    class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                                    Variant</th>
                                                <th scope="col"
                                                    class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                                    SKU</th>
                                                <th scope="col"
                                                    class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                                    Barcode</th>
                                                <th scope="col"
                                                    class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                                    Stock Qty</th>
                                                <th scope="col"
                                                    class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                                    Price</th>
                                                <th scope="col"
                                                    class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                                    Stock Value</th>
                                                <th scope="col"
                                                    class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                                    Status</th>
                                            </tr>
                                        </thead>
                                        <tbody class="bg-white divide-y divide-gray-200">
                                            @foreach ($products as $product)
                                                @foreach ($product['variants'] as $variant)
                                                    <tr>
                                                        <td class="px-6 py-4 whitespace-nowrap">{{ $product['name'] }}
                                                        </td>
                                                        <td class="px-6 py-4 whitespace-nowrap">
                                                            {{ $product['category'] }}</td>
                                                        <td class="px-6 py-4 whitespace-nowrap">{{ $variant['name'] }}
                                                        </td>
                                                        <td class="px-6 py-4 whitespace-nowrap">{{ $variant['sku'] }}
                                                        </td>
                                                        <td class="px-6 py-4 whitespace-nowrap">
                                                            {{ $variant['barcode'] }}</td>
                                                        <td class="px-6 py-4 whitespace-nowrap">
                                                            <span
                                                                class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium leading-4 bg-{{ $variant['status_color'] }}-100 text-{{ $variant['status_color'] }}-800">
                                                                {{ $variant['stock'] }} {{ $product['unit'] }}
                                                            </span>
                                                        </td>
                                                        <td class="px-6 py-4 whitespace-nowrap">
                                                            ${{ number_format($variant['price'], 2) }}</td>
                                                        <td class="px-6 py-4 whitespace-nowrap">
                                                            ${{ number_format($variant['stock_value'], 2) }}</td>
                                                        <td class="px-6 py-4 whitespace-nowrap">
                                                            @if ($variant['status'] == 'out')
                                                                <span
                                                                    class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium leading-4 bg-red-100 text-red-800">Out
                                                                    of Stock</span>
                                                            @elseif($variant['status'] == 'low')
                                                                <span
                                                                    class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium leading-4 bg-yellow-100 text-yellow-800">Low
                                                                    Stock</span>
                                                            @else
                                                                <span
                                                                    class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium leading-4 bg-green-100 text-green-800">Normal</span>
                                                            @endif
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            @endforeach
                                        </tbody>
                                        <tfoot>
                                            <tr class="bg-indigo-100 font-bold">
                                                <td colspan="6"
                                                    class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">
                                                    TOTALS</td>
                                                <td
                                                    class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">
                                                    ${{ number_format($products->sum('total_value'), 2) }}</td>
                                                <td class="px-6 py-4 whitespace-nowrap"></td>
                                                <td class="px-6 py-4 whitespace-nowrap"></td>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            @else
                                <div class="text-center py-4">
                                    <i class="fas fa-box-open fa-3x text-gray-400 mb-3"></i>
                                    <h5 class="text-gray-500 text-lg font-semibold">No products found</h5>
                                    <p class="text-gray-500">Try adjusting your filters or add some products to your
                                        inventory.</p>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
   

</x-tenant-layout>
