<x-tenant-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Stock Movement Report') }}
        </h2>
    </x-slot>

    <div class="py-6">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h4>Stock Movement Report</h4>
                <div>
                    <a href="{{ route('tenant.reports.index') }}" class="btn btn-outline-secondary">
                        <i class="fas fa-arrow-left"></i> Back to Reports
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Filters -->
    <div class="card mb-4">
        <div class="card-header">
            <h5 class="mb-0">Filters</h5>
        </div>
        <div class="card-body">
            <form method="GET" action="{{ route('tenant.reports.stock-movement') }}">
                <div class="row">
                    <div class="col-md-3">
                        <label for="start_date" class="form-label">Start Date</label>
                        <input type="date" class="form-control" id="start_date" name="start_date" 
                               value="{{ $startDate }}" required>
                    </div>
                    <div class="col-md-3">
                        <label for="end_date" class="form-label">End Date</label>
                        <input type="date" class="form-control" id="end_date" name="end_date" 
                               value="{{ $endDate }}" required>
                    </div>
                    <div class="col-md-3">
                        <label for="variant_id" class="form-label">Product Variant</label>
                        <select class="form-select" id="variant_id" name="variant_id">
                            <option value="">All Variants</option>
                            @foreach($variants as $variant)
                                <option value="{{ $variant->id }}" {{ $variantId == $variant->id ? 'selected' : '' }}>
                                    {{ $variant->full_name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label for="movement_type" class="form-label">Movement Type</label>
                        <select class="form-select" id="movement_type" name="movement_type">
                            <option value="all" {{ $movementType == 'all' ? 'selected' : '' }}>All Types</option>
                            <option value="sale" {{ $movementType == 'sale' ? 'selected' : '' }}>Sales</option>
                            <option value="purchase" {{ $movementType == 'purchase' ? 'selected' : '' }}>Purchases</option>
                            <option value="adjustment" {{ $movementType == 'adjustment' ? 'selected' : '' }}>Adjustments</option>
                            <option value="return" {{ $movementType == 'return' ? 'selected' : '' }}>Returns</option>
                            <option value="damage" {{ $movementType == 'damage' ? 'selected' : '' }}>Damage/Loss</option>
                        </select>
                    </div>
                    <div class="col-md-12 mt-3">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-filter"></i> Apply Filters
                        </button>
                        <a href="{{ route('tenant.reports.stock-movement') }}" class="btn btn-outline-secondary">
                            <i class="fas fa-times"></i> Clear
                        </a>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Stock Movement Table -->
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Stock Movements</h5>
            <div>
                <button class="btn btn-success btn-sm" onclick="exportMovementReport()">
                    <i class="fas fa-download"></i> Export
                </button>
                <button class="btn btn-info btn-sm" onclick="printMovementReport()">
                    <i class="fas fa-print"></i> Print
                </button>
            </div>
        </div>
        <div class="card-body">
            @if($movements->count() > 0)
                <div class="table-responsive">
                    <table class="table table-striped" id="movementTable">
                        <thead>
                            <tr>
                                <th>Date & Time</th>
                                <th>Product</th>
                                <th>Variant</th>
                                <th>Type</th>
                                <th>Quantity</th>
                                <th>Reference</th>
                                <th>User</th>
                                <th>Notes</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($movements as $movement)
                                <tr>
                                    <td>{{ $movement['date'] }}</td>
                                    <td>{{ $movement['product_name'] }}</td>
                                    <td>{{ $movement['variant_name'] }}</td>
                                    <td>
                                        @switch($movement['movement_type'])
                                            @case('sale')
                                                <span class="badge bg-danger">Sale</span>
                                                @break
                                            @case('purchase')
                                                <span class="badge bg-success">Purchase</span>
                                                @break
                                            @case('adjustment')
                                                <span class="badge bg-warning">Adjustment</span>
                                                @break
                                            @case('return')
                                                <span class="badge bg-info">Return</span>
                                                @break
                                            @case('damage')
                                                <span class="badge bg-secondary">Damage/Loss</span>
                                                @break
                                            @default
                                                <span class="badge bg-secondary">{{ ucfirst($movement['movement_type']) }}</span>
                                        @endswitch
                                    </td>
                                    <td>
                                        <span class="{{ in_array($movement['movement_type'], ['sale', 'damage']) ? 'text-danger' : 'text-success' }}">
                                            {{ in_array($movement['movement_type'], ['sale', 'damage']) ? '-' : '+' }}{{ abs($movement['quantity']) }}
                                        </span>
                                    </td>
                                    <td>
                                        @if($movement['reference_type'] && $movement['reference_id'])
                                            @switch($movement['reference_type'])
                                                @case('sale')
                                                    <a href="#" onclick="viewSale({{ $movement['reference_id'] }})" class="text-decoration-none">
                                                        Sale #{{ $movement['reference_id'] }}
                                                    </a>
                                                    @break
                                                @case('purchase')
                                                    <a href="#" onclick="viewPurchase({{ $movement['reference_id'] }})" class="text-decoration-none">
                                                        Purchase #{{ $movement['reference_id'] }}
                                                    </a>
                                                    @break
                                                @default
                                                    {{ ucfirst($movement['reference_type']) }} #{{ $movement['reference_id'] }}
                                            @endswitch
                                        @else
                                            Manual Entry
                                        @endif
                                    </td>
                                    <td>{{ $movement['user_name'] ?? 'System' }}</td>
                                    <td>{{ $movement['notes'] ?? '-' }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <div class="text-center py-4">
                    <i class="fas fa-exchange-alt fa-3x text-muted mb-3"></i>
                    <h5 class="text-muted">No stock movements found</h5>
                    <p class="text-muted">Try adjusting your filters or date range.</p>
                </div>
            @endif
        </div>
    </div>
</div>
</x-tenant-layout>
