<x-tenant-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Expiring Products Report') }}
        </h2>
    </x-slot>

    <div class="py-6">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <h3 class="text-lg font-semibold mb-4">Products Expiring Soon or Expired</h3>

                    @if($results->isEmpty())
                        <p>No products found that are expiring soon or have expired.</p>
                    @else
                        <div class="overflow-x-auto">
                            <table class="min-w-full divide-y divide-gray-200">
                                <thead class="bg-gray-50">
                                    <tr>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Product Name</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Variant</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Expiry Date</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Days Remaining / Status</th>
                                    </tr>
                                </thead>
                                <tbody class="bg-white divide-y divide-gray-200">
                                    @foreach($results as $product)
                                        @foreach($product->variants as $variant)
                                            @php
                                                $expiryDate = \Carbon\Carbon::parse($product->expiry_date);
                                                $daysRemaining = now()->diffInDays($expiryDate, false);
                                                $status = '';
                                                $statusColor = '';

                                                if ($expiryDate->isPast()) {
                                                    $status = 'Expired';
                                                    $statusColor = 'text-red-600 font-bold';
                                                } elseif ($daysRemaining <= 7) {
                                                    $status = 'Expiring Soon (' . $daysRemaining . ' days)';
                                                    $statusColor = 'text-orange-600 font-bold';
                                                } else {
                                                    $status = $daysRemaining . ' days remaining';
                                                    $statusColor = 'text-green-600';
                                                }
                                            @endphp
                                            <tr>
                                                <td class="px-6 py-4 whitespace-nowrap">{{ $product->name }}</td>
                                                <td class="px-6 py-4 whitespace-nowrap">{{ $variant->name }}</td>
                                                <td class="px-6 py-4 whitespace-nowrap">{{ $expiryDate->format('Y-m-d') }}</td>
                                                <td class="px-6 py-4 whitespace-nowrap {{ $statusColor }}">{{ $status }}</td>
                                            </tr>
                                        @endforeach
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</x-tenant-layout>
