<x-tenant-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                {{ __('Product Details') }}: {{ $product->name }}
            </h2>
            <div class="flex space-x-3">
                <a href="{{ route('tenant.products.edit', $product->id) }}" class="inline-flex items-center px-4 py-2 bg-blue-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-blue-700 active:bg-blue-900 focus:outline-none focus:border-blue-900 focus:ring ring-blue-300 disabled:opacity-25 transition ease-in-out duration-150 shadow-sm">
                    Edit Product
                </a>
                <a href="{{ route('tenant.products.index') }}" class="inline-flex items-center px-4 py-2 bg-gray-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-gray-700 active:bg-gray-900 focus:outline-none focus:border-gray-900 focus:ring ring-gray-300 disabled:opacity-25 transition ease-in-out duration-150 shadow-sm">
                    Back to Products
                </a>
            </div>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white shadow-sm rounded-lg">
                <!-- Product Header -->
                <div class="p-6 border-b border-gray-200">
                    <div class="flex items-start space-x-6">
                        @if($product->image)
                            <div class="flex-shrink-0">
                                <img src="{{ Storage::url($product->image) }}" alt="{{ $product->name }}" class="h-32 w-32 object-cover rounded-lg">
                            </div>
                        @else
                            <div class="flex-shrink-0 h-32 w-32 bg-gray-100 rounded-lg flex items-center justify-center">
                                <span class="text-4xl text-gray-400">📦</span>
                            </div>
                        @endif
                        
                        <div class="flex-1">
                            <h1 class="text-2xl font-bold text-gray-900">{{ $product->name }}</h1>
                            <div class="mt-2 flex items-center space-x-4 text-sm text-gray-500">
                                @if($product->category)
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
                                        {{ $product->category->name }}
                                    </span>
                                @endif
                                @if($product->brand)
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                        {{ $product->brand->name }}
                                    </span>
                                @endif
                                @if($product->has_variants)
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-purple-100 text-purple-800">
                                        {{ $product->variants->count }} Variants
                                    </span>
                                @endif
                            </div>
                            <div class="mt-4 text-sm text-gray-600">
                                <p><strong>Base Unit:</strong> {{ $product->unit->name }} ({{ $product->unit->short_name }})</p>
                                <p><strong>SKU:</strong> {{ $product->variants->first()?->sku ?? 'N/A' }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Variants Section -->
                @if($product->has_variants && $product->variants->count() > 0)
                    <div class="p-6 border-b border-gray-200">
                        <h3 class="text-lg font-medium text-gray-900 mb-4 flex items-center">
                            <span class="bg-purple-100 text-purple-800 text-xs font-semibold mr-2 px-2.5 py-0.5 rounded">Variants</span>
                            Product Variants ({{ $product->variants->count }})
                        </h3>
                        
                        <div class="overflow-x-auto shadow ring-1 ring-black ring-opacity-5 md:rounded-lg">
                            <table class="min-w-full divide-y divide-gray-300">
                                <thead class="bg-gray-50">
                                    <tr>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Variant</th>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">SKU</th>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Attributes</th>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Pricing</th>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Stock</th>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                                    </tr>
                                </thead>
                                <tbody class="bg-white divide-y divide-gray-200">
                                    @foreach($product->variants as $variant)
                                        <tr class="hover:bg-gray-50">
                                            <td class="px-6 py-4 whitespace-nowrap">
                                                <div class="text-sm font-medium text-gray-900">{{ $variant->name }}</div>
                                            </td>
                                            <td class="px-6 py-4 whitespace-nowrap">
                                                <div class="text-sm text-gray-900">{{ $variant->sku }}</div>
                                            </td>
                                            <td class="px-6 py-4">
                                                <div class="text-sm text-gray-900 space-y-1">
                                                    @foreach($variant->attributes as $attr)
                                                        <div>
                                                            <span class="font-medium">{{ $attr->name }}:</span>
                                                            <span class="text-gray-600">{{ $attr->value }}</span>
                                                        </div>
                                                    @endforeach
                                                    @if($variant->attributes->count() === 0)
                                                        <span class="text-gray-400">No attributes</span>
                                                    @endif
                                                </div>
                                            </td>
                                            <td class="px-6 py-4">
                                                <div class="text-sm text-gray-900 space-y-1">
                                                    @foreach($variant->prices as $price)
                                                        <div class="flex justify-between items-center">
                                                            <span class="font-medium {{ $price->productUnit->is_base ?? false ? 'text-gray-900' : 'text-purple-600' }}">
                                                                {{ $price->productUnit->name }}:
                                                            </span>
                                                            <span class="font-bold">
                                                                ${{ number_format($price->price, 2) }}
                                                            </span>
                                                        </div>
                                                    @endforeach
                                                    @if($variant->prices->count() === 0)
                                                        <span class="text-gray-400">No pricing set</span>
                                                    @endif
                                                </div>
                                            </td>
                                            <td class="px-6 py-4 whitespace-nowrap">
                                                <div class="text-sm text-gray-900">
                                                    {{ $variant->stock }} {{ $product->unit->short_name }}
                                                </div>
                                                @if($variant->stock <= 10)
                                                    <div class="text-xs text-red-600">Low Stock</div>
                                                @endif
                                            </td>
                                            <td class="px-6 py-4 whitespace-nowrap">
                                                @if($variant->is_active)
                                                    <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-green-100 text-green-800">
                                                        Active
                                                    </span>
                                                @else
                                                    <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-red-100 text-red-800">
                                                        Inactive
                                                    </span>
                                                @endif
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                @else
                    <div class="p-6 border-b border-gray-200">
                        <h3 class="text-lg font-medium text-gray-900 mb-4">Simple Product</h3>
                        <div class="bg-gray-50 rounded-lg p-4">
                            <p class="text-sm text-gray-600">This is a simple product without variants.</p>
                            @if($product->variants->count() > 0)
                                <div class="mt-4 grid grid-cols-2 gap-4">
                                    <div>
                                        <span class="text-sm font-medium text-gray-700">SKU:</span>
                                        <span class="ml-2 text-sm text-gray-900">{{ $product->variants->first()->sku }}</span>
                                    </div>
                                    <div>
                                        <span class="text-sm font-medium text-gray-700">Stock:</span>
                                        <span class="ml-2 text-sm text-gray-900">{{ $product->variants->first()->stock }} {{ $product->unit->short_name }}</span>
                                    </div>
                                    <div>
                                        <span class="text-sm font-medium text-gray-700">Price:</span>
                                        <span class="ml-2 text-sm text-gray-900">${{ number_format($product->variants->first()->price, 2) }}</span>
                                    </div>
                                    <div>
                                        <span class="text-sm font-medium text-gray-700">Cost:</span>
                                        <span class="ml-2 text-sm text-gray-900">${{ number_format($product->variants->first()->cost ?? 0, 2) }}</span>
                                    </div>
                                </div>
                            @endif
                        </div>
                    </div>
                @endif

                <!-- Additional Units -->
                @if($product->productUnits && $product->productUnits->where('is_base', false)->count() > 0)
                    <div class="p-6">
                        <h3 class="text-lg font-medium text-gray-900 mb-4">Additional Units</h3>
                        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                            @foreach($product->productUnits->where('is_base', false) as $unit)
                                <div class="bg-purple-50 rounded-lg p-4 border border-purple-200">
                                    <div class="font-medium text-purple-900">{{ $unit->name }}</div>
                                    <div class="text-sm text-purple-700 mt-1">
                                        1 {{ $unit->name }} = {{ $unit->conversion_factor }} {{ $product->unit->name }}
                                    </div>
                                    <div class="mt-2 flex space-x-2">
                                        @if($unit->is_purchase)
                                            <span class="text-xs bg-blue-100 text-blue-800 px-2 py-1 rounded">Purchase</span>
                                        @endif
                                        @if($unit->is_sale)
                                            <span class="text-xs bg-green-100 text-green-800 px-2 py-1 rounded">Sale</span>
                                        @endif
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </div>
</x-tenant-layout>
