<x-tenant-layout>
    <x-slot name="header">
        <h2 class="text-xl font-semibold text-gray-800">
            Notifications
            @if($unreadCount > 0)
                <span class="ml-2 inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
                    {{ $unreadCount }} unread
                </span>
            @endif
        </h2>
    </x-slot>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Actions -->
        <div class="mb-6 flex justify-between items-center">
            <div class="flex items-center space-x-4">
                <button onclick="markAllAsRead()" 
                        class="text-gray-600 hover:text-gray-800 text-sm">
                    Mark All as Read
                </button>
                <button onclick="refreshNotifications()" 
                        class="text-gray-600 hover:text-gray-800 text-sm">
                    Refresh
                </button>
            </div>
            <div class="text-sm text-gray-500">
                Total: {{ $notifications->total() }} notifications
            </div>
        </div>

        <!-- Notifications List -->
        <div class="bg-white shadow-sm rounded-lg">
            <div class="divide-y divide-gray-200">
                @forelse($notifications as $notification)
                    <div class="p-6 hover:bg-gray-50 {{ !$notification->is_read ? 'bg-blue-50' : '' }} cursor-pointer" 
                         onclick="viewNotification({{ $notification->id }})">
                        <div class="flex items-start justify-between">
                            <div class="flex-1">
                                <div class="flex items-center">
                                    <div class="flex-shrink-0">
                                        <div class="inline-flex items-center justify-center w-8 h-8 rounded-full
                                            @if($notification->type === 'info') bg-blue-100 text-blue-600
                                            @elseif($notification->type === 'success') bg-green-100 text-green-600
                                            @elseif($notification->type === 'warning') bg-yellow-100 text-yellow-600
                                            @elseif($notification->type === 'error') bg-red-100 text-red-600
                                            @else bg-gray-100 text-gray-600 @endif">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                @if($notification->type === 'info')
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                                @elseif($notification->type === 'success')
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                                @elseif($notification->type === 'warning')
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L4.082 15.5c-.77.833.192 2.5 1.732 2.5z"></path>
                                                @elseif($notification->type === 'error')
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                                @else
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                                @endif
                                            </svg>
                                        </div>
                                    </div>
                                    <div class="ml-3">
                                        <h3 class="text-lg font-medium text-gray-900">
                                            {{ $notification->title }}
                                            @if(!$notification->is_read)
                                                <span class="ml-2 inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
                                                    New
                                                </span>
                                            @endif
                                        </h3>
                                        <p class="mt-1 text-sm text-gray-600">{{ $notification->message }}</p>
                                        <div class="mt-2 flex items-center space-x-4 text-xs text-gray-500">
                                            <span>From: Admin</span>
                                            <span>{{ $notification->sent_at->diffForHumans() }}</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="ml-4 flex-shrink-0 flex space-x-2">
                                @if(!$notification->is_read)
                                    <button onclick="event.stopPropagation(); markAsRead({{ $notification->id }})" 
                                            class="text-green-600 hover:text-green-900 text-sm">
                                        Mark Read
                                    </button>
                                @endif
                                <button onclick="event.stopPropagation(); deleteNotification({{ $notification->id }})" 
                                        class="text-red-600 hover:text-red-900 text-sm">
                                    Delete
                                </button>
                            </div>
                        </div>
                    </div>
                @empty
                    <div class="p-6 text-center">
                        <div class="text-gray-400">
                            <svg class="w-12 h-12 mx-auto mb-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9"></path>
                            </svg>
                            <p class="text-sm">No notifications found</p>
                        </div>
                    </div>
                @endforelse
            </div>

            <!-- Pagination -->
            @if($notifications->hasPages())
                <div class="p-4 border-t">
                    {{ $notifications->links() }}
                </div>
            @endif
        </div>
    </div>

    <script>
        function viewNotification(id) {
            window.location.href = `{{ route('tenant.notifications.show', ':id') }}`.replace(':id', id);
        }

        function markAsRead(id) {
            fetch(`{{ route('tenant.notifications.read', ':id') }}`.replace(':id', id), {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    location.reload();
                }
            });
        }

        function markAllAsRead() {
            if (confirm('Mark all notifications as read?')) {
                fetch('{{ route('tenant.notifications.read-all') }}', {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                    }
                })
                .then(() => {
                    location.reload();
                });
            }
        }

        function deleteNotification(id) {
            if (confirm('Are you sure you want to delete this notification?')) {
                fetch(`{{ route('tenant.notifications.show', ':id') }}`.replace(':id', id), {
                    method: 'DELETE',
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                    }
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        location.reload();
                    }
                });
            }
        }

        function refreshNotifications() {
            location.reload();
        }

        // Auto-refresh every 30 seconds
        setInterval(() => {
            fetch('{{ route('tenant.notifications.unread-count') }}')
                .then(response => response.json())
                .then(data => {
                    // Update unread count in header if it changes
                    const currentCount = parseInt('{{ $unreadCount }}');
                    if (data.count !== currentCount) {
                        location.reload();
                    }
                });
        }, 30000);
    </script>
</x-tenant-layout>
