<x-tenant-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Requisition Details') }} #{{ $requisition->requisition_no }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg mb-6">
                <div class="p-6 border-b border-gray-200">
                    <div class="flex justify-between items-start mb-6">
                        <div>
                            <h3 class="text-lg font-bold text-gray-900">Supplier: {{ $requisition->supplier->name ?? 'N/A' }}</h3>
                            <p class="text-sm text-gray-500">Date: {{ $requisition->created_at->format('M d, Y') }}</p>
                            <p class="text-sm text-gray-500">Status: <span class="font-bold uppercase">{{ $requisition->status }}</span></p>
                        </div>
                        @if($requisition->status === 'pending')
                            <form action="{{ route('tenant.requisitions.approve', $requisition->id) }}" method="POST">
                                @csrf
                                <button type="submit" class="bg-green-600 hover:bg-green-700 text-white font-bold py-2 px-4 rounded">
                                    Approve Requisition
                                </button>
                            </form>
                        @endif
                    </div>

                    <table class="min-w-full divide-y divide-gray-200 border">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Product</th>
                                <th class="px-4 py-2 text-right text-xs font-medium text-gray-500 uppercase">Cost</th>
                                <th class="px-4 py-2 text-center text-xs font-medium text-gray-500 uppercase">Qty</th>
                                <th class="px-4 py-2 text-right text-xs font-medium text-gray-500 uppercase">Total</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-200">
                            @foreach($requisition->items as $item)
                            <tr>
                                <td class="px-4 py-2 text-sm text-gray-900">
                                    {{ $item->variant->product->name }} 
                                    @if($item->variant->name !== $item->variant->product->name)
                                        - {{ $item->variant->name }}
                                    @endif
                                </td>
                                <td class="px-4 py-2 text-sm text-gray-900 text-right">${{ number_format($item->cost_price, 2) }}</td>
                                <td class="px-4 py-2 text-sm text-gray-900 text-center">{{ $item->quantity }}</td>
                                <td class="px-4 py-2 text-sm text-gray-900 text-right font-medium">${{ number_format($item->total, 2) }}</td>
                            </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr class="bg-gray-50 font-bold">
                                <td colspan="3" class="px-4 py-2 text-right">Grand Total:</td>
                                <td class="px-4 py-2 text-right">${{ number_format($requisition->total_amount, 2) }}</td>
                            </tr>
                        </tfoot>
                    </table>

                    @if($requisition->note)
                        <div class="mt-4 p-4 bg-gray-50 rounded text-sm text-gray-600">
                            <strong>Note:</strong> {{ $requisition->note }}
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</x-tenant-layout>
