<x-tenant-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Process Purchase Order') }} (From {{ $requisition->requisition_no }})
        </h2>
    </x-slot>

    <div class="py-12" x-data="{ paidAmount: {{ $requisition->total_amount }}, total: {{ $requisition->total_amount }} }">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 bg-white border-b border-gray-200">
                    <form method="POST" action="{{ route('tenant.purchases.store') }}">
                        @csrf
                        <input type="hidden" name="purchase_requisition_id" value="{{ $requisition->id }}">
                        <input type="hidden" name="supplier_id" value="{{ $requisition->supplier_id }}">

                        <div class="mb-6">
                            <h3 class="text-lg font-bold text-gray-900 mb-2">Review Items</h3>
                            <p class="text-sm text-gray-500 mb-4">Verify quantities and costs before finalizing stock entry.</p>
                            
                            <table class="min-w-full divide-y divide-gray-200 border">
                                <thead class="bg-gray-50">
                                    <tr>
                                        <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Product</th>
                                        <th class="px-4 py-2 text-right text-xs font-medium text-gray-500 uppercase">Cost</th>
                                        <th class="px-4 py-2 text-center text-xs font-medium text-gray-500 uppercase">Qty</th>
                                        <th class="px-4 py-2 text-right text-xs font-medium text-gray-500 uppercase">Total</th>
                                    </tr>
                                </thead>
                                <tbody class="divide-y divide-gray-200">
                                    @foreach($requisition->items as $index => $item)
                                    <tr>
                                        <td class="px-4 py-2 text-sm text-gray-900">
                                            <input type="hidden" name="items[{{ $index }}][variant_id]" value="{{ $item->product_variant_id }}">
                                            {{ $item->variant->product->name }} 
                                            @if($item->variant->name !== $item->variant->product->name)
                                                - {{ $item->variant->name }}
                                            @endif
                                        </td>
                                        <td class="px-4 py-2 text-right">
                                            <input type="number" step="0.01" name="items[{{ $index }}][unit_cost]" value="{{ $item->cost_price }}" class="w-24 text-right border-gray-300 rounded-md text-sm p-1" readonly>
                                        </td>
                                        <td class="px-4 py-2 text-center">
                                            <input type="number" step="1" name="items[{{ $index }}][quantity]" value="{{ $item->quantity }}" class="w-20 text-center border-gray-300 rounded-md text-sm p-1" readonly>
                                        </td>
                                        <td class="px-4 py-2 text-right text-sm font-medium">
                                            ${{ number_format($item->total, 2) }}
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Total Amount</label>
                                <div class="mt-1 text-2xl font-bold text-gray-900">${{ number_format($requisition->total_amount, 2) }}</div>
                            </div>
                            <div>
                                <label for="paid_amount" class="block text-sm font-medium text-gray-700">Paid Amount</label>
                                <input type="number" step="0.01" name="paid_amount" id="paid_amount" x-model="paidAmount" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-green-500 focus:ring focus:ring-green-200 focus:ring-opacity-50">
                                <p class="mt-1 text-xs text-gray-500" x-show="paidAmount < total">Remaining balance will be added to supplier dues.</p>
                            </div>
                        </div>

                        <div class="flex items-center justify-end">
                            <a href="{{ route('tenant.requisitions.index') }}" class="text-gray-600 hover:text-gray-900 mr-4">Cancel</a>
                            <button type="submit" class="bg-green-600 hover:bg-green-700 text-white font-bold py-2 px-4 rounded">
                                Confirm Purchase & Update Stock
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-tenant-layout>
