<x-tenant-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Customer Profile') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                <!-- Profile Card -->
                <div class="md:col-span-1">
                    <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                        <div class="p-6 text-center">
                            @if($customer->image)
                                <img src="{{ Storage::url($customer->image) }}" alt="Profile" class="h-32 w-32 rounded-full object-cover mx-auto mb-4 border-4 border-green-100">
                            @else
                                <div class="h-32 w-32 rounded-full bg-green-100 flex items-center justify-center text-green-600 font-bold text-4xl mx-auto mb-4">
                                    {{ substr($customer->name, 0, 1) }}
                                </div>
                            @endif
                            <h3 class="text-xl font-bold text-gray-900">{{ $customer->name }}</h3>
                            <p class="text-gray-500">{{ $customer->email ?? 'No Email' }}</p>
                            
                            <div class="mt-4 flex justify-center space-x-2">
                                <span class="px-2 py-1 text-xs font-semibold rounded-full {{ $customer->is_active ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                                    {{ $customer->is_active ? 'Active' : 'Inactive' }}
                                </span>
                                @if($customer->allow_credit)
                                    <span class="px-2 py-1 text-xs font-semibold rounded-full bg-blue-100 text-blue-800">
                                        Credit Allowed
                                    </span>
                                @endif
                                @if($customer->is_sub_dealer)
                                    <span class="px-2 py-1 text-xs font-semibold rounded-full bg-purple-100 text-purple-800">
                                        Sub-Dealer
                                    </span>
                                @endif
                            </div>

                            <div class="mt-6 border-t pt-4 text-left">
                                <div class="mb-3">
                                    <span class="block text-xs text-gray-500 uppercase">Contact</span>
                                    <span class="text-sm font-medium text-gray-900">{{ $customer->contact ?? 'N/A' }}</span>
                                </div>
                                <div>
                                    <span class="block text-xs text-gray-500 uppercase">Address</span>
                                    <span class="text-sm font-medium text-gray-900">{{ $customer->address ?? 'N/A' }}</span>
                                </div>
                            </div>
                            
                            <div class="mt-6">
                                <a href="{{ route('tenant.customers.edit', $customer->id) }}" class="block w-full bg-gray-800 text-white font-bold py-2 px-4 rounded hover:bg-gray-700 transition">
                                    Edit Profile
                                </a>
                            </div>
                        </div>
                    </div>

                    <!-- Loyalty Card -->
                    <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg mt-6">
                        <div class="p-6">
                            <h3 class="text-lg font-bold text-gray-900 mb-4 flex items-center">
                                <svg class="w-5 h-5 mr-2 text-yellow-500" fill="currentColor" viewBox="0 0 20 20">
                                    <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/>
                                </svg>
                                Loyalty Program
                            </h3>
                            
                            <div class="bg-yellow-50 rounded-lg p-4 mb-4">
                                <div class="text-center">
                                    <span class="block text-3xl font-bold text-yellow-600">{{ number_format($customer->loyalty_points) }}</span>
                                    <span class="text-sm text-yellow-800">Available Points</span>
                                </div>
                                <div class="mt-2 text-center border-t border-yellow-200 pt-2">
                                     <span class="block text-xl font-bold text-green-600">${{ number_format($customer->wallet_balance, 2) }}</span>
                                     <span class="text-sm text-green-800">Wallet Balance</span>
                                </div>
                            </div>

                            @if(App\Models\Tenant\Setting::get('loyalty_enabled') == '1' && $customer->loyalty_points > 0)
                                <form action="{{ route('tenant.customers.convert-points', $customer->id) }}" method="POST" class="mt-4">
                                    @csrf
                                    <label class="block text-sm font-medium text-gray-700 mb-1">Convert Points to Wallet</label>
                                    <div class="flex space-x-2">
                                        <input type="number" name="points" max="{{ $customer->loyalty_points }}" min="1" value="{{ $customer->loyalty_points }}" class="block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm">
                                        <button type="submit" class="bg-indigo-600 text-white font-bold py-2 px-3 rounded text-sm hover:bg-indigo-700">
                                            Convert
                                        </button>
                                    </div>
                                    <p class="text-xs text-gray-500 mt-1">
                                        Rate: {{ App\Models\Tenant\Setting::get('loyalty_conversion_rate', 100) }} Points = 1 Currency
                                    </p>
                                </form>
                            @endif
                        </div>
                    </div>
                </div>

                <!-- Purchase History -->
                <div class="md:col-span-2">
                    <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg h-full">
                        <div class="p-6">
                            <h3 class="text-lg font-bold text-gray-900 mb-4">Purchase History</h3>
                            
                            @if($customer->sales->isEmpty())
                                <div class="text-center py-10 text-gray-500">
                                    <p>No purchases found for this customer.</p>
                                </div>
                            @else
                                <div class="overflow-x-auto">
                                    <table class="min-w-full divide-y divide-gray-200">
                                        <thead class="bg-gray-50">
                                            <tr>
                                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Date</th>
                                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Sale ID</th>
                                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Items</th>
                                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Total</th>
                                            </tr>
                                        </thead>
                                        <tbody class="bg-white divide-y divide-gray-200">
                                            @foreach($customer->sales as $sale)
                                            <tr>
                                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                                    {{ $sale->created_at->format('M d, Y H:i') }}
                                                </td>
                                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-indigo-600">
                                                    #{{ $sale->id }}
                                                </td>
                                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 text-right">
                                                    {{ $sale->items->sum('quantity') }}
                                                </td>
                                                <td class="px-6 py-4 whitespace-nowrap text-sm font-bold text-gray-900 text-right">
                                                    ${{ number_format($sale->total, 2) }}
                                                </td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-tenant-layout>
