<x-tenant-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Edit Customer') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 bg-white border-b border-gray-200">
                    <form method="POST" action="{{ route('tenant.customers.update', $customer->id) }}" enctype="multipart/form-data">
                        @csrf
                        @method('PUT')

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <!-- Basic Information -->
                            <div class="col-span-2">
                                <h3 class="text-lg font-medium text-gray-900 border-b pb-2 mb-4">Personal Details</h3>
                            </div>

                            <div>
                                <label for="name" class="block text-sm font-medium text-gray-700">Customer Name</label>
                                <input type="text" name="name" id="name" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-green-500 focus:ring focus:ring-green-200 focus:ring-opacity-50" value="{{ old('name', $customer->name) }}" required>
                            </div>

                            <div>
                                <label for="image" class="block text-sm font-medium text-gray-700">Profile Image</label>
                                @if($customer->image)
                                    <div class="mb-2">
                                        <img src="{{ Storage::url($customer->image) }}" alt="Profile" class="h-16 w-16 object-cover rounded-full border">
                                    </div>
                                @endif
                                <input type="file" name="image" id="image" class="mt-1 block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-green-50 file:text-green-700 hover:file:bg-green-100">
                            </div>

                            <div>
                                <label for="email" class="block text-sm font-medium text-gray-700">Email (Optional)</label>
                                <input type="email" name="email" id="email" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-green-500 focus:ring focus:ring-green-200 focus:ring-opacity-50" value="{{ old('email', $customer->email) }}">
                            </div>

                            <div>
                                <label for="contact" class="block text-sm font-medium text-gray-700">Contact Number (Optional)</label>
                                <input type="text" name="contact" id="contact" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-green-500 focus:ring focus:ring-green-200 focus:ring-opacity-50" value="{{ old('contact', $customer->contact) }}">
                            </div>

                            <div class="col-span-2">
                                <label for="address" class="block text-sm font-medium text-gray-700">Address (Optional)</label>
                                <textarea name="address" id="address" rows="3" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-green-500 focus:ring focus:ring-green-200 focus:ring-opacity-50">{{ old('address', $customer->address) }}</textarea>
                            </div>

                            <!-- Settings -->
                            <div class="col-span-2">
                                <h3 class="text-lg font-medium text-gray-900 border-b pb-2 mb-4">Account Settings</h3>
                            </div>

                            <div class="flex items-center">
                                <input type="checkbox" name="is_active" id="is_active" class="rounded border-gray-300 text-green-600 shadow-sm focus:border-green-300 focus:ring focus:ring-green-200 focus:ring-opacity-50" value="1" {{ $customer->is_active ? 'checked' : '' }}>
                                <label for="is_active" class="ml-2 block text-sm text-gray-900">Active Customer</label>
                            </div>

                            <div class="flex items-center">
                                <input type="checkbox" name="allow_credit" id="allow_credit" class="rounded border-gray-300 text-green-600 shadow-sm focus:border-green-300 focus:ring focus:ring-green-200 focus:ring-opacity-50" value="1" {{ $customer->allow_credit ? 'checked' : '' }}>
                                <label for="allow_credit" class="ml-2 block text-sm text-gray-900">Allow Credit / Due Purchases</label>
                            </div>

                            <div class="flex items-center">
                                <input type="checkbox" name="is_sub_dealer" id="is_sub_dealer" class="rounded border-gray-300 text-green-600 shadow-sm focus:border-green-300 focus:ring focus:ring-green-200 focus:ring-opacity-50" value="1" {{ $customer->is_sub_dealer ? 'checked' : '' }}>
                                <label for="is_sub_dealer" class="ml-2 block text-sm text-gray-900">Is Sub-Dealer (Can resell products)</label>
                            </div>
                        </div>

                        <div class="flex items-center justify-end mt-8">
                            <a href="{{ route('tenant.customers.index') }}" class="text-gray-600 hover:text-gray-900 mr-4">Cancel</a>
                            <button type="submit" class="bg-green-600 hover:bg-green-700 text-white font-bold py-2 px-4 rounded">
                                Update Customer
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-tenant-layout>
