<x-tenant-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Edit Unit') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 bg-white border-b border-gray-200">
                    <form method="POST" action="{{ route('tenant.units.update', $unit->id) }}" x-data="{ isBase: {{ $unit->base_unit_id ? 'false' : 'true' }} }">
                        @csrf
                        @method('PUT')

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <!-- Basic Info -->
                            <div>
                                <label for="name" class="block text-sm font-medium text-gray-700">Unit Name</label>
                                <input type="text" name="name" id="name" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-green-500 focus:ring focus:ring-green-200 focus:ring-opacity-50" value="{{ old('name', $unit->name) }}" required>
                            </div>

                            <div>
                                <label for="short_name" class="block text-sm font-medium text-gray-700">Short Name / Symbol</label>
                                <input type="text" name="short_name" id="short_name" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-green-500 focus:ring focus:ring-green-200 focus:ring-opacity-50" value="{{ old('short_name', $unit->short_name) }}" required>
                            </div>

                            <!-- Unit Relations -->
                            <div class="col-span-2">
                                <label class="block text-sm font-medium text-gray-700 mb-2">Unit Type</label>
                                <div class="flex items-center space-x-4">
                                    <label class="inline-flex items-center">
                                        <input type="radio" name="type" value="base" class="form-radio text-green-600" @click="isBase = true" {{ $unit->type === 'base' ? 'checked' : '' }}>
                                        <span class="ml-2">Base Unit</span>
                                    </label>
                                    <label class="inline-flex items-center">
                                        <input type="radio" name="type" value="purchase" class="form-radio text-green-600" @click="isBase = false" {{ $unit->type === 'purchase' ? 'checked' : '' }}>
                                        <span class="ml-2">Purchase Unit</span>
                                    </label>
                                    <label class="inline-flex items-center">
                                        <input type="radio" name="type" value="selling" class="form-radio text-green-600" @click="isBase = false" {{ $unit->type === 'selling' ? 'checked' : '' }}>
                                        <span class="ml-2">Selling Unit</span>
                                    </label>
                                </div>
                            </div>

                            <div x-show="!isBase" class="col-span-2 border-t pt-4 mt-2" style="{{ $unit->base_unit_id ? '' : 'display: none;' }}">
                                <h3 class="text-sm font-medium text-gray-900 mb-4">Conversion Details</h3>
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                    <div>
                                        <label for="base_unit_id" class="block text-sm font-medium text-gray-700">Base Unit</label>
                                        <select name="base_unit_id" id="base_unit_id" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-green-500 focus:ring focus:ring-green-200 focus:ring-opacity-50">
                                            <option value="">-- Select Base Unit --</option>
                                            @foreach($baseUnits as $baseUnit)
                                                <option value="{{ $baseUnit->id }}" {{ $unit->base_unit_id == $baseUnit->id ? 'selected' : '' }}>{{ $baseUnit->name }} ({{ $baseUnit->short_name }})</option>
                                            @endforeach
                                        </select>
                                    </div>

                                    <div>
                                        <label for="conversion_factor" class="block text-sm font-medium text-gray-700">Conversion Factor</label>
                                        <div class="flex items-center">
                                            <span class="text-gray-500 mr-2">1 Unit = </span>
                                            <input type="number" step="0.0001" name="conversion_factor" id="conversion_factor" class="block w-full rounded-md border-gray-300 shadow-sm focus:border-green-500 focus:ring focus:ring-green-200 focus:ring-opacity-50" value="{{ old('conversion_factor', $unit->conversion_factor) }}">
                                            <span class="text-gray-500 ml-2">Base Units</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="flex items-center justify-end mt-8">
                            <a href="{{ route('tenant.units.index') }}" class="text-gray-600 hover:text-gray-900 mr-4">Cancel</a>
                            <button type="submit" class="bg-green-600 hover:bg-green-700 text-white font-bold py-2 px-4 rounded">
                                Update Unit
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    
    <script src="//unpkg.com/alpinejs" defer></script>
</x-tenant-layout>
