<x-tenant-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Manufacturer Summary') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                <!-- Profile Card -->
                <div class="md:col-span-1">
                    <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                        <div class="p-6 text-center">
                            @if($manufacturer->image)
                                <img src="{{ Storage::url($manufacturer->image) }}" alt="Logo" class="h-32 w-32 object-contain mx-auto mb-4 border p-2 rounded">
                            @else
                                <div class="h-32 w-32 rounded bg-gray-100 flex items-center justify-center text-gray-400 text-4xl mx-auto mb-4">
                                    🏭
                                </div>
                            @endif
                            <h3 class="text-xl font-bold text-gray-900">{{ $manufacturer->name }}</h3>
                            <p class="text-sm text-gray-500">{{ $manufacturer->contact_person ?? 'No Contact Person' }}</p>
                            
                            <div class="mt-6 border-t pt-4 text-left">
                                <div class="mb-3">
                                    <span class="block text-xs text-gray-500 uppercase">Contact Number</span>
                                    <span class="text-sm font-medium text-gray-900">{{ $manufacturer->contact_no ?? 'N/A' }}</span>
                                </div>
                                <div>
                                    <span class="block text-xs text-gray-500 uppercase">Address</span>
                                    <span class="text-sm font-medium text-gray-900">{{ $manufacturer->address ?? 'N/A' }}</span>
                                </div>
                            </div>
                            
                            <div class="mt-6">
                                <a href="{{ route('tenant.manufacturers.edit', $manufacturer->id) }}" class="block w-full bg-gray-800 text-white font-bold py-2 px-4 rounded hover:bg-gray-700 transition">
                                    Edit Details
                                </a>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Financial Summary -->
                <div class="md:col-span-2">
                    <div class="grid grid-cols-1 sm:grid-cols-2 gap-4 mb-6">
                        <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg p-6 border-l-4 {{ $manufacturer->opening_balance > 0 ? 'border-red-500' : 'border-green-500' }}">
                            <h4 class="text-sm font-medium text-gray-500 uppercase tracking-wider">Current Balance (Due)</h4>
                            <p class="mt-2 text-3xl font-bold {{ $manufacturer->opening_balance > 0 ? 'text-red-600' : 'text-green-600' }}">
                                ${{ number_format($manufacturer->opening_balance, 2) }}
                            </p>
                            <p class="mt-1 text-xs text-gray-400">
                                {{ $manufacturer->opening_balance > 0 ? 'Payable to Manufacturer' : 'No Dues' }}
                            </p>
                        </div>
                        
                        <!-- Placeholder for future stats -->
                        <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg p-6 border-l-4 border-blue-500">
                            <h4 class="text-sm font-medium text-gray-500 uppercase tracking-wider">Total Purchases</h4>
                            <p class="mt-2 text-3xl font-bold text-gray-900">$0.00</p>
                            <p class="mt-1 text-xs text-gray-400">Lifetime Purchase Value</p>
                        </div>
                    </div>

                    <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                        <div class="p-6">
                            <h3 class="text-lg font-bold text-gray-900 mb-4">Transaction History (Closing Summary)</h3>
                            <div class="text-center py-10 text-gray-500">
                                <p>No transaction history available yet.</p>
                                <p class="text-xs mt-2">Purchase and payment history will appear here.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-tenant-layout>
