<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">
        <title>{{ config('app.name', 'Grocery SaaS') }}</title>
        @vite(['resources/css/app.css', 'resources/js/app.js'])
        <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
        <script>
            // Auto-refresh badge counts every 30 seconds
            setInterval(() => {
                // Refresh chat unread count
                fetch('{{ route('tenant.chat.unread-count') }}')
                    .then(response => response.json())
                    .then(data => {
                        document.querySelectorAll('[x-data*="unreadCount"]').forEach(el => {
                            const xInit = el.getAttribute('x-init');
                            if (xInit && xInit.includes('tenant.chat.unread-count')) {
                                el.__x.unreadCount = data.count;
                            }
                        });
                    })
                    .catch(() => {
                        // Silently handle errors
                    });
                
                // Refresh notification unread count (temporarily disabled)
                // fetch('{{ route('tenant.notifications.unread-count') }}')
                //     .then(response => response.ok ? response.json() : {count: 0})
                //     .then(data => {
                //         document.querySelectorAll('[x-data*="unreadCount"]').forEach(el => {
                //             if (el.getAttribute('x-init').includes('tenant.notifications.unread-count')) {
                //                 el.__x.unreadCount = data.count;
                //             }
                //         });
                //     })
                //     .catch(() => {
                //         // Silently handle errors
                //     });
            }, 30000);
        </script>
        <style>
            [x-cloak] { display: none !important; }
        </style>
    </head>
    <body class="font-sans antialiased text-gray-900 bg-gray-100" x-data="{ sidebarOpen: true }">
        <div class="flex h-screen overflow-hidden">
            <!-- Sidebar -->
            <div :class="sidebarOpen ? 'w-64' : 'w-20'" class="bg-gray-900 text-white flex-shrink-0 flex flex-col h-full transition-all duration-300">
                <div class="flex-shrink-0 flex items-center" :class="sidebarOpen ? 'p-6 justify-between' : 'p-4 justify-center'">
                    <div x-show="sidebarOpen" class="overflow-hidden whitespace-nowrap">
                        <h1 class="text-2xl font-bold text-green-400">Grocery SaaS</h1>
                        <p class="text-sm text-gray-400 mt-1">{{ Auth::user()->tenant->name ?? 'My Store' }}</p>
                    </div>
                    <button @click="sidebarOpen = !sidebarOpen" class="text-gray-400 hover:text-white focus:outline-none" :class="sidebarOpen ? '' : 'mb-4'">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                        </svg>
                    </button>
                </div>
                
                <!-- Scrollable Navigation -->
                <div class="flex-1 overflow-y-auto scrollbar-thin scrollbar-thumb-gray-700 scrollbar-track-gray-900">
                    <nav class="mt-2 space-y-1 px-2 pb-4">
                        <a href="{{ url('/dashboard') }}" class="block py-3 rounded transition flex items-center {{ request()->is('dashboard') ? 'bg-gray-800 text-white' : 'text-gray-400 hover:bg-gray-800 hover:text-white' }}" :class="sidebarOpen ? 'px-4' : 'px-2 justify-center'" :title="!sidebarOpen ? 'Dashboard' : ''">
                            <span class="inline-block w-5 text-center text-xl" :class="sidebarOpen ? 'mr-2' : ''">📊</span> 
                            <span x-show="sidebarOpen" class="whitespace-nowrap">Dashboard</span>
                        </a>
                        <a href="{{ route('tenant.pos.index') }}" class="block py-3 rounded transition flex items-center {{ request()->routeIs('tenant.pos.*') ? 'bg-gray-800 text-white' : 'text-gray-400 hover:bg-gray-800 hover:text-white' }}" :class="sidebarOpen ? 'px-4' : 'px-2 justify-center'" :title="!sidebarOpen ? 'POS System' : ''">
                            <span class="inline-block w-5 text-center text-xl" :class="sidebarOpen ? 'mr-2' : ''">🛍️</span>
                            <span x-show="sidebarOpen" class="whitespace-nowrap">POS System</span>
                        </a>
                        <a href="{{ route('tenant.sell.index') }}" class="block py-3 rounded transition flex items-center {{ request()->routeIs('tenant.sell.*') ? 'bg-gray-800 text-white' : 'text-gray-400 hover:bg-gray-800 hover:text-white' }}" :class="sidebarOpen ? 'px-4' : 'px-2 justify-center'" :title="!sidebarOpen ? 'Sell' : ''">
                            <span class="inline-block w-5 text-center text-xl" :class="sidebarOpen ? 'mr-2' : ''">🛒</span>
                            <span x-show="sidebarOpen" class="whitespace-nowrap">Sell</span>
                        </a>
                        
                        <div x-show="sidebarOpen" class="px-4 py-2 text-xs font-semibold text-gray-500 uppercase tracking-wider mt-2">
                            Catalog
                        </div>
                        <a href="{{ route('tenant.products.index') }}" class="block py-3 rounded transition flex items-center {{ request()->routeIs('tenant.products.*') ? 'bg-gray-800 text-white' : 'text-gray-400 hover:bg-gray-800 hover:text-white' }}" :class="sidebarOpen ? 'px-4' : 'px-2 justify-center'" :title="!sidebarOpen ? 'Products' : ''">
                            <span class="inline-block w-5 text-center text-xl" :class="sidebarOpen ? 'mr-2' : ''">📦</span>
                            <span x-show="sidebarOpen" class="whitespace-nowrap">Products</span>
                        </a>
                        <a href="{{ route('tenant.categories.index') }}" class="block py-3 rounded transition flex items-center {{ request()->routeIs('tenant.categories.*') ? 'bg-gray-800 text-white' : 'text-gray-400 hover:bg-gray-800 hover:text-white' }}" :class="sidebarOpen ? 'px-4' : 'px-2 justify-center'" :title="!sidebarOpen ? 'Categories' : ''">
                            <span class="inline-block w-5 text-center text-xl" :class="sidebarOpen ? 'mr-2' : ''">📂</span>
                            <span x-show="sidebarOpen" class="whitespace-nowrap">Categories</span>
                        </a>
                        <a href="{{ route('tenant.brands.index') }}" class="block py-3 rounded transition flex items-center {{ request()->routeIs('tenant.brands.*') ? 'bg-gray-800 text-white' : 'text-gray-400 hover:bg-gray-800 hover:text-white' }}" :class="sidebarOpen ? 'px-4' : 'px-2 justify-center'" :title="!sidebarOpen ? 'Brands' : ''">
                            <span class="inline-block w-5 text-center text-xl" :class="sidebarOpen ? 'mr-2' : ''">🏷️</span>
                            <span x-show="sidebarOpen" class="whitespace-nowrap">Brands</span>
                        </a>
                        <a href="{{ route('tenant.manufacturers.index') }}" class="block py-3 rounded transition flex items-center {{ request()->routeIs('tenant.manufacturers.*') ? 'bg-gray-800 text-white' : 'text-gray-400 hover:bg-gray-800 hover:text-white' }}" :class="sidebarOpen ? 'px-4' : 'px-2 justify-center'" :title="!sidebarOpen ? 'Manufacturers' : ''">
                            <span class="inline-block w-5 text-center text-xl" :class="sidebarOpen ? 'mr-2' : ''">🏭</span>
                            <span x-show="sidebarOpen" class="whitespace-nowrap">Manufacturers</span>
                        </a>
                        <a href="{{ route('tenant.units.index') }}" class="block py-3 rounded transition flex items-center {{ request()->routeIs('tenant.units.*') ? 'bg-gray-800 text-white' : 'text-gray-400 hover:bg-gray-800 hover:text-white' }}" :class="sidebarOpen ? 'px-4' : 'px-2 justify-center'" :title="!sidebarOpen ? 'Units' : ''">
                            <span class="inline-block w-5 text-center text-xl" :class="sidebarOpen ? 'mr-2' : ''">⚖️</span>
                            <span x-show="sidebarOpen" class="whitespace-nowrap">Units</span>
                        </a>

                        <div x-show="sidebarOpen" class="px-4 py-2 text-xs font-semibold text-gray-500 uppercase tracking-wider mt-2">
                            Inventory
                        </div>
                        <a href="{{ route('tenant.requisitions.index') }}" class="block py-3 rounded transition flex items-center {{ request()->routeIs('tenant.requisitions.*') ? 'bg-gray-800 text-white' : 'text-gray-400 hover:bg-gray-800 hover:text-white' }}" :class="sidebarOpen ? 'px-4' : 'px-2 justify-center'" :title="!sidebarOpen ? 'Requisitions' : ''">
                            <span class="inline-block w-5 text-center text-xl" :class="sidebarOpen ? 'mr-2' : ''">📝</span>
                            <span x-show="sidebarOpen" class="whitespace-nowrap">Requisitions</span>
                        </a>
                        <a href="{{ route('tenant.purchases.index') }}" class="block py-3 rounded transition flex items-center {{ request()->routeIs('tenant.purchases.*') ? 'bg-gray-800 text-white' : 'text-gray-400 hover:bg-gray-800 hover:text-white' }}" :class="sidebarOpen ? 'px-4' : 'px-2 justify-center'" :title="!sidebarOpen ? 'Purchases' : ''">
                            <span class="inline-block w-5 text-center text-xl" :class="sidebarOpen ? 'mr-2' : ''">🛒</span>
                            <span x-show="sidebarOpen" class="whitespace-nowrap">Purchases</span>
                        </a>
                        <a href="{{ route('tenant.stock.in.index') }}" class="block py-3 rounded transition flex items-center {{ request()->routeIs('tenant.stock.in.*') ? 'bg-gray-800 text-white' : 'text-gray-400 hover:bg-gray-800 hover:text-white' }}" :class="sidebarOpen ? 'px-4' : 'px-2 justify-center'" :title="!sidebarOpen ? 'Stock In' : ''">
                            <span class="inline-block w-5 text-center text-xl" :class="sidebarOpen ? 'mr-2' : ''">📥</span>
                            <span x-show="sidebarOpen" class="whitespace-nowrap">Manual Stock In</span>
                        </a>
                        <a href="{{ route('tenant.stock.mrr.index') }}" class="block py-3 rounded transition flex items-center {{ request()->routeIs('tenant.stock.mrr.*') ? 'bg-gray-800 text-white' : 'text-gray-400 hover:bg-gray-800 hover:text-white' }}" :class="sidebarOpen ? 'px-4' : 'px-2 justify-center'" :title="!sidebarOpen ? 'MRR (Stock In)' : ''">
                            <span class="inline-block w-5 text-center text-xl" :class="sidebarOpen ? 'mr-2' : ''">📋</span>
                            <span x-show="sidebarOpen" class="whitespace-nowrap">MRR (Stock In)</span>
                        </a>
                        <a href="{{ route('tenant.suppliers.index') }}" class="block py-3 rounded transition flex items-center {{ request()->routeIs('tenant.suppliers.*') ? 'bg-gray-800 text-white' : 'text-gray-400 hover:bg-gray-800 hover:text-white' }}" :class="sidebarOpen ? 'px-4' : 'px-2 justify-center'" :title="!sidebarOpen ? 'Suppliers' : ''">
                            <span class="inline-block w-5 text-center text-xl" :class="sidebarOpen ? 'mr-2' : ''">🚚</span>
                            <span x-show="sidebarOpen" class="whitespace-nowrap">Suppliers</span>
                        </a>
                        <a href="{{ route('tenant.locations.index') }}" class="block py-3 rounded transition flex items-center {{ request()->routeIs('tenant.locations.*') ? 'bg-gray-800 text-white' : 'text-gray-400 hover:bg-gray-800 hover:text-white' }}" :class="sidebarOpen ? 'px-4' : 'px-2 justify-center'" :title="!sidebarOpen ? 'Locations' : ''">
                            <span class="inline-block w-5 text-center text-xl" :class="sidebarOpen ? 'mr-2' : ''">📍</span>
                            <span x-show="sidebarOpen" class="whitespace-nowrap">Locations</span>
                        </a>

                        <div x-show="sidebarOpen" class="px-4 py-2 text-xs font-semibold text-gray-500 uppercase tracking-wider mt-2">
                            Operations
                        </div>
                        <a href="{{ route('tenant.customers.index') }}" class="block py-3 rounded transition flex items-center {{ request()->routeIs('tenant.customers.*') ? 'bg-gray-800 text-white' : 'text-gray-400 hover:bg-gray-800 hover:text-white' }}" :class="sidebarOpen ? 'px-4' : 'px-2 justify-center'" :title="!sidebarOpen ? 'Customers' : ''">
                            <span class="inline-block w-5 text-center text-xl" :class="sidebarOpen ? 'mr-2' : ''">👥</span>
                            <span x-show="sidebarOpen" class="whitespace-nowrap">Customers</span>
                        </a>
                        <a href="{{ route('tenant.returns.index') }}" class="block py-3 rounded transition flex items-center {{ request()->routeIs('tenant.returns.*') ? 'bg-gray-800 text-white' : 'text-gray-400 hover:bg-gray-800 hover:text-white' }}" :class="sidebarOpen ? 'px-4' : 'px-2 justify-center'" :title="!sidebarOpen ? 'Sales Returns' : ''">
                            <span class="inline-block w-5 text-center text-xl" :class="sidebarOpen ? 'mr-2' : ''">↩️</span>
                            <span x-show="sidebarOpen" class="whitespace-nowrap">Sales Returns</span>
                        </a>
                        <a href="{{ route('tenant.reports.index') }}" class="block py-3 rounded transition flex items-center {{ request()->routeIs('tenant.reports.*') ? 'bg-gray-800 text-white' : 'text-gray-400 hover:bg-gray-800 hover:text-white' }}" :class="sidebarOpen ? 'px-4' : 'px-2 justify-center'" :title="!sidebarOpen ? 'Reports' : ''">
                            <span class="inline-block w-5 text-center text-xl" :class="sidebarOpen ? 'mr-2' : ''">📈</span>
                            <span x-show="sidebarOpen" class="whitespace-nowrap">Reports</span>
                        </a>
                        <a href="{{ route('tenant.settings.index') }}" class="block py-3 rounded transition flex items-center {{ request()->routeIs('tenant.settings.*') ? 'bg-gray-800 text-white' : 'text-gray-400 hover:bg-gray-800 hover:text-white' }}" :class="sidebarOpen ? 'px-4' : 'px-2 justify-center'" :title="!sidebarOpen ? 'Settings' : ''">
                            <span class="inline-block w-5 text-center text-xl" :class="sidebarOpen ? 'mr-2' : ''">⚙️</span>
                            <span x-show="sidebarOpen" class="whitespace-nowrap">Settings</span>
                        </a>

                        <div x-show="sidebarOpen" class="px-4 py-2 text-xs font-semibold text-gray-500 uppercase tracking-wider mt-2">
                            Support
                        </div>
                        <a href="{{ route('tenant.chat.index') }}" class="block py-3 rounded transition flex items-center {{ request()->routeIs('tenant.chat.*') ? 'bg-gray-800 text-white' : 'text-gray-400 hover:bg-gray-800 hover:text-white' }}" :class="sidebarOpen ? 'px-4' : 'px-2 justify-center'" :title="!sidebarOpen ? 'Live Chat' : ''" x-data="{ unreadCount: 0 }" x-init="fetch('{{ route('tenant.chat.unread-count') }}').then(response => response.json()).then(data => unreadCount = data.count)">
                            <span class="inline-block w-5 text-center text-xl" :class="sidebarOpen ? 'mr-2' : ''">💬</span>
                            <span x-show="sidebarOpen" class="whitespace-nowrap">Live Chat</span>
                            <span x-show="unreadCount > 0" class="ml-2 inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-800" x-text="unreadCount"></span>
                        </a>
                        <a href="{{ route('tenant.notifications.index') }}" class="block py-3 rounded transition flex items-center {{ request()->routeIs('tenant.notifications.*') ? 'bg-gray-800 text-white' : 'text-gray-400 hover:bg-gray-800 hover:text-white' }}" :class="sidebarOpen ? 'px-4' : 'px-2 justify-center'" :title="!sidebarOpen ? 'Notifications' : ''" x-data="{ unreadCount: 0 }">
                            <span class="inline-block w-5 text-center text-xl" :class="sidebarOpen ? 'mr-2' : ''">🔔</span>
                            <span x-show="sidebarOpen" class="whitespace-nowrap">Notifications</span>
                            <span x-show="unreadCount > 0" class="ml-2 inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-800" x-text="unreadCount"></span>
                        </a>
                    </nav>
                </div>

                <!-- Subscription Status -->
                <div class="px-6 pb-2" x-show="sidebarOpen">
                    @php
                        $tenant = Auth::user()->tenant;
                        $subscription = $tenant->subscription()->where('ends_at', '>', now())->first();
                        $inTrial = $tenant->trial_ends_at && $tenant->trial_ends_at->isFuture();
                    @endphp
                    
                    @if($subscription)
                        <div class="bg-green-900 rounded p-2 text-xs">
                            <p class="text-green-300 font-bold">Plan: {{ $subscription->plan->name ?? 'Active' }}</p>
                            <p class="text-gray-400">Expires: {{ $subscription->ends_at->diffForHumans() }}</p>
                        </div>
                    @elseif($inTrial)
                        <div class="bg-blue-900 rounded p-2 text-xs">
                            <p class="text-blue-300 font-bold">Free Trial</p>
                            @php
                                $daysRemaining = $tenant->trial_ends_at->diffInDays(now(), false);
                            @endphp
                            @if($daysRemaining > 0)
                                <p class="text-gray-400">{{ $daysRemaining }} days remaining</p>
                            @else
                                <p class="text-yellow-400">Trial expired</p>
                            @endif
                            <a href="{{ route('tenant.subscription.index') }}" class="block mt-1 text-white underline">Buy Plan</a>
                        </div>
                    @else
                        <div class="bg-red-900 rounded p-2 text-xs">
                            <p class="text-red-300 font-bold">Read Only Mode</p>
                            <a href="{{ route('tenant.subscription.index') }}" class="block mt-1 text-white underline">Subscribe Now</a>
                        </div>
                    @endif
                </div>

                <!-- Footer User Profile -->
                <div class="bg-gray-900 border-t border-gray-800 flex-shrink-0" :class="sidebarOpen ? 'p-6' : 'p-2'">
                    <a href="{{ route('tenant.profile.edit') }}" class="flex items-center mb-4 hover:bg-gray-800 rounded p-2 transition" :class="sidebarOpen ? '' : 'justify-center mb-0'">
                        @if(Auth::user()->profile_photo_path)
                            <img src="{{ Storage::url(Auth::user()->profile_photo_path) }}" alt="{{ Auth::user()->name }}" class="h-8 w-8 rounded-full object-cover" :class="sidebarOpen ? 'mr-3' : ''">
                        @else
                            <div class="h-8 w-8 rounded-full bg-theme flex items-center justify-center text-white font-bold" :class="sidebarOpen ? 'mr-3' : ''">
                                {{ substr(Auth::user()->name, 0, 1) }}
                            </div>
                        @endif
                        <div x-show="sidebarOpen">
                            <p class="text-sm font-medium text-white">{{ Auth::user()->name }}</p>
                            <p class="text-xs text-gray-400">Manager</p>
                        </div>
                    </a>
                    <form method="POST" action="{{ route('tenant.logout') }}" x-show="sidebarOpen">
                        @csrf
                        <button type="submit" class="flex items-center text-gray-400 hover:text-white transition text-sm">
                            <span class="mr-2">🚪</span> Logout
                        </button>
                    </form>
                </div>
            </div>

            <!-- Main Content -->
            <div class="flex-1 flex flex-col overflow-hidden">
                <!-- Top Header -->
                @if(!request()->routeIs('tenant.sell.*'))
                <header class="bg-white shadow-sm z-10">
                    <div class="flex items-center justify-between px-6 py-4">
                        <h2 class="text-xl font-semibold text-gray-800">
                            {{ $header ?? 'Overview' }}
                        </h2>
                        <div class="flex items-center space-x-4">
                            <!-- Chat Icon -->
                            <a href="{{ route('tenant.chat.index') }}" class="relative text-gray-600 hover:text-gray-800 transition" x-data="{ unreadCount: 0 }" x-init="fetch('{{ route('tenant.chat.unread-count') }}').then(response => response.json()).then(data => unreadCount = data.count)">
                                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"></path>
                                </svg>
                                <span x-show="unreadCount > 0" class="absolute -top-1 -right-1 inline-flex items-center justify-center px-2 py-1 text-xs font-bold leading-none text-white bg-red-500 rounded-full" x-text="unreadCount"></span>
                            </a>
                            
                            <!-- Notifications Icon -->
                            <a href="{{ route('tenant.notifications.index') }}" class="relative text-gray-600 hover:text-gray-800 transition" x-data="{ unreadCount: 0 }">
                                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9"></path>
                                </svg>
                                <span x-show="unreadCount > 0" class="absolute -top-1 -right-1 inline-flex items-center justify-center px-2 py-1 text-xs font-bold leading-none text-white bg-red-500 rounded-full" x-text="unreadCount"></span>
                            </a>
                            
                            <!-- Date/Time -->
                            <span class="text-sm text-gray-500">{{ now()->format('l, F j, Y') }}</span>
                        </div>
                    </div>
                </header>
                @endif

                <!-- Page Content -->
                <main class="flex-1 overflow-x-hidden overflow-y-auto bg-gray-100 {{ request()->routeIs('tenant.sell.*') ? '' : 'p-6' }}">
                    <div class="max-w-7xl mx-auto">
                        @if(session('success'))
                            <div class="mb-4 bg-green-100 border-l-4 border-green-500 text-green-700 p-4 rounded shadow-sm flex items-center justify-between" x-data="{ show: true }" x-show="show">
                                <div class="flex items-center">
                                    <span class="mr-2 text-xl">✅</span>
                                    <span>{{ session('success') }}</span>
                                </div>
                                <button @click="show = false" class="text-green-700 hover:text-green-900">
                                    <svg class="h-4 w-4" fill="currentColor" viewBox="0 0 20 20"><path d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z"></path></svg>
                                </button>
                            </div>
                        @endif

                        @if(session('error'))
                            <div class="mb-4 bg-red-100 border-l-4 border-red-500 text-red-700 p-4 rounded shadow-sm flex items-center justify-between" x-data="{ show: true }" x-show="show">
                                <div class="flex items-center">
                                    <span class="mr-2 text-xl">❌</span>
                                    <span>{{ session('error') }}</span>
                                </div>
                                <button @click="show = false" class="text-red-700 hover:text-red-900">
                                    <svg class="h-4 w-4" fill="currentColor" viewBox="0 0 20 20"><path d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z"></path></svg>
                                </button>
                            </div>
                        @endif
                    </div>

                    @if(isset($slot))
                        {{ $slot }}
                    @else
                        @yield('content')
                    @endif
                </main>
            </div>
        </div>
        
        <script src="https://code.jquery.com/jquery-3.7.1.min.js" integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>
        <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
        <script>
            // Ensure jQuery is available globally
            window.jQuery = window.$ = jQuery;
        </script>
        @yield('scripts')
        @stack('scripts')
    </body>
</html>
