<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>System Error - Grocery SaaS</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 flex items-center justify-center min-h-screen">
    <div class="bg-white p-8 rounded-lg shadow-lg max-w-md w-full text-center">
        <div class="mb-6">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-16 w-16 text-red-500 mx-auto" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z" />
            </svg>
        </div>
        <h1 class="text-2xl font-bold text-gray-800 mb-2">System Error</h1>
        <p class="text-gray-600 mb-6">{{ $message ?? 'An unexpected error occurred.' }}</p>
        
        @if(isset($error) && config('app.debug'))
            <div class="bg-gray-100 p-4 rounded text-left text-xs font-mono text-red-600 mb-6 overflow-auto max-h-40">
                {{ $error }}
            </div>
        @endif

        <div class="flex justify-center space-x-4">
            <a href="{{ url()->previous() }}" class="bg-gray-500 hover:bg-gray-600 text-white font-bold py-2 px-4 rounded transition">
                Go Back
            </a>
            <a href="{{ route('tenant.dashboard') }}" class="bg-theme hover:bg-green-600 text-white font-bold py-2 px-4 rounded transition bg-green-500">
                Dashboard
            </a>
        </div>
    </div>
</body>
</html>
