@extends('layouts.developer')

@section('title', 'Create Role')

@section('content')
<div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="mb-8">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-3xl font-bold text-gray-900">Create New Role</h1>
                <p class="mt-2 text-gray-600">Define a new role and its permissions</p>
            </div>
            <a href="{{ route('developer.roles.index') }}" class="text-gray-600 hover:text-gray-900 flex items-center">
                <svg class="w-5 h-5 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
                </svg>
                Back to List
            </a>
        </div>
    </div>

    <div class="bg-white rounded-xl shadow-lg overflow-hidden">
        <form action="{{ route('developer.roles.store') }}" method="POST" class="p-8">
            @csrf
            
            <div class="mb-8">
                <label for="name" class="block text-sm font-medium text-gray-700 mb-1">Role Name</label>
                <input type="text" name="name" id="name" value="{{ old('name') }}" required placeholder="e.g. Editor, Support, Moderator"
                    class="w-full rounded-lg border-gray-300 shadow-sm focus:border-pink-500 focus:ring-pink-500">
                @error('name') <p class="mt-1 text-sm text-red-600">{{ $message }}</p> @enderror
            </div>

            <div class="mb-8">
                <h3 class="text-lg font-semibold text-gray-900 mb-4 border-b pb-2">Assign Permissions</h3>
                <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                    @foreach($permissions as $permission)
                    <div class="flex items-center p-3 rounded-lg border border-gray-100 hover:bg-gray-50 transition-colors">
                        <input type="checkbox" name="permissions[]" value="{{ $permission->name }}" id="perm_{{ $permission->id }}"
                            class="h-4 w-4 text-pink-600 focus:ring-pink-500 border-gray-300 rounded">
                        <label for="perm_{{ $permission->id }}" class="ml-3 text-sm text-gray-700 select-none cursor-pointer">
                            {{ $permission->name }}
                        </label>
                    </div>
                    @endforeach
                </div>
            </div>

            <div class="pt-6 border-t border-gray-100">
                <button type="submit" class="w-full md:w-auto bg-pink-600 hover:bg-pink-700 text-white font-bold py-3 px-8 rounded-lg shadow-lg transition duration-150">
                    Create Role
                </button>
            </div>
        </form>
    </div>
</div>
@endsection
