@extends('layouts.developer')

@section('title', 'Platform Analytics')

@section('content')
<div class="container mx-auto px-4 py-6">
    <div class="flex flex-col md:flex-row md:items-center justify-between gap-4 mb-6">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">Platform Analytics</h1>
            <p class="text-gray-600">Overview of platform performance, revenue, and growth.</p>
        </div>
        <form method="GET" action="{{ route('developer.reports.analytics') }}" class="flex items-center gap-2">
            <select name="period" onchange="this.form.submit()" class="text-sm border-gray-300 rounded-lg focus:ring-purple-500 focus:border-purple-500 bg-white">
                <option value="7" {{ $period == '7' ? 'selected' : '' }}>Last 7 Days</option>
                <option value="30" {{ $period == '30' ? 'selected' : '' }}>Last 30 Days</option>
                <option value="90" {{ $period == '90' ? 'selected' : '' }}>Last 90 Days</option>
                <option value="365" {{ $period == '365' ? 'selected' : '' }}>Last Year</option>
            </select>
        </form>
    </div>

    <!-- Stats Grid -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-8">
        <div class="bg-white p-6 rounded-xl border border-gray-100 shadow-sm">
            <div class="text-xs font-bold text-gray-400 uppercase mb-1">Total Revenue</div>
            <div class="text-2xl font-bold text-gray-900">${{ number_format($analytics['totalRevenue'], 2) }}</div>
            <div class="mt-2 text-xs text-green-600 flex items-center gap-1">
                <span>▲</span> {{ $analytics['revenueGrowth'] }}% vs prev period
            </div>
        </div>
        <div class="bg-white p-6 rounded-xl border border-gray-100 shadow-sm">
            <div class="text-xs font-bold text-gray-400 uppercase mb-1">New Tenants</div>
            <div class="text-2xl font-bold text-gray-900">{{ $analytics['newCustomers'] }}</div>
            <div class="mt-2 text-xs text-green-600 flex items-center gap-1">
                <span>▲</span> {{ $analytics['customerGrowth'] }}% vs prev period
            </div>
        </div>
        <div class="bg-white p-6 rounded-xl border border-gray-100 shadow-sm">
            <div class="text-xs font-bold text-gray-400 uppercase mb-1">Conversion Rate</div>
            <div class="text-2xl font-bold text-gray-900">{{ number_format($analytics['conversionRate'], 1) }}%</div>
            <div class="mt-2 text-xs text-green-600 flex items-center gap-1">
                <span>▲</span> {{ $analytics['conversionGrowth'] }}% vs prev period
            </div>
        </div>
        <div class="bg-white p-6 rounded-xl border border-gray-100 shadow-sm">
            <div class="text-xs font-bold text-gray-400 uppercase mb-1">Avg Subscription</div>
            <div class="text-2xl font-bold text-gray-900">${{ number_format($analytics['avgSubscription'], 2) }}</div>
            <div class="mt-2 text-xs text-green-600 flex items-center gap-1">
                <span>▲</span> {{ $analytics['subscriptionGrowth'] }}% vs prev period
            </div>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-8 mb-8">
        <!-- Revenue Chart Placeholder -->
        <div class="bg-white p-6 rounded-xl border border-gray-100 shadow-sm">
            <h3 class="font-bold text-gray-900 mb-6">Revenue Trend</h3>
            <div class="h-64 flex items-end gap-2 px-4">
                @foreach($revenueData as $data)
                    <div class="flex-1 bg-purple-100 hover:bg-purple-600 transition-all rounded-t-sm group relative" 
                         style="height: {{ min(100, ($data->revenue / (max(1, $analytics['totalRevenue'] / 10))) * 100) }}%">
                        <div class="absolute bottom-full left-1/2 -translate-x-1/2 mb-2 px-2 py-1 bg-gray-900 text-white text-[10px] rounded opacity-0 group-hover:opacity-100 transition whitespace-nowrap z-10">
                            ${{ number_format($data->revenue, 2) }} ({{ $data->date }})
                        </div>
                    </div>
                @endforeach
            </div>
            <div class="mt-4 flex justify-between text-[10px] text-gray-400 font-mono">
                <span>{{ $revenueData->first()->date ?? '' }}</span>
                <span>{{ $revenueData->last()->date ?? '' }}</span>
            </div>
        </div>

        <!-- Plan Distribution -->
        <div class="bg-white p-6 rounded-xl border border-gray-100 shadow-sm">
            <h3 class="font-bold text-gray-900 mb-6">Popular Plans</h3>
            <div class="space-y-4">
                @foreach($planData as $plan)
                    <div>
                        <div class="flex items-center justify-between mb-1">
                            <span class="text-sm font-medium text-gray-700">{{ $plan->plan_name }}</span>
                            <span class="text-sm font-bold text-gray-900">{{ $plan->count }} users</span>
                        </div>
                        <div class="w-full bg-gray-100 rounded-full h-2">
                            <div class="bg-purple-600 h-2 rounded-full" style="width: {{ ($plan->count / max(1, $planData->sum('count'))) * 100 }}%"></div>
                        </div>
                        <div class="mt-1 text-right text-[10px] text-gray-400 font-mono">
                            Total Revenue: ${{ number_format($plan->revenue, 2) }}
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
</div>
@endsection
