@extends('layouts.developer')

@section('title', 'Chat Monitor')

@section('content')
<div class="container mx-auto px-4 py-6">
    <div class="flex flex-col md:flex-row md:items-center justify-between gap-4 mb-6">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">Chat Monitor</h1>
            <p class="text-gray-600">Monitor and manage customer support chats across all tenants.</p>
        </div>
        @if($unreadCount > 0)
            <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-red-100 text-red-800">
                {{ $unreadCount }} unread messages
            </span>
        @endif
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Chat Sessions List -->
        <div class="lg:col-span-1">
            <div class="bg-white shadow-sm rounded-xl border border-gray-100 overflow-hidden">
                <div class="p-4 border-b border-gray-100 bg-gray-50">
                    <div class="flex items-center justify-between">
                        <h3 class="font-bold text-gray-900">Active Conversations</h3>
                        <button onclick="window.location.reload()" class="text-gray-400 hover:text-purple-600 transition">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path>
                            </svg>
                        </button>
                    </div>
                </div>
                <div class="overflow-y-auto max-h-[600px] divide-y divide-gray-50">
                    @forelse($sessions as $session)
                        <a href="{{ route('developer.chat.show', $session->id) }}" 
                           class="block p-4 hover:bg-purple-50 transition {{ request()->routeIs('developer.chat.show') && request()->route('id') == $session->id ? 'bg-purple-50 border-l-4 border-purple-600' : '' }}">
                            <div class="flex items-center">
                                <div class="flex-shrink-0">
                                    <div class="h-10 w-10 rounded-full bg-purple-100 text-purple-600 flex items-center justify-center font-bold">
                                        {{ $session->tenant ? substr($session->tenant->name ?? '?', 0, 1) : '?' }}
                                    </div>
                                </div>
                                <div class="ml-3 flex-1 min-w-0">
                                    <div class="flex items-center justify-between mb-1">
                                        <p class="text-sm font-bold text-gray-900 truncate">{{ $session->tenant->name ?? 'Unknown Tenant' }}</p>
                                        @if($session->latestMessage)
                                            <span class="text-[10px] text-gray-400">
                                                {{ $session->latestMessage->created_at->diffForHumans(null, true) }}
                                            </span>
                                        @endif
                                    </div>
                                    <p class="text-xs text-gray-500 truncate">
                                        {{ $session->latestMessage->message ?? 'No messages yet' }}
                                    </p>
                                </div>
                            </div>
                        </a>
                    @empty
                        <div class="p-8 text-center text-gray-500">
                            <p class="text-sm">No active conversations found.</p>
                        </div>
                    @endforelse
                </div>
                <div class="p-4 border-t border-gray-100 bg-gray-50">
                    {{ $sessions->links() }}
                </div>
            </div>
        </div>

        <!-- Chat Area Placeholder -->
        <div class="lg:col-span-2">
            <div class="bg-white shadow-sm rounded-xl border border-gray-100 h-full min-h-[500px] flex flex-col items-center justify-center text-center p-12">
                <div class="w-20 h-20 bg-purple-50 rounded-full flex items-center justify-center text-purple-600 text-4xl mb-4">
                    💬
                </div>
                <h3 class="text-lg font-bold text-gray-900">Select a conversation</h3>
                <p class="text-gray-500 max-w-xs mx-auto mt-2">Choose a chat from the list on the left to view the message history and respond.</p>
            </div>
        </div>
    </div>
</div>
@endsection
