<x-app-layout>
    <div class="min-h-screen w-full relative overflow-hidden">
        <!-- Modern Gradient Background with Animated Blobs -->
        <div class="fixed inset-0 -z-10">
            <div class="absolute inset-0 bg-gradient-to-br from-slate-950 via-slate-900 to-slate-950"></div>
            <!-- Animated gradient orbs -->
            <div class="absolute top-0 left-1/4 w-96 h-96 bg-blue-600 rounded-full mix-blend-multiply filter blur-3xl opacity-20 animate-pulse"></div>
            <div class="absolute bottom-0 right-1/4 w-96 h-96 bg-purple-600 rounded-full mix-blend-multiply filter blur-3xl opacity-20 animate-pulse" style="animation-delay: 2s;"></div>
            <div class="absolute top-1/2 right-0 w-96 h-96 bg-cyan-600 rounded-full mix-blend-multiply filter blur-3xl opacity-20 animate-pulse" style="animation-delay: 4s;"></div>
        </div>

        <!-- Main Content -->
        <div class="min-h-screen flex flex-col lg:flex-row">
            <!-- Left Side: Modern Branding -->
            <div class="hidden lg:flex lg:w-1/2 flex-col justify-between p-12 text-white relative overflow-hidden">
                <!-- Content -->
                <div>
                    <!-- Logo & Brand -->
                    <div class="mb-20 animate-fade-in">
                        <div class="inline-flex items-center justify-center w-14 h-14 rounded-xl bg-gradient-to-br from-blue-500 to-cyan-400 mb-6 shadow-lg shadow-blue-500/25">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8 text-white" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M9 2C7.34315 2 6 3.34315 6 5V19C6 20.6569 7.34315 22 9 22H15C16.6569 22 18 20.6569 18 19V5C18 3.34315 16.6569 2 15 2H9ZM9 4H15C15.5523 4 16 4.44772 16 5V19C16 19.5523 15.5523 20 15 20H9C8.44772 20 8 19.5523 8 19V5C8 4.44772 8.44772 4 9 4Z"/>
                            </svg>
                        </div>
                        <h1 class="text-6xl font-bold tracking-tight mb-3 bg-clip-text text-transparent bg-gradient-to-r from-blue-400 to-cyan-300">Grocery SaaS</h1>
                        <p class="text-xl text-slate-300">Enterprise Administration Portal</p>
                    </div>
                </div>

                <!-- Features -->
                <div class="space-y-6">
                    <div class="flex items-start space-x-4 group cursor-default">
                        <div class="flex-shrink-0 mt-1">
                            <div class="flex items-center justify-center h-6 w-6 rounded-lg bg-blue-500/20 text-blue-400 group-hover:bg-blue-500/30 transition-colors">
                                <svg class="h-4 w-4" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" /></svg>
                            </div>
                        </div>
                        <div>
                            <h3 class="text-base font-semibold">Secure Tenant Management</h3>
                            <p class="text-sm text-slate-400 mt-1">Enterprise-grade security with multi-tenant isolation</p>
                        </div>
                    </div>
                    <div class="flex items-start space-x-4 group cursor-default">
                        <div class="flex-shrink-0 mt-1">
                            <div class="flex items-center justify-center h-6 w-6 rounded-lg bg-cyan-500/20 text-cyan-400 group-hover:bg-cyan-500/30 transition-colors">
                                <svg class="h-4 w-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path></svg>
                            </div>
                        </div>
                        <div>
                            <h3 class="text-base font-semibold">Real-time Analytics</h3>
                            <p class="text-sm text-slate-400 mt-1">Live dashboards and instant insights</p>
                        </div>
                    </div>
                    <div class="flex items-start space-x-4 group cursor-default">
                        <div class="flex-shrink-0 mt-1">
                            <div class="flex items-center justify-center h-6 w-6 rounded-lg bg-purple-500/20 text-purple-400 group-hover:bg-purple-500/30 transition-colors">
                                <svg class="h-4 w-4" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M5 9V7a5 5 0 0110 0v2a2 2 0 012 2v5a2 2 0 01-2 2H5a2 2 0 01-2-2v-5a2 2 0 012-2zm8-2v2H7V7a3 3 0 016 0z" clip-rule="evenodd" /></svg>
                            </div>
                        </div>
                        <div>
                            <h3 class="text-base font-semibold">Advanced Security</h3>
                            <p class="text-sm text-slate-400 mt-1">Multi-factor authentication and encryption</p>
                        </div>
                    </div>
                </div>

                <!-- Footer -->
                <div class="text-xs text-slate-400">
                    <p>© {{ date('Y') }} Grocery SaaS Platform. All rights reserved.</p>
                </div>
            </div>

            <!-- Right Side: Modern Login Form -->
            <div class="w-full lg:w-1/2 flex items-center justify-center px-6 py-12 lg:py-0">
                <div class="w-full max-w-md">
                    <!-- Glass Card -->
                    <div class="relative group">
                        <!-- Gradient Border Effect -->
                        <div class="absolute inset-0 bg-gradient-to-r from-blue-600 via-purple-600 to-cyan-600 rounded-2xl opacity-0 group-hover:opacity-100 transition-opacity duration-500 blur-xl"></div>
                        <div class="absolute inset-0 bg-gradient-to-r from-blue-600 via-purple-600 to-cyan-600 rounded-2xl opacity-0 group-hover:opacity-50 transition-opacity duration-500"></div>
                        
                        <!-- Card Content -->
                        <div class="relative bg-slate-900/80 backdrop-blur-xl border border-slate-700/50 rounded-2xl p-8 shadow-2xl">
                            <!-- Header -->
                            <div class="text-center mb-8">
                                <h2 class="text-3xl font-bold text-white mb-2">Welcome Back</h2>
                                <p class="text-slate-400 text-sm">Enter your credentials to access the dashboard</p>
                            </div>

                            <!-- Success Alert -->
                            @if (session('success'))
                                <div class="mb-6 p-4 rounded-lg bg-emerald-500/10 border border-emerald-500/30 animate-bounce">
                                    <div class="flex">
                                        <div class="flex-shrink-0">
                                            <svg class="h-5 w-5 text-emerald-400" viewBox="0 0 20 20" fill="currentColor">
                                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                                            </svg>
                                        </div>
                                        <div class="ml-3">
                                            <p class="text-sm font-medium text-emerald-300">{{ session('success') }}</p>
                                        </div>
                                    </div>
                                </div>
                            @endif

                            <form method="POST" action="{{ route('login') }}" class="space-y-5">
                                @csrf

                                <!-- Email Input -->
                                <div class="group">
                                    <label for="email" class="block text-sm font-medium text-slate-300 mb-2">Admin Email</label>
                                    <div class="relative">
                                        <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                                            <svg class="h-5 w-5 text-slate-500 group-focus-within:text-blue-400 transition-colors" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                                                <path d="M2.003 5.884L10 9.882l7.997-3.998A2 2 0 0016 4H4a2 2 0 00-1.997 1.884z" />
                                                <path d="M18 8.118l-8 4-8-4V14a2 2 0 002 2h12a2 2 0 002-2V8.118z" />
                                            </svg>
                                        </div>
                                        <input id="email" type="email" name="email" :value="old('email')" required autofocus 
                                            class="w-full pl-11 pr-4 py-3 bg-slate-800/50 border border-slate-700 rounded-lg text-white placeholder-slate-500 focus:outline-none focus:border-blue-500 focus:ring-2 focus:ring-blue-500/20 transition-all duration-200" 
                                            placeholder="admin@grocery-saas.com">
                                    </div>
                                    @error('email')
                                        <p class="mt-2 text-sm text-red-400">{{ $message }}</p>
                                    @enderror
                                </div>

                                <!-- Password Input -->
                                <div class="group">
                                    <label for="password" class="block text-sm font-medium text-slate-300 mb-2">Password</label>
                                    <div class="relative">
                                        <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                                            <svg class="h-5 w-5 text-slate-500 group-focus-within:text-blue-400 transition-colors" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                                                <path fill-rule="evenodd" d="M5 9V7a5 5 0 0110 0v2a2 2 0 012 2v5a2 2 0 01-2 2H5a2 2 0 01-2-2v-5a2 2 0 012-2zm8-2v2H7V7a3 3 0 016 0z" clip-rule="evenodd" />
                                            </svg>
                                        </div>
                                        <input id="password" type="password" name="password" required autocomplete="current-password"
                                            class="w-full pl-11 pr-4 py-3 bg-slate-800/50 border border-slate-700 rounded-lg text-white placeholder-slate-500 focus:outline-none focus:border-blue-500 focus:ring-2 focus:ring-blue-500/20 transition-all duration-200"
                                            placeholder="••••••••">
                                    </div>
                                    @error('password')
                                        <p class="mt-2 text-sm text-red-400">{{ $message }}</p>
                                    @enderror
                                </div>

                                <!-- Captcha -->
                                @if(isset($security) && $security->enable_captcha)
                                    <div class="bg-slate-800/30 border border-slate-700/50 rounded-lg p-4">
                                        <label for="captcha" class="block text-sm font-medium text-slate-300 mb-3">Security Verification</label>
                                        <div class="flex items-center justify-between mb-3 gap-3">
                                            <div class="flex-1 bg-white p-2 rounded-lg overflow-hidden">{!! captcha_img('flat') !!}</div>
                                            <button type="button" class="p-2 hover:bg-slate-700/50 rounded-lg text-blue-400 hover:text-blue-300 transition-colors" 
                                                onclick="document.querySelector('.captcha-img').src = '/captcha/flat?' + Math.random(); return false;"
                                                title="Refresh">
                                                <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path></svg>
                                            </button>
                                        </div>
                                        <input id="captcha" type="text" name="captcha" required 
                                            class="w-full px-4 py-2 bg-slate-800/50 border border-slate-700 rounded-lg text-white placeholder-slate-500 focus:outline-none focus:border-blue-500 focus:ring-2 focus:ring-blue-500/20 transition-all duration-200" 
                                            placeholder="Enter verification code">
                                        @error('captcha')
                                            <p class="mt-2 text-sm text-red-400">{{ $message }}</p>
                                        @enderror
                                    </div>
                                    <script>
                                        document.addEventListener('DOMContentLoaded', function() {
                                            const img = document.querySelector('img[src^="http"]'); 
                                            if(img) img.classList.add('captcha-img');
                                            const captchaImgs = document.querySelectorAll('img');
                                            captchaImgs.forEach(i => {
                                                if(i.src.includes('captcha')) i.classList.add('captcha-img');
                                            });
                                        });
                                    </script>
                                @endif

                                <!-- Honeypot -->
                                @if(isset($security) && $security->enable_honeypot)
                                    @honeypot
                                @endif

                                <!-- Remember & Forgot -->
                                <div class="flex items-center justify-between">
                                    <label class="flex items-center cursor-pointer">
                                        <input type="checkbox" name="remember" class="w-4 h-4 bg-slate-800 border-slate-700 rounded text-blue-600 focus:ring-2 focus:ring-blue-500/20">
                                        <span class="ml-2 text-sm text-slate-400">Remember me</span>
                                    </label>
                                    <a href="#" class="text-sm text-blue-400 hover:text-blue-300 transition-colors">
                                        Forgot password?
                                    </a>
                                </div>

                                <!-- Submit Button -->
                                <button type="submit" class="w-full relative py-3 px-4 font-medium rounded-lg text-white bg-gradient-to-r from-blue-600 to-cyan-600 hover:from-blue-700 hover:to-cyan-700 focus:outline-none focus:ring-2 focus:ring-blue-500/50 shadow-lg shadow-blue-500/25 hover:shadow-xl hover:shadow-blue-500/40 transition-all duration-200 group overflow-hidden">
                                    <span class="relative flex items-center justify-center">
                                        <svg class="h-5 w-5 mr-2 group-hover:-translate-x-1 transition-transform" fill="currentColor" viewBox="0 0 20 20">
                                            <path fill-rule="evenodd" d="M5 9V7a5 5 0 0110 0v2a2 2 0 012 2v5a2 2 0 01-2 2H5a2 2 0 01-2-2v-5a2 2 0 012-2zm8-2v2H7V7a3 3 0 016 0z" clip-rule="evenodd" />
                                        </svg>
                                        Sign in to Dashboard
                                    </span>
                                </button>
                            </form>
                            
                            <!-- Developer Login Link -->
                            <div class="mt-6 text-center">
                                <a href="{{ route('developer.login') }}" 
                                   class="text-purple-400 hover:text-purple-300 text-sm font-medium transition-colors duration-200">
                                    Developer Access →
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <style>
        @keyframes fade-in {
            from {
                opacity: 0;
                transform: translateY(10px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        .animate-fade-in {
            animation: fade-in 0.6s ease-out;
        }
    </style>
</x-app-layout>