<x-admin-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                {{ __('Tenant Details') }}
            </h2>
            <a href="{{ route('admin.tenants.index') }}" class="text-sm text-indigo-600 hover:text-indigo-900">Back to List</a>
        </div>
    </x-slot>

    <div class="py-6">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <!-- Tenant Info Card -->
            <div class="bg-white shadow rounded-lg mb-6 overflow-hidden">
                <div class="px-6 py-5 border-b border-gray-200 flex justify-between items-center bg-gray-50">
                    <div>
                        <h3 class="text-lg leading-6 font-medium text-gray-900">{{ $tenant->name }}</h3>
                        <p class="mt-1 max-w-2xl text-sm text-gray-500">{{ $tenant->domain }}</p>
                    </div>
                    <span class="px-3 py-1 inline-flex text-sm leading-5 font-semibold rounded-full {{ $tenant->status === 'active' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                        {{ ucfirst($tenant->status) }}
                    </span>
                </div>
                <div class="px-6 py-5 grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Database Name</dt>
                        <dd class="mt-1 text-sm text-gray-900">{{ $tenant->database_name }}</dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Registered On</dt>
                        <dd class="mt-1 text-sm text-gray-900">{{ $tenant->created_at->format('F d, Y H:i') }}</dd>
                    </div>
                </div>
            </div>

            <!-- Subscription Card -->
            <div class="bg-white shadow rounded-lg mb-6 overflow-hidden">
                <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                    <h3 class="text-lg leading-6 font-medium text-gray-900">Subscription Status</h3>
                </div>
                <div class="px-6 py-5">
                    @if($tenant->subscription)
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Current Plan</dt>
                                <dd class="mt-1 text-lg font-semibold text-indigo-600">{{ $tenant->subscription->plan->name ?? 'Unknown Plan' }}</dd>
                            </div>
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Status</dt>
                                <dd class="mt-1 text-sm text-gray-900">{{ ucfirst($tenant->subscription->status) }}</dd>
                            </div>
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Renews / Ends</dt>
                                <dd class="mt-1 text-sm text-gray-900">{{ $tenant->subscription->ends_at ? $tenant->subscription->ends_at->format('M d, Y') : 'Never' }}</dd>
                            </div>
                        </div>
                    @else
                        <p class="text-gray-500 italic">No active subscription found.</p>
                        <button class="mt-3 text-indigo-600 hover:text-indigo-900 text-sm font-medium">Assign Plan</button>
                    @endif
                </div>
            </div>

            <!-- Users Card -->
            <div class="bg-white shadow rounded-lg overflow-hidden">
                <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                    <h3 class="text-lg leading-6 font-medium text-gray-900">Users</h3>
                </div>
                <ul class="divide-y divide-gray-200">
                    @if($tenant->users && $tenant->users->count() > 0)
                        @foreach($tenant->users as $user)
                        <li class="px-6 py-4 flex items-center justify-between">
                            <div>
                                <p class="text-sm font-medium text-gray-900">{{ $user->name }}</p>
                                <p class="text-sm text-gray-500">{{ $user->email }}</p>
                            </div>
                            <div class="flex items-center">
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-800 mr-4">
                                    {{ $user->getRoleNames()->first() ?? 'No Role' }}
                                </span>
                                <a href="#" class="text-gray-400 hover:text-gray-600">Edit</a>
                            </div>
                        </li>
                        @endforeach
                    @else
                        <li class="px-6 py-4 text-center text-gray-500 italic">No users found.</li>
                    @endif
                </ul>
            </div>
        </div>
    </div>
</x-admin-layout>
