<x-admin-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Create Tenant Category') }}
        </h2>
    </x-slot>

    <div class="py-6">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <form action="{{ route('admin.tenant-categories.store') }}" method="POST">
                        @csrf
                        
                        <div class="mb-4">
                            <label for="name" class="block text-sm font-medium text-gray-700">Category Name</label>
                            <input type="text" name="name" id="name" value="{{ old('name') }}" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring-indigo-500" required>
                            @error('name')
                                <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="mb-4">
                            <label for="description" class="block text-sm font-medium text-gray-700">Description</label>
                            <textarea name="description" id="description" rows="3" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring-indigo-500">{{ old('description') }}</textarea>
                            @error('description')
                                <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="mb-4">
                            <label for="default_categories" class="block text-sm font-medium text-gray-700">Default Product Categories (Comma Separated)</label>
                            <input type="text" name="default_categories" id="default_categories" value="{{ old('default_categories') }}" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring-indigo-500" placeholder="e.g. Beverages, Food Items, Dairy Products">
                            <p class="mt-1 text-xs text-gray-500 italic">These categories will be automatically created in the tenant's database when they subscribe to a plan in this category.</p>
                            @error('default_categories')
                                <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="mb-6 p-4 bg-gray-50 rounded-lg border border-gray-200">
                            <h3 class="text-md font-semibold text-gray-800 mb-4 flex items-center">
                                <span class="mr-2">🛠️</span> Technical Configuration (Application Design)
                            </h3>
                            
                        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                            <!-- 1. Centralized Management & Reporting -->
                            <div class="space-y-4">
                                <h4 class="text-sm font-bold text-indigo-700 border-b pb-1">1. Management & Reporting</h4>
                                <div class="space-y-2">
                                    <label class="flex items-center">
                                        <input type="checkbox" name="settings[show_dashboard]" value="1" {{ old('settings.show_dashboard', '1') == '1' ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm">
                                        <span class="ml-2 text-sm text-gray-600">Real-time Dashboard</span>
                                    </label>
                                    <label class="flex items-center">
                                        <input type="checkbox" name="settings[enable_recipe_management]" value="1" {{ old('settings.enable_recipe_management') == '1' ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm">
                                        <span class="ml-2 text-sm text-gray-600">Menu & Recipe Management</span>
                                    </label>
                                    <label class="flex items-center">
                                        <input type="checkbox" name="settings[enable_multi_location]" value="1" {{ old('settings.enable_multi_location') == '1' ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm">
                                        <span class="ml-2 text-sm text-gray-600">Multi-location Control</span>
                                    </label>
                                    <label class="flex items-center">
                                        <input type="checkbox" name="settings[enable_performance_analytics]" value="1" {{ old('settings.enable_performance_analytics') == '1' ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm">
                                        <span class="ml-2 text-sm text-gray-600">Performance Analytics</span>
                                    </label>
                                </div>
                                
                                <div class="mt-2">
                                    <label for="settings_pos_type" class="block text-xs font-medium text-gray-500 mb-1">POS Interface Style</label>
                                    <select name="settings[pos_type]" id="settings_pos_type" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring-indigo-500 text-xs">
                                        <option value="standard" {{ old('settings.pos_type') == 'standard' ? 'selected' : '' }}>Standard POS (Grocery/Retail)</option>
                                        <option value="restaurant" {{ old('settings.pos_type') == 'restaurant' ? 'selected' : '' }}>Restaurant POS (Table/Kitchen)</option>
                                        <option value="service" {{ old('settings.pos_type') == 'service' ? 'selected' : '' }}>Service Based (Booking)</option>
                                        <option value="none" {{ old('settings.pos_type') == 'none' ? 'selected' : '' }}>No POS (Direct Invoicing)</option>
                                    </select>
                                </div>
                            </div>

                            <!-- 2. Operational Efficiency Tools -->
                            <div class="space-y-4">
                                <h4 class="text-sm font-bold text-indigo-700 border-b pb-1">2. Operational Efficiency</h4>
                                <div class="space-y-2">
                                    <label class="flex items-center">
                                        <input type="checkbox" name="settings[enable_stock_management]" value="1" {{ old('settings.enable_stock_management', '1') == '1' ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm">
                                        <span class="ml-2 text-sm text-gray-600">Inventory Tracking</span>
                                    </label>
                                    <label class="flex items-center">
                                        <input type="checkbox" name="settings[enable_table_management]" value="1" {{ old('settings.enable_table_management') == '1' ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm">
                                        <span class="ml-2 text-sm text-gray-600">Table & Floor Mapping</span>
                                    </label>
                                    <label class="flex items-center">
                                        <input type="checkbox" name="settings[enable_reservation_system]" value="1" {{ old('settings.enable_reservation_system') == '1' ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm">
                                        <span class="ml-2 text-sm text-gray-600">Reservation Management</span>
                                    </label>
                                    <label class="flex items-center">
                                        <input type="checkbox" name="settings[enable_kds]" value="1" {{ old('settings.enable_kds') == '1' ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm">
                                        <span class="ml-2 text-sm text-gray-600">Kitchen Display System (KDS)</span>
                                    </label>
                                    <label class="flex items-center">
                                        <input type="checkbox" name="settings[enable_online_ordering]" value="1" {{ old('settings.enable_online_ordering') == '1' ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm">
                                        <span class="ml-2 text-sm text-gray-600">Online Ordering Integration</span>
                                    </label>
                                    <label class="flex items-center">
                                        <input type="checkbox" name="settings[enable_class_scheduling]" value="1" {{ old('settings.enable_class_scheduling') == '1' ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm">
                                        <span class="ml-2 text-sm text-gray-600">Class Scheduling & Booking</span>
                                    </label>
                                    <label class="flex items-center">
                                        <input type="checkbox" name="settings[enable_capacity_monitoring]" value="1" {{ old('settings.enable_capacity_monitoring') == '1' ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm">
                                        <span class="ml-2 text-sm text-gray-600">Real-time Capacity Monitoring</span>
                                    </label>
                                </div>
                            </div>

                            <!-- 3. Employee & Staff Management -->
                            <div class="space-y-4">
                                <h4 class="text-sm font-bold text-indigo-700 border-b pb-1">3. Employee & Staff Management</h4>
                                <div class="space-y-2">
                                    <label class="flex items-center">
                                        <input type="checkbox" name="settings[enable_rbac]" value="1" {{ old('settings.enable_rbac', '1') == '1' ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm">
                                        <span class="ml-2 text-sm text-gray-600">Role-Based Access Control</span>
                                    </label>
                                    <label class="flex items-center">
                                        <input type="checkbox" name="settings[enable_time_attendance]" value="1" {{ old('settings.enable_time_attendance') == '1' ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm">
                                        <span class="ml-2 text-sm text-gray-600">Time & Attendance Tracking</span>
                                    </label>
                                    <label class="flex items-center">
                                        <input type="checkbox" name="settings[enable_staff_performance]" value="1" {{ old('settings.enable_staff_performance') == '1' ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm">
                                        <span class="ml-2 text-sm text-gray-600">Staff Performance Monitoring</span>
                                    </label>
                                    <label class="flex items-center">
                                        <input type="checkbox" name="settings[enable_trainer_management]" value="1" {{ old('settings.enable_trainer_management') == '1' ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm">
                                        <span class="ml-2 text-sm text-gray-600">Trainer & Instructor Scheduling</span>
                                    </label>
                                </div>
                            </div>

                            <!-- 4. Product & Inventory Settings -->
                            <div class="space-y-4">
                                <h4 class="text-sm font-bold text-indigo-700 border-b pb-1">4. Product & Inventory Settings</h4>
                                <div class="space-y-2">
                                    <label class="flex items-center">
                                        <input type="checkbox" name="settings[enable_subcategories]" value="1" {{ old('settings.enable_subcategories') == '1' ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm">
                                        <span class="ml-2 text-sm text-gray-600">Sub-categories</span>
                                    </label>
                                    <label class="flex items-center">
                                        <input type="checkbox" name="settings[enable_variants]" value="1" {{ old('settings.enable_variants', '1') == '1' ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm">
                                        <span class="ml-2 text-sm text-gray-600">Product Variants</span>
                                    </label>
                                    <label class="flex items-center">
                                        <input type="checkbox" name="settings[enable_batches]" value="1" {{ old('settings.enable_batches') == '1' ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm">
                                        <span class="ml-2 text-sm text-gray-600">Batch/Expiry Management</span>
                                    </label>
                                    <label class="flex items-center">
                                        <input type="checkbox" name="settings[enable_warehouse]" value="1" {{ old('settings.enable_warehouse') == '1' ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm">
                                        <span class="ml-2 text-sm text-gray-600">Warehouse Management</span>
                                    </label>
                                    <label class="flex items-center">
                                        <input type="checkbox" name="settings[enable_equipment_maintenance]" value="1" {{ old('settings.enable_equipment_maintenance') == '1' ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm">
                                        <span class="ml-2 text-sm text-gray-600">Equipment Maintenance Tracking</span>
                                    </label>
                                    
                                    <div class="mt-2">
                                        <label for="settings_stock_method" class="block text-xs font-medium text-gray-500 mb-1">Stock Method</label>
                                        <select name="settings[stock_method]" id="settings_stock_method" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring-indigo-500 text-xs">
                                            <option value="fifo" {{ old('settings.stock_method') == 'fifo' ? 'selected' : '' }}>FIFO</option>
                                            <option value="lifo" {{ old('settings.stock_method') == 'lifo' ? 'selected' : '' }}>LIFO</option>
                                            <option value="avco" {{ old('settings.stock_method') == 'avco' ? 'selected' : '' }}>AVCO (Average)</option>
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <!-- 5. Security & CRM -->
                            <div class="space-y-4">
                                <h4 class="text-sm font-bold text-indigo-700 border-b pb-1">5. Security & CRM</h4>
                                <div class="space-y-2">
                                    <label class="flex items-center">
                                        <input type="checkbox" name="settings[enable_offline_mode]" value="1" {{ old('settings.enable_offline_mode', '1') == '1' ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm">
                                        <span class="ml-2 text-sm text-gray-600">Offline Mode Support</span>
                                    </label>
                                    <label class="flex items-center">
                                        <input type="checkbox" name="settings[enable_loyalty_program]" value="1" {{ old('settings.enable_loyalty_program') == '1' ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm">
                                        <span class="ml-2 text-sm text-gray-600">Loyalty & Rewards Program</span>
                                    </label>
                                    <label class="flex items-center">
                                        <input type="checkbox" name="settings[enable_customer_profiles]" value="1" {{ old('settings.enable_customer_profiles', '1') == '1' ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm">
                                        <span class="ml-2 text-sm text-gray-600">Customer Profiles (CRM)</span>
                                    </label>
                                    <label class="flex items-center">
                                        <input type="checkbox" name="settings[enable_data_encryption]" value="1" {{ old('settings.enable_data_encryption', '1') == '1' ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm">
                                        <span class="ml-2 text-sm text-gray-600">Data Security (Encryption)</span>
                                    </label>
                                </div>
                            </div>

                            <!-- 6. Modules & Integrations -->
                            <div class="space-y-4">
                                <h4 class="text-sm font-bold text-indigo-700 border-b pb-1">6. Modules & Integrations</h4>
                                <div class="space-y-2">
                                    <label class="flex items-center">
                                        <input type="checkbox" name="settings[enable_suppliers]" value="1" {{ old('settings.enable_suppliers', '1') == '1' ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm">
                                        <span class="ml-2 text-sm text-gray-600">Supplier Management</span>
                                    </label>
                                    <label class="flex items-center">
                                        <input type="checkbox" name="settings[enable_advanced_reports]" value="1" {{ old('settings.enable_advanced_reports', '1') == '1' ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm">
                                        <span class="ml-2 text-sm text-gray-600">Advanced Analytics/Reports</span>
                                    </label>
                                    <label class="flex items-center">
                                        <input type="checkbox" name="settings[enable_locations]" value="1" {{ old('settings.enable_locations') == '1' ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm">
                                        <span class="ml-2 text-sm text-gray-600">Multiple Storefronts</span>
                                    </label>
                                    <label class="flex items-center">
                                        <input type="checkbox" name="settings[enable_api_access]" value="1" {{ old('settings.enable_api_access') == '1' ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm">
                                        <span class="ml-2 text-sm text-gray-600">API Access (REST/Webhooks)</span>
                                    </label>
                                    <label class="flex items-center">
                                        <input type="checkbox" name="settings[enable_fitness_tracking]" value="1" {{ old('settings.enable_fitness_tracking') == '1' ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm">
                                        <span class="ml-2 text-sm text-gray-600">Member Fitness Tracking Portal</span>
                                    </label>
                                </div>
                            </div>

                            <!-- 7. Membership & Access Control -->
                            <div class="space-y-4">
                                <h4 class="text-sm font-bold text-indigo-700 border-b pb-1">7. Membership & Access Control</h4>
                                <div class="space-y-2">
                                    <label class="flex items-center">
                                        <input type="checkbox" name="settings[enable_membership_management]" value="1" {{ old('settings.enable_membership_management') == '1' ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm">
                                        <span class="ml-2 text-sm text-gray-600">Member Lifecycle Management</span>
                                    </label>
                                    <label class="flex items-center">
                                        <input type="checkbox" name="settings[enable_digital_waivers]" value="1" {{ old('settings.enable_digital_waivers') == '1' ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm">
                                        <span class="ml-2 text-sm text-gray-600">Digital Waivers & Contracts</span>
                                    </label>
                                    <label class="flex items-center">
                                        <input type="checkbox" name="settings[enable_access_control]" value="1" {{ old('settings.enable_access_control') == '1' ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm">
                                        <span class="ml-2 text-sm text-gray-600">Access Control (RFID/Biometric)</span>
                                    </label>
                                    <label class="flex items-center">
                                         <input type="checkbox" name="settings[enable_24_7_access]" value="1" {{ old('settings.enable_24_7_access') == '1' ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm">
                                         <span class="ml-2 text-sm text-gray-600">24/7 Unstaffed Access Integration</span>
                                     </label>
                                 </div>
                             </div>

                             <!-- 8. Agriculture & Farm Management -->
                             <div class="space-y-4">
                                 <h4 class="text-sm font-bold text-indigo-700 border-b pb-1">8. Agriculture & Farm Management</h4>
                                 <div class="space-y-2">
                                     <label class="flex items-center">
                                         <input type="checkbox" name="settings[enable_smart_farming_iot]" value="1" {{ old('settings.enable_smart_farming_iot') == '1' ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm">
                                         <span class="ml-2 text-sm text-gray-600">Smart Farming & IoT (Sensors/Drones)</span>
                                     </label>
                                     <label class="flex items-center">
                                         <input type="checkbox" name="settings[enable_fmis]" value="1" {{ old('settings.enable_fmis') == '1' ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm">
                                         <span class="ml-2 text-sm text-gray-600">Farm Management Info System (FMIS)</span>
                                     </label>
                                     <label class="flex items-center">
                                         <input type="checkbox" name="settings[enable_traceability]" value="1" {{ old('settings.enable_traceability') == '1' ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm">
                                         <span class="ml-2 text-sm text-gray-600">Traceability (Planting to Delivery)</span>
                                     </label>
                                     <label class="flex items-center">
                                         <input type="checkbox" name="settings[enable_ifs]" value="1" {{ old('settings.enable_ifs') == '1' ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm">
                                         <span class="ml-2 text-sm text-gray-600">Integrated Farming Systems (IFS)</span>
                                     </label>
                                     <label class="flex items-center">
                                          <input type="checkbox" name="settings[enable_resource_recycling]" value="1" {{ old('settings.enable_resource_recycling') == '1' ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm">
                                          <span class="ml-2 text-sm text-gray-600">Waste/Resource Recycling Management</span>
                                      </label>
                                  </div>
                              </div>

                            <!-- 9. Electronic Business (E-commerce) Compliance -->
                            <div class="space-y-4">
                                <h4 class="text-sm font-bold text-indigo-700 border-b pb-1">9. E-commerce & BD Compliance</h4>
                                <div class="space-y-2">
                                    <label class="flex items-center">
                                        <input type="checkbox" name="settings[require_dbid]" value="1" {{ old('settings.require_dbid') == '1' ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm">
                                        <span class="ml-2 text-sm text-gray-600">DBID (Digital Business ID) Support</span>
                                    </label>
                                    <label class="flex items-center">
                                        <input type="checkbox" name="settings[require_trade_license]" value="1" {{ old('settings.require_trade_license') == '1' ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm">
                                        <span class="ml-2 text-sm text-gray-600">Trade License & e-TIN Verification</span>
                                    </label>
                                    <label class="flex items-center">
                                        <input type="checkbox" name="settings[require_bin_vat]" value="1" {{ old('settings.require_bin_vat') == '1' ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm">
                                        <span class="ml-2 text-sm text-gray-600">BIN (VAT Registration) Logic</span>
                                    </label>
                                    <label class="flex items-center">
                                        <input type="checkbox" name="settings[enable_escrow_payment]" value="1" {{ old('settings.enable_escrow_payment') == '1' ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm">
                                        <span class="ml-2 text-sm text-gray-600">Escrow Payment System (MoC Policy)</span>
                                    </label>
                                    <label class="flex items-center">
                                        <input type="checkbox" name="settings[enable_delivery_compliance]" value="1" {{ old('settings.enable_delivery_compliance') == '1' ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm">
                                        <span class="ml-2 text-sm text-gray-600">5-10 Day Delivery Guidelines</span>
                                    </label>
                                    <label class="flex items-center">
                                        <input type="checkbox" name="settings[enable_return_refund_policy]" value="1" {{ old('settings.enable_return_refund_policy', '1') == '1' ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm">
                                        <span class="ml-2 text-sm text-gray-600">Auto Return/Refund (Consumer Act 2009)</span>
                                    </label>
                                    <label class="flex items-center">
                                        <input type="checkbox" name="settings[mandatory_info_display]" value="1" {{ old('settings.mandatory_info_display', '1') == '1' ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm">
                                        <span class="ml-2 text-sm text-gray-600">Mandatory BIN/DBID Display</span>
                                    </label>
                                    <label class="flex items-center">
                                        <input type="checkbox" name="settings[enable_bangla_terms]" value="1" {{ old('settings.enable_bangla_terms', '1') == '1' ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm">
                                        <span class="ml-2 text-sm text-gray-600">Bengali T&C Compliance</span>
                                    </label>
                                </div>
                            </div>
                          </div>
                          </div>

                            <hr class="my-6 border-gray-200">

                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <!-- User Roles -->
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">Required User Roles</label>
                                    <div class="grid grid-cols-2 gap-2">
                                        @php $roles = ['Admin', 'Manager', 'Cashier', 'Store Keeper', 'Accountant', 'Kitchen Staff', 'Waiter', 'Delivery Boy', 'Courier/Logistics', 'Customer Support', 'Trainer', 'Instructor', 'Member', 'Customer']; @endphp
                                        @foreach($roles as $role)
                                        <label class="flex items-center">
                                            <input type="checkbox" name="settings[roles][]" value="{{ $role }}" {{ is_array(old('settings.roles')) && in_array($role, old('settings.roles')) ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm">
                                            <span class="ml-2 text-sm text-gray-600">{{ $role }}</span>
                                        </label>
                                        @endforeach
                                    </div>
                                </div>

                                <!-- Reports -->
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">Report Types</label>
                                    <div class="grid grid-cols-2 gap-2">
                                        @php $reports = ['Sales', 'Purchase', 'Stock', 'Profit/Loss', 'Customer Ledger', 'Supplier Ledger', 'Tax Report', 'VAT/BIN Report', 'Attendance', 'Membership Growth', 'Retention/Churn', 'Class Attendance', 'Trainer Commissions', 'Delivery Performance']; @endphp
                                        @foreach($reports as $report)
                                        <label class="flex items-center">
                                            <input type="checkbox" name="settings[reports][]" value="{{ $report }}" {{ is_array(old('settings.reports')) && in_array($report, old('settings.reports')) ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm">
                                            <span class="ml-2 text-sm text-gray-600">{{ $report }}</span>
                                        </label>
                                        @endforeach
                                    </div>
                                </div>

                                <!-- Integrations -->
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">System & API Integrations</label>
                                    <div class="space-y-2">
                                        <label class="flex items-center">
                                            <input type="checkbox" name="settings[integrations][]" value="SMS" {{ is_array(old('settings.integrations')) && in_array('SMS', old('settings.integrations')) ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm">
                                            <span class="ml-2 text-sm text-gray-600">SMS Notifications</span>
                                        </label>
                                        <label class="flex items-center">
                                            <input type="checkbox" name="settings[integrations][]" value="WhatsApp" {{ is_array(old('settings.integrations')) && in_array('WhatsApp', old('settings.integrations')) ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm">
                                            <span class="ml-2 text-sm text-gray-600">WhatsApp Business</span>
                                        </label>
                                        <label class="flex items-center">
                                            <input type="checkbox" name="settings[integrations][]" value="Payment" {{ is_array(old('settings.integrations')) && in_array('Payment', old('settings.integrations')) ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm">
                                            <span class="ml-2 text-sm text-gray-600">Online Payment Gateways</span>
                                        </label>
                                        <label class="flex items-center">
                                            <input type="checkbox" name="settings[integrations][]" value="API" {{ is_array(old('settings.integrations')) && in_array('API', old('settings.integrations')) ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm">
                                            <span class="ml-2 text-sm text-gray-600">External API (REST/JSON)</span>
                                        </label>
                                    </div>
                                </div>

                                <!-- AI Agent Prompt -->
                                <div>
                                    <div class="flex justify-between items-center mb-2">
                                        <label for="settings_ai_prompt" class="block text-sm font-medium text-gray-700">AI Agent Instructions (for App Generation)</label>
                                        <div class="flex space-x-2">
                                            <button type="button" onclick="generateAiPrompt()" class="text-xs bg-indigo-100 text-indigo-700 px-2 py-1 rounded hover:bg-indigo-200 transition">
                                                ✨ Generate Basic
                                            </button>
                                            <button type="button" id="btn_refine_ai" onclick="refineWithAi()" class="text-xs bg-purple-100 text-purple-700 px-2 py-1 rounded hover:bg-purple-200 transition">
                                                🤖 Refine with ChatGPT
                                            </button>
                                        </div>
                                    </div>
                                    <textarea name="settings[ai_prompt]" id="settings_ai_prompt" rows="6" placeholder="Specific instructions for the AI Agent to build this application..." class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring-indigo-500 text-sm">{{ old('settings.ai_prompt') }}</textarea>
                                </div>
                            </div>
                        </div>

                        <div class="mb-4">
                            <label class="inline-flex items-center">
                                <input type="checkbox" name="is_active" value="1" {{ old('is_active', '1') == '1' ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                <span class="ml-2 text-sm text-gray-600">Active</span>
                            </label>
                        </div>

                        <div class="flex items-center justify-end mt-4">
                            <a href="{{ route('admin.tenant-categories.index') }}" class="text-gray-600 hover:text-gray-900 mr-4">Cancel</a>
                            <button type="submit" class="bg-indigo-600 hover:bg-indigo-700 text-white font-bold py-2 px-4 rounded">
                                Create Category
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- AI Result Modal -->
    <div x-data="{ open: false, title: '', message: '', type: 'info' }"
         @ai-modal.window="open = true; title = $event.detail.title; message = $event.detail.message; type = $event.detail.type || 'info'">
        <template x-teleport="body">
            <div x-show="open" 
                 x-cloak
                 @keydown.escape.window="open = false"
                 class="fixed inset-0 z-[9999] overflow-y-auto" 
                 aria-labelledby="modal-title" role="dialog" aria-modal="true">
                
                <div class="flex items-center justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
                    <!-- Background overlay -->
                    <div x-show="open" 
                         x-transition:enter="ease-out duration-300" 
                         x-transition:enter-start="opacity-0" 
                         x-transition:enter-end="opacity-100" 
                         x-transition:leave="ease-in duration-200" 
                         x-transition:leave-start="opacity-100" 
                         x-transition:leave-end="opacity-0" 
                         class="fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity" 
                         @click="open = false"
                         aria-hidden="true"></div>

                    <!-- This element is to trick the browser into centering the modal contents. -->
                    <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>

                    <!-- Modal panel -->
                    <div x-show="open" 
                         x-transition:enter="ease-out duration-300" 
                         x-transition:enter-start="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95" 
                         x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100" 
                         x-transition:leave="ease-in duration-200" 
                         x-transition:leave-start="opacity-100 translate-y-0 sm:scale-100" 
                         x-transition:leave-end="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95" 
                         class="inline-block align-bottom bg-white rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg sm:w-full">
                        <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                            <div class="sm:flex sm:items-start">
                                <div :class="type === 'error' ? 'bg-red-100' : 'bg-indigo-100'" class="mx-auto flex-shrink-0 flex items-center justify-center h-12 w-12 rounded-full sm:mx-0 sm:h-10 sm:w-10">
                                    <template x-if="type === 'error'">
                                        <span class="text-red-600 text-xl">⚠️</span>
                                    </template>
                                    <template x-if="type === 'info'">
                                        <span class="text-indigo-600 text-xl">✨</span>
                                    </template>
                                </div>
                                <div class="mt-3 text-center sm:mt-0 sm:ml-4 sm:text-left">
                                    <h3 class="text-lg leading-6 font-medium text-gray-900" id="modal-title" x-text="title"></h3>
                                    <div class="mt-2">
                                        <p class="text-sm text-gray-500 whitespace-pre-wrap" x-text="message"></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="bg-gray-50 px-4 py-3 sm:px-6 sm:flex sm:flex-row-reverse">
                            <button @click="open = false" type="button" :class="type === 'error' ? 'bg-red-600 hover:bg-red-700 focus:ring-red-500' : 'bg-indigo-600 hover:bg-indigo-700 focus:ring-indigo-500'" class="w-full inline-flex justify-center rounded-md border border-transparent shadow-sm px-4 py-2 text-base font-medium text-white focus:outline-none focus:ring-2 focus:ring-offset-2 sm:ml-3 sm:w-auto sm:text-sm">
                                Close
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </template>
    </div>

    @push('scripts')
    <script>
        function generateAiPrompt() {
            const categoryName = document.getElementById('name').value || '[Category Name]';
            const description = document.getElementById('description').value || '';
            const settings = {};
            
            // Get all checkboxes
            document.querySelectorAll('input[type="checkbox"][name^="settings"]').forEach(cb => {
                const name = cb.name.match(/\[(.*?)\]/)[1];
                if (cb.checked) {
                    if (name === 'roles' || name === 'reports' || name === 'integrations') {
                        if (!settings[name]) settings[name] = [];
                        settings[name].push(cb.value);
                    } else {
                        settings[name] = true;
                    }
                }
            });

            // Get all selects
            document.querySelectorAll('select[name^="settings"]').forEach(select => {
                const name = select.name.match(/\[(.*?)\]/)[1];
                settings[name] = select.value;
            });

            let prompt = `Act as an Expert Full-Stack Developer and SaaS Architect. 
Build a comprehensive multi-tenant Laravel application for a "${categoryName}" business category.

CORE ARCHITECTURE:
- Business Logic: ${description}
- UI/UX Style: Modern, responsive, and clean dashboard.
- POS Interface: ${settings.pos_type || 'standard'} mode.
- Inventory Logic: ${settings.stock_method || 'fifo'} method.

REQUIRED MODULES & FEATURES:
${settings.show_dashboard ? '- Real-time Executive Dashboard' : ''}
${settings.enable_stock_management ? '- Advanced Inventory Tracking with Low Stock Alerts' : ''}
${settings.enable_recipe_management ? '- Menu & Recipe Engineering (Costing/Wastage)' : ''}
${settings.enable_table_management ? '- Interactive Table & Floor Mapping' : ''}
${settings.enable_kds ? '- Kitchen Display System (KDS) for Order Orchestration' : ''}
${settings.enable_membership_management ? '- Member Lifecycle & Subscription Management' : ''}
${settings.enable_access_control ? '- Access Control Integration (RFID/Biometric)' : ''}
${settings.enable_smart_farming_iot ? '- Smart Farming IoT Hub (Sensors/Drones Integration)' : ''}
${settings.enable_fmis ? '- Farm Management Information System (FMIS)' : ''}
${settings.enable_api_access ? '- API First Architecture (REST/Webhooks)' : ''}
${settings.require_dbid ? '- Mandatory DBID & Legal Compliance for Bangladesh' : ''}
${settings.enable_escrow_payment ? '- Escrow Payment System for Consumer Protection' : ''}
${settings.enable_rbac ? '- Advanced Role-Based Access Control (RBAC)' : ''}

USER ROLES TO IMPLEMENT:
${(settings.roles || []).join(', ')}

REPORTS TO GENERATE:
${(settings.reports || []).join(', ')}

EXTERNAL INTEGRATIONS:
${(settings.integrations || []).join(', ')}

DEVELOPMENT GUIDELINES:
1. Generate specific Database Migrations, Models, and Controllers for these modules.
2. Create dynamic Menus and Sub-menus in the Sidebar based on these active modules.
3. Implement specialized Forms (e.g., Recipe form for Food, Membership form for Gym, IoT data form for Agri).
4. Ensure all logic is multi-tenant aware using the current tenant context.
5. If E-commerce is enabled, implement 5-10 day delivery tracking and Bengali T&C compliance.`;

            document.getElementById('settings_ai_prompt').value = prompt.trim();
        }

        async function refineWithAi() {
            const currentPrompt = document.getElementById('settings_ai_prompt').value;
            const btn = document.getElementById('btn_refine_ai');
            const originalText = btn.innerHTML;

            if (!currentPrompt) {
                generateAiPrompt();
            }

            btn.disabled = true;
            btn.innerHTML = '⌛ Processing...';

            try {
                const response = await fetch('{{ route("admin.ai.generate-prompt") }}', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    },
                    body: JSON.stringify({
                        context: document.getElementById('settings_ai_prompt').value
                    })
                });

                const data = await response.json();

                if (data.success) {
                    document.getElementById('settings_ai_prompt').value = data.prompt;
                    window.dispatchEvent(new CustomEvent('ai-modal', { 
                        detail: { 
                            title: 'Refinement Successful!', 
                            message: 'AI has successfully refined your prompt. You can see the updated text in the box below.', 
                            type: 'info' 
                        } 
                    }));
                } else {
                    window.dispatchEvent(new CustomEvent('ai-modal', { 
                        detail: { 
                            title: 'AI Error', 
                            message: data.message || 'Failed to refine prompt', 
                            type: 'error' 
                        } 
                    }));
                }
            } catch (error) {
                console.error('Error:', error);
                window.dispatchEvent(new CustomEvent('ai-modal', { 
                    detail: { 
                        title: 'Connection Error', 
                        message: 'An error occurred while connecting to the AI service. Please check your internet or API key.', 
                        type: 'error' 
                    } 
                }));
            } finally {
                btn.disabled = false;
                btn.innerHTML = originalText;
            }
        }
    </script>
    @endpush
</x-admin-layout>