<x-admin-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Edit Subscription') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 bg-white border-b border-gray-200">
                    <form method="POST" action="{{ route('admin.subscriptions.update', $subscription->id) }}">
                        @csrf
                        @method('PUT')

                        <div class="mb-6">
                            <p class="text-sm text-gray-600">Editing Subscription for Tenant: <strong>{{ $subscription->tenant->name }}</strong></p>
                        </div>

                        <!-- Plan -->
                        <div class="mb-4">
                            <label for="plan_id" class="block text-sm font-medium text-gray-700">Plan</label>
                            <select name="plan_id" id="plan_id" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                                @foreach($plans as $plan)
                                    <option value="{{ $plan->id }}" {{ $subscription->plan_id == $plan->id ? 'selected' : '' }}>
                                        {{ $plan->name }} (${{ number_format($plan->price, 2) }})
                                    </option>
                                @endforeach
                            </select>
                            @error('plan_id')
                                <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Status -->
                        <div class="mb-4">
                            <label for="status" class="block text-sm font-medium text-gray-700">Status</label>
                            <select name="status" id="status" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                                <option value="active" {{ $subscription->status === 'active' ? 'selected' : '' }}>Active</option>
                                <option value="trialing" {{ $subscription->status === 'trialing' ? 'selected' : '' }}>Trialing</option>
                                <option value="past_due" {{ $subscription->status === 'past_due' ? 'selected' : '' }}>Past Due</option>
                                <option value="cancelled" {{ $subscription->status === 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                            </select>
                            @error('status')
                                <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Ends At -->
                        <div class="mb-4">
                            <label for="ends_at" class="block text-sm font-medium text-gray-700">Ends At (Leave blank for indefinite/auto-renew)</label>
                            <input type="date" name="ends_at" id="ends_at" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50" 
                                value="{{ $subscription->ends_at ? $subscription->ends_at->format('Y-m-d') : '' }}">
                            @error('ends_at')
                                <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="flex items-center justify-end mt-4">
                            <a href="{{ route('admin.subscriptions.index') }}" class="text-gray-600 hover:text-gray-900 mr-4">Cancel</a>
                            <button type="submit" class="bg-indigo-600 hover:bg-indigo-700 text-white font-bold py-2 px-4 rounded">
                                Update Subscription
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-admin-layout>
