<x-admin-layout>
    <div class="py-12" x-data="{ activeTab: 'general' }">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 bg-white border-b border-gray-200">
                    <div class="flex justify-between items-center mb-6">
                        <h2 class="text-2xl font-bold text-gray-800">
                            ⚙️ Site Settings
                        </h2>
                    </div>

                    @if (session('success'))
                        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-4" role="alert">
                            <span class="block sm:inline">{{ session('success') }}</span>
                        </div>
                    @endif

                    <!-- Tabs -->
                    <div class="mb-6 border-b border-gray-200">
                        <nav class="-mb-px flex space-x-8" aria-label="Tabs">
                            <button @click="activeTab = 'general'" :class="{ 'border-indigo-500 text-indigo-600': activeTab === 'general', 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300': activeTab !== 'general' }" class="whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm">
                                General & Branding
                            </button>
                            <button @click="activeTab = 'integrations'" :class="{ 'border-indigo-500 text-indigo-600': activeTab === 'integrations', 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300': activeTab !== 'integrations' }" class="whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm">
                                Integrations (Mail/SMS/Payment)
                            </button>
                            <button @click="activeTab = 'advanced'" :class="{ 'border-indigo-500 text-indigo-600': activeTab === 'advanced', 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300': activeTab !== 'advanced' }" class="whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm">
                                Advanced & Optimization
                            </button>
                            <button @click="activeTab = 'ai_settings'" :class="{ 'border-indigo-500 text-indigo-600': activeTab === 'ai_settings', 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300': activeTab !== 'ai_settings' }" class="whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm">
                                🤖 AI Configuration
                            </button>
                            <button @click="activeTab = 'api_keys'" :class="{ 'border-indigo-500 text-indigo-600': activeTab === 'api_keys', 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300': activeTab !== 'api_keys' }" class="whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm">
                                🔑 External API Keys
                            </button>
                        </nav>
                    </div>

                    <form action="{{ route('admin.settings.update') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        @method('PUT')

                        <!-- General Tab -->
                        <div x-show="activeTab === 'general'" class="space-y-6">
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div>
                                    <label class="block font-medium text-sm text-gray-700">Application Name</label>
                                    <input type="text" name="app_name" value="{{ $settings['app_name'] ?? config('app.name') }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                                </div>
                                <div>
                                    <label class="block font-medium text-sm text-gray-700">Timezone</label>
                                    <select name="app_timezone" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                                        <option value="UTC" {{ ($settings['app_timezone'] ?? config('app.timezone')) == 'UTC' ? 'selected' : '' }}>UTC</option>
                                        <option value="Asia/Dhaka" {{ ($settings['app_timezone'] ?? '') == 'Asia/Dhaka' ? 'selected' : '' }}>Asia/Dhaka</option>
                                        <option value="America/New_York" {{ ($settings['app_timezone'] ?? '') == 'America/New_York' ? 'selected' : '' }}>America/New_York</option>
                                        <option value="Europe/London" {{ ($settings['app_timezone'] ?? '') == 'Europe/London' ? 'selected' : '' }}>Europe/London</option>
                                    </select>
                                </div>
                                <div>
                                    <label class="block font-medium text-sm text-gray-700">Currency Symbol</label>
                                    <input type="text" name="app_currency" value="{{ $settings['app_currency'] ?? '$' }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                                </div>
                                <div>
                                    <label class="block font-medium text-sm text-gray-700">Theme Color (Hex)</label>
                                    <input type="color" name="theme_color" value="{{ $settings['theme_color'] ?? '#4f46e5' }}" class="mt-1 block w-full h-10 rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                                </div>
                                <div class="col-span-2">
                                    <label class="block font-medium text-sm text-gray-700">Main Page Title</label>
                                    <input type="text" name="site_main_title" value="{{ $settings['site_main_title'] ?? 'Welcome to Our SaaS' }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                                </div>
                                <div class="col-span-2">
                                    <label class="block font-medium text-sm text-gray-700">Logo URL</label>
                                    <input type="text" name="site_logo" value="{{ $settings['site_logo'] ?? '' }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50" placeholder="https://example.com/logo.png">
                                </div>
                            </div>
                        </div>

                        <!-- Integrations Tab -->
                        <div x-show="activeTab === 'integrations'" class="space-y-8" x-cloak>
                            <!-- Mail Configuration -->
                            <div class="border-b pb-6">
                                <h3 class="text-lg font-medium text-gray-900 mb-4">📧 Mail Configuration</h3>
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                    <div>
                                        <label class="block font-medium text-sm text-gray-700">Mail Driver</label>
                                        <select name="mail_driver" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                                            <option value="smtp" {{ ($settings['mail_driver'] ?? 'smtp') == 'smtp' ? 'selected' : '' }}>SMTP</option>
                                            <option value="log" {{ ($settings['mail_driver'] ?? '') == 'log' ? 'selected' : '' }}>Log (Dev)</option>
                                        </select>
                                    </div>
                                    <div>
                                        <label class="block font-medium text-sm text-gray-700">Mail Host</label>
                                        <input type="text" name="mail_host" value="{{ $settings['mail_host'] ?? '' }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                                    </div>
                                    <div>
                                        <label class="block font-medium text-sm text-gray-700">Mail Port</label>
                                        <input type="text" name="mail_port" value="{{ $settings['mail_port'] ?? '587' }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                                    </div>
                                    <div>
                                        <label class="block font-medium text-sm text-gray-700">Mail Username</label>
                                        <input type="text" name="mail_username" value="{{ $settings['mail_username'] ?? '' }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                                    </div>
                                    <div>
                                        <label class="block font-medium text-sm text-gray-700">Mail Password</label>
                                        <input type="password" name="mail_password" value="{{ $settings['mail_password'] ?? '' }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                                    </div>
                                    <div>
                                        <label class="block font-medium text-sm text-gray-700">Mail Encryption</label>
                                        <input type="text" name="mail_encryption" value="{{ $settings['mail_encryption'] ?? 'tls' }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                                    </div>
                                </div>
                            </div>

                            <!-- SMS Gateway -->
                            <div class="border-b pb-6">
                                <h3 class="text-lg font-medium text-gray-900 mb-4">📱 SMS Gateway</h3>
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                    <div>
                                        <label class="block font-medium text-sm text-gray-700">SMS Provider</label>
                                        <select name="sms_provider" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                                            <option value="twilio" {{ ($settings['sms_provider'] ?? '') == 'twilio' ? 'selected' : '' }}>Twilio</option>
                                            <option value="nexmo" {{ ($settings['sms_provider'] ?? '') == 'nexmo' ? 'selected' : '' }}>Nexmo</option>
                                        </select>
                                    </div>
                                    <div>
                                        <label class="block font-medium text-sm text-gray-700">API Key</label>
                                        <input type="text" name="sms_api_key" value="{{ $settings['sms_api_key'] ?? '' }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                                    </div>
                                    <div>
                                        <label class="block font-medium text-sm text-gray-700">API Secret</label>
                                        <input type="password" name="sms_api_secret" value="{{ $settings['sms_api_secret'] ?? '' }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                                    </div>
                                </div>
                            </div>

                            <!-- International Payment Gateway -->
                            <div class="border-b pb-6">
                                <h3 class="text-lg font-medium text-gray-900 mb-4">💳 International Payment Gateway</h3>
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                    <div>
                                        <label class="block font-medium text-sm text-gray-700">Primary Gateway</label>
                                        <select name="payment_gateway" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                                            <option value="stripe" {{ ($settings['payment_gateway'] ?? '') == 'stripe' ? 'selected' : '' }}>Stripe</option>
                                            <option value="paypal" {{ ($settings['payment_gateway'] ?? '') == 'paypal' ? 'selected' : '' }}>PayPal</option>
                                        </select>
                                    </div>
                                    <div>
                                        <label class="block font-medium text-sm text-gray-700">Publishable Key / Client ID</label>
                                        <input type="text" name="payment_key" value="{{ $settings['payment_key'] ?? '' }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                                    </div>
                                    <div>
                                        <label class="block font-medium text-sm text-gray-700">Secret Key</label>
                                        <input type="password" name="payment_secret" value="{{ $settings['payment_secret'] ?? '' }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                                    </div>
                                </div>
                            </div>

                            <!-- Bangladeshi Payment Gateways -->
                            <div class="pb-6">
                                <h3 class="text-lg font-medium text-gray-900 mb-4">🇧🇩 Bangladeshi Payment Gateways</h3>
                                
                                <!-- SSLCommerz -->
                                <div class="bg-gray-50 p-4 rounded-md border mb-6">
                                    <h4 class="font-medium text-indigo-700 mb-3 flex items-center">
                                        <span class="mr-2">🔐</span> SSLCommerz (Cards & MFS Aggregator)
                                    </h4>
                                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                        <div class="col-span-2">
                                            <label class="inline-flex items-center">
                                                <input type="hidden" name="enable_sslcommerz" value="0">
                                                <input type="checkbox" name="enable_sslcommerz" value="1" {{ ($settings['enable_sslcommerz'] ?? 0) ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                                                <span class="ml-2 font-medium text-gray-700">Enable SSLCommerz</span>
                                            </label>
                                        </div>
                                        <div>
                                            <label class="block font-medium text-sm text-gray-700">Store ID</label>
                                            <input type="text" name="sslcommerz_store_id" value="{{ $settings['sslcommerz_store_id'] ?? '' }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                                        </div>
                                        <div>
                                            <label class="block font-medium text-sm text-gray-700">Store Password</label>
                                            <input type="password" name="sslcommerz_store_password" value="{{ $settings['sslcommerz_store_password'] ?? '' }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                                        </div>
                                        <div class="col-span-2">
                                            <label class="inline-flex items-center">
                                                <input type="hidden" name="sslcommerz_sandbox" value="0">
                                                <input type="checkbox" name="sslcommerz_sandbox" value="1" {{ ($settings['sslcommerz_sandbox'] ?? 0) ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                                                <span class="ml-2 text-sm text-gray-600">Enable Sandbox Mode (Test)</span>
                                            </label>
                                        </div>
                                    </div>
                                </div>

                                <!-- Manual Mobile Banking -->
                                <h4 class="font-medium text-gray-800 mb-3">📱 Manual Mobile Banking Info</h4>
                                <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                                    <!-- Bkash -->
                                    <div class="bg-pink-50 p-4 rounded-md border border-pink-100">
                                        <div class="flex items-center justify-between mb-2">
                                            <span class="font-bold text-pink-600">Bkash</span>
                                            <label class="inline-flex items-center">
                                                <input type="hidden" name="enable_bkash_manual" value="0">
                                                <input type="checkbox" name="enable_bkash_manual" value="1" {{ ($settings['enable_bkash_manual'] ?? 0) ? 'checked' : '' }} class="rounded border-pink-300 text-pink-600 shadow-sm focus:border-pink-300 focus:ring focus:ring-pink-200 focus:ring-opacity-50">
                                            </label>
                                        </div>
                                        <div class="space-y-2">
                                            <input type="text" name="bkash_number" value="{{ $settings['bkash_number'] ?? '' }}" placeholder="017xxxxxxxx" class="block w-full text-sm rounded-md border-gray-300 shadow-sm focus:border-pink-300 focus:ring focus:ring-pink-200 focus:ring-opacity-50">
                                            <select name="bkash_type" class="block w-full text-sm rounded-md border-gray-300 shadow-sm focus:border-pink-300 focus:ring focus:ring-pink-200 focus:ring-opacity-50">
                                                <option value="personal" {{ ($settings['bkash_type'] ?? '') == 'personal' ? 'selected' : '' }}>Personal</option>
                                                <option value="agent" {{ ($settings['bkash_type'] ?? '') == 'agent' ? 'selected' : '' }}>Agent</option>
                                                <option value="merchant" {{ ($settings['bkash_type'] ?? '') == 'merchant' ? 'selected' : '' }}>Merchant</option>
                                            </select>
                                        </div>
                                    </div>

                                    <!-- Nagad -->
                                    <div class="bg-orange-50 p-4 rounded-md border border-orange-100">
                                        <div class="flex items-center justify-between mb-2">
                                            <span class="font-bold text-orange-600">Nagad</span>
                                            <label class="inline-flex items-center">
                                                <input type="hidden" name="enable_nagad_manual" value="0">
                                                <input type="checkbox" name="enable_nagad_manual" value="1" {{ ($settings['enable_nagad_manual'] ?? 0) ? 'checked' : '' }} class="rounded border-orange-300 text-orange-600 shadow-sm focus:border-orange-300 focus:ring focus:ring-orange-200 focus:ring-opacity-50">
                                            </label>
                                        </div>
                                        <div class="space-y-2">
                                            <input type="text" name="nagad_number" value="{{ $settings['nagad_number'] ?? '' }}" placeholder="017xxxxxxxx" class="block w-full text-sm rounded-md border-gray-300 shadow-sm focus:border-orange-300 focus:ring focus:ring-orange-200 focus:ring-opacity-50">
                                            <select name="nagad_type" class="block w-full text-sm rounded-md border-gray-300 shadow-sm focus:border-orange-300 focus:ring focus:ring-orange-200 focus:ring-opacity-50">
                                                <option value="personal" {{ ($settings['nagad_type'] ?? '') == 'personal' ? 'selected' : '' }}>Personal</option>
                                                <option value="agent" {{ ($settings['nagad_type'] ?? '') == 'agent' ? 'selected' : '' }}>Agent</option>
                                                <option value="merchant" {{ ($settings['nagad_type'] ?? '') == 'merchant' ? 'selected' : '' }}>Merchant</option>
                                            </select>
                                        </div>
                                    </div>

                                    <!-- Rocket -->
                                    <div class="bg-purple-50 p-4 rounded-md border border-purple-100">
                                        <div class="flex items-center justify-between mb-2">
                                            <span class="font-bold text-purple-600">Rocket</span>
                                            <label class="inline-flex items-center">
                                                <input type="hidden" name="enable_rocket_manual" value="0">
                                                <input type="checkbox" name="enable_rocket_manual" value="1" {{ ($settings['enable_rocket_manual'] ?? 0) ? 'checked' : '' }} class="rounded border-purple-300 text-purple-600 shadow-sm focus:border-purple-300 focus:ring focus:ring-purple-200 focus:ring-opacity-50">
                                            </label>
                                        </div>
                                        <div class="space-y-2">
                                            <input type="text" name="rocket_number" value="{{ $settings['rocket_number'] ?? '' }}" placeholder="017xxxxxxxx" class="block w-full text-sm rounded-md border-gray-300 shadow-sm focus:border-purple-300 focus:ring focus:ring-purple-200 focus:ring-opacity-50">
                                            <select name="rocket_type" class="block w-full text-sm rounded-md border-gray-300 shadow-sm focus:border-purple-300 focus:ring focus:ring-purple-200 focus:ring-opacity-50">
                                                <option value="personal" {{ ($settings['rocket_type'] ?? '') == 'personal' ? 'selected' : '' }}>Personal</option>
                                                <option value="agent" {{ ($settings['rocket_type'] ?? '') == 'agent' ? 'selected' : '' }}>Agent</option>
                                                <option value="merchant" {{ ($settings['rocket_type'] ?? '') == 'merchant' ? 'selected' : '' }}>Merchant</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Advanced Tab -->
                        <div x-show="activeTab === 'advanced'" class="space-y-6" x-cloak>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <!-- Site Optimization -->
                                <div class="col-span-2">
                                    <h3 class="text-lg font-medium text-gray-900 mb-4">🚀 Site Optimization</h3>
                                    <div class="flex items-center space-x-4">
                                        <label class="inline-flex items-center">
                                            <input type="hidden" name="site_cache_enable" value="0">
                                            <input type="checkbox" name="site_cache_enable" value="1" {{ ($settings['site_cache_enable'] ?? 0) ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                                            <span class="ml-2">Enable Query Caching</span>
                                        </label>
                                        <label class="inline-flex items-center">
                                            <input type="hidden" name="site_minify_assets" value="0">
                                            <input type="checkbox" name="site_minify_assets" value="1" {{ ($settings['site_minify_assets'] ?? 0) ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                                            <span class="ml-2">Minify CSS/JS Assets</span>
                                        </label>
                                    </div>
                                </div>

                                <!-- Site History & Audit -->
                                <div class="col-span-2 border-t pt-6">
                                    <h3 class="text-lg font-medium text-gray-900 mb-4">📜 History & Audit</h3>
                                    <div class="flex items-center space-x-4">
                                        <label class="inline-flex items-center">
                                            <input type="hidden" name="site_audit_log_enable" value="0">
                                            <input type="checkbox" name="site_audit_log_enable" value="1" {{ ($settings['site_audit_log_enable'] ?? 0) ? 'checked' : '' }} class="rounded border-gray-300 text-indigo-600 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                                            <span class="ml-2">Enable Detailed Audit Logs</span>
                                        </label>
                                    </div>
                                    <p class="text-sm text-gray-500 mt-2">
                                        <a href="#" class="text-indigo-600 hover:text-indigo-900">View Site History Logs &rarr;</a>
                                    </p>
                                </div>
                            </div>
                        </div>

                        <!-- AI Settings Tab -->
                        <div x-show="activeTab === 'ai_settings'" class="space-y-6" x-cloak>
                            <div class="bg-indigo-50 p-4 rounded-lg border border-indigo-100 mb-6">
                                <h3 class="text-lg font-medium text-indigo-900 mb-2">🤖 Multi-AI API Configuration</h3>
                                <p class="text-sm text-indigo-700">এখানে আপনি একাধিক AI এপিআই কনফিগার করতে পারেন। সিস্টেম র‍্যান্ডমলি একটি একটি করে ট্রাই করবে, যদি একটি ফেইল হয় তবে পরেরটি ব্যবহার করবে।</p>
                            </div>

                            <div class="grid grid-cols-1 gap-6">
                                <!-- OpenAI Configuration -->
                                <div class="border rounded-lg p-4 bg-white shadow-sm">
                                    <div class="flex items-center justify-between mb-4">
                                        <div class="flex items-center">
                                            <span class="text-2xl mr-2">🧠</span>
                                            <h4 class="font-bold text-gray-800">OpenAI (ChatGPT)</h4>
                                        </div>
                                        <label class="inline-flex items-center cursor-pointer">
                                            <input type="hidden" name="ai_openai_enable" value="0">
                                            <input type="checkbox" name="ai_openai_enable" value="1" {{ ($settings['ai_openai_enable'] ?? 0) ? 'checked' : '' }} class="sr-only peer">
                                            <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-indigo-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-indigo-600"></div>
                                            <span class="ml-3 text-sm font-medium text-gray-700">Active</span>
                                        </label>
                                    </div>
                                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                        <div>
                                            <label class="block text-sm font-medium text-gray-700">API Key</label>
                                            <input type="password" name="ai_openai_api_key" value="{{ $settings['ai_openai_api_key'] ?? '' }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm" placeholder="sk-...">
                                        </div>
                                        <div>
                                            <label class="block text-sm font-medium text-gray-700">Default Model</label>
                                            <select name="ai_openai_model" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm">
                                                <option value="gpt-4o-mini" {{ ($settings['ai_openai_model'] ?? '') == 'gpt-4o-mini' ? 'selected' : '' }}>gpt-4o-mini (Recommended)</option>
                                                <option value="gpt-4o" {{ ($settings['ai_openai_model'] ?? '') == 'gpt-4o' ? 'selected' : '' }}>gpt-4o</option>
                                                <option value="gpt-3.5-turbo" {{ ($settings['ai_openai_model'] ?? '') == 'gpt-3.5-turbo' ? 'selected' : '' }}>gpt-3.5-turbo</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                <!-- Anthropic (Claude) Configuration -->
                                <div class="border rounded-lg p-4 bg-white shadow-sm opacity-60 hover:opacity-100 transition-opacity">
                                    <div class="flex items-center justify-between mb-4">
                                        <div class="flex items-center">
                                            <span class="text-2xl mr-2">🎭</span>
                                            <h4 class="font-bold text-gray-800">Anthropic (Claude)</h4>
                                        </div>
                                        <label class="inline-flex items-center cursor-pointer">
                                            <input type="hidden" name="ai_anthropic_enable" value="0">
                                            <input type="checkbox" name="ai_anthropic_enable" value="1" {{ ($settings['ai_anthropic_enable'] ?? 0) ? 'checked' : '' }} class="sr-only peer">
                                            <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-indigo-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-indigo-600"></div>
                                            <span class="ml-3 text-sm font-medium text-gray-700">Active</span>
                                        </label>
                                    </div>
                                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                        <div>
                                            <label class="block text-sm font-medium text-gray-700">API Key</label>
                                            <input type="password" name="ai_anthropic_api_key" value="{{ $settings['ai_anthropic_api_key'] ?? '' }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm" placeholder="x-api-key-...">
                                        </div>
                                        <div>
                                            <label class="block text-sm font-medium text-gray-700">Default Model</label>
                                            <select name="ai_anthropic_model" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm">
                                                <option value="claude-3-haiku-20240307" {{ ($settings['ai_anthropic_model'] ?? '') == 'claude-3-haiku-20240307' ? 'selected' : '' }}>Claude 3 Haiku</option>
                                                <option value="claude-3-5-sonnet-20240620" {{ ($settings['ai_anthropic_model'] ?? '') == 'claude-3-5-sonnet-20240620' ? 'selected' : '' }}>Claude 3.5 Sonnet</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                <!-- Google Gemini Configuration -->
                                <div class="border rounded-lg p-4 bg-white shadow-sm opacity-60 hover:opacity-100 transition-opacity">
                                    <div class="flex items-center justify-between mb-4">
                                        <div class="flex items-center">
                                            <span class="text-2xl mr-2">💎</span>
                                            <h4 class="font-bold text-gray-800">Google Gemini</h4>
                                        </div>
                                        <label class="inline-flex items-center cursor-pointer">
                                            <input type="hidden" name="ai_gemini_enable" value="0">
                                            <input type="checkbox" name="ai_gemini_enable" value="1" {{ ($settings['ai_gemini_enable'] ?? 0) ? 'checked' : '' }} class="sr-only peer">
                                            <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-indigo-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-indigo-600"></div>
                                            <span class="ml-3 text-sm font-medium text-gray-700">Active</span>
                                        </label>
                                    </div>
                                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                        <div>
                                            <label class="block text-sm font-medium text-gray-700">API Key</label>
                                            <input type="password" name="ai_gemini_api_key" value="{{ $settings['ai_gemini_api_key'] ?? '' }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm" placeholder="AIzaSy...">
                                        </div>
                                        <div>
                                            <label class="block text-sm font-medium text-gray-700">Default Model</label>
                                            <select name="ai_gemini_model" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm">
                                                <option value="gemini-1.5-flash" {{ ($settings['ai_gemini_model'] ?? '') == 'gemini-1.5-flash' ? 'selected' : '' }}>Gemini 1.5 Flash</option>
                                                <option value="gemini-1.5-pro" {{ ($settings['ai_gemini_model'] ?? '') == 'gemini-1.5-pro' ? 'selected' : '' }}>Gemini 1.5 Pro</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                <!-- OpenRouter (AI Provider) -->
                                <div class="border rounded-lg p-4 bg-white shadow-sm opacity-60 hover:opacity-100 transition-opacity">
                                    <div class="flex items-center justify-between mb-4">
                                        <div class="flex items-center">
                                            <span class="text-2xl mr-2">🌐</span>
                                            <h4 class="font-bold text-gray-800">OpenRouter (AI Models)</h4>
                                        </div>
                                        <label class="inline-flex items-center cursor-pointer">
                                            <input type="hidden" name="ai_openrouter_enable" value="0">
                                            <input type="checkbox" name="ai_openrouter_enable" value="1" {{ ($settings['ai_openrouter_enable'] ?? 0) ? 'checked' : '' }} class="sr-only peer">
                                            <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-indigo-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-indigo-600"></div>
                                            <span class="ml-3 text-sm font-medium text-gray-700">Active</span>
                                        </label>
                                    </div>
                                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                        <div class="col-span-2">
                                            <p class="text-xs text-gray-500 mb-2">Note: Uses the API Key from "External API Keys" tab.</p>
                                        </div>
                                        <div>
                                            <label class="block text-sm font-medium text-gray-700">Default Model</label>
                                            <select name="ai_openrouter_model" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm">
                                                <option value="google/gemini-2.0-flash-exp:free" {{ ($settings['ai_openrouter_model'] ?? '') == 'google/gemini-2.0-flash-exp:free' ? 'selected' : '' }}>Gemini 2.0 Flash (Free)</option>
                                                <option value="mistralai/mistral-7b-instruct:free" {{ ($settings['ai_openrouter_model'] ?? '') == 'mistralai/mistral-7b-instruct:free' ? 'selected' : '' }}>Mistral 7B (Free)</option>
                                                <option value="meta-llama/llama-3-8b-instruct:free" {{ ($settings['ai_openrouter_model'] ?? '') == 'meta-llama/llama-3-8b-instruct:free' ? 'selected' : '' }}>Llama 3 8B (Free)</option>
                                                <option value="anthropic/claude-3-haiku" {{ ($settings['ai_openrouter_model'] ?? '') == 'anthropic/claude-3-haiku' ? 'selected' : '' }}>Claude 3 Haiku</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- External API Keys Tab -->
                        <div x-show="activeTab === 'api_keys'" class="space-y-6" x-cloak>
                            <div class="bg-amber-50 p-4 rounded-lg border border-amber-100 mb-6">
                                <h3 class="text-lg font-medium text-amber-900 mb-2">🔑 External Services API Keys</h3>
                                <p class="text-sm text-amber-700">এখানে আপনি বিভিন্ন থার্ড-পার্টি সার্ভিসের এপিআই কি কনফিগার করতে পারেন যা অ্যাপ্লিকেশনের বিভিন্ন ফিচারে ব্যবহৃত হবে।</p>
                            </div>

                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <!-- RapidAPI -->
                                <div class="border rounded-lg p-4 bg-white shadow-sm">
                                    <div class="flex items-center mb-4">
                                        <span class="text-2xl mr-2">🚀</span>
                                        <h4 class="font-bold text-gray-800">RapidAPI</h4>
                                    </div>
                                    <div>
                                        <label class="block text-sm font-medium text-gray-700">API Key</label>
                                        <div class="mt-1 flex space-x-2">
                                            <input type="password" id="api_rapidapi_key" name="api_rapidapi_key" value="{{ $settings['api_rapidapi_key'] ?? '' }}" class="block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm" placeholder="your-rapidapi-key">
                                            <button type="button" onclick="testConnection('rapidapi')" class="inline-flex items-center px-3 py-2 border border-transparent text-sm leading-4 font-medium rounded-md text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 transition-colors duration-200" id="rapidapi-test-btn">
                                                <span id="rapidapi-btn-text">Test</span>
                                            </button>
                                        </div>
                                        <div id="rapidapi-result" class="mt-2 text-sm hidden"></div>
                                    </div>
                                </div>

                                <!-- OpenRouter -->
                                <div class="border rounded-lg p-4 bg-white shadow-sm">
                                    <div class="flex items-center mb-4">
                                        <span class="text-2xl mr-2">🌐</span>
                                        <h4 class="font-bold text-gray-800">OpenRouter</h4>
                                    </div>
                                    <div>
                                        <label class="block text-sm font-medium text-gray-700">API Key</label>
                                        <div class="mt-1 flex space-x-2">
                                            <input type="password" id="api_openrouter_key" name="api_openrouter_key" value="{{ $settings['api_openrouter_key'] ?? '' }}" class="block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm" placeholder="sk-or-v1-...">
                                            <button type="button" onclick="testConnection('openrouter')" class="inline-flex items-center px-3 py-2 border border-transparent text-sm leading-4 font-medium rounded-md text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 transition-colors duration-200" id="openrouter-test-btn">
                                                <span id="openrouter-btn-text">Test</span>
                                            </button>
                                        </div>
                                        <div id="openrouter-result" class="mt-2 text-sm hidden"></div>
                                    </div>
                                </div>

                                <!-- Numverify -->
                                <div class="border rounded-lg p-4 bg-white shadow-sm">
                                    <div class="flex items-center mb-4">
                                        <span class="text-2xl mr-2">📞</span>
                                        <h4 class="font-bold text-gray-800">Numverify</h4>
                                    </div>
                                    <div>
                                        <label class="block text-sm font-medium text-gray-700">API Access Key</label>
                                        <div class="mt-1 flex space-x-2">
                                            <input type="password" id="api_numverify_key" name="api_numverify_key" value="{{ $settings['api_numverify_key'] ?? '' }}" class="block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm" placeholder="your-access-key">
                                            <button type="button" onclick="testConnection('numverify')" class="inline-flex items-center px-3 py-2 border border-transparent text-sm leading-4 font-medium rounded-md text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 transition-colors duration-200" id="numverify-test-btn">
                                                <span id="numverify-btn-text">Test</span>
                                            </button>
                                        </div>
                                        <div id="numverify-result" class="mt-2 text-sm hidden"></div>
                                    </div>
                                </div>

                                <!-- PokéAPI -->
                                <div class="border rounded-lg p-4 bg-white shadow-sm">
                                    <div class="flex items-center mb-4">
                                        <span class="text-2xl mr-2">🐾</span>
                                        <h4 class="font-bold text-gray-800">PokéAPI (Free)</h4>
                                    </div>
                                    <div>
                                        <label class="block text-sm font-medium text-gray-700">Access Token (If required)</label>
                                        <div class="mt-1 flex space-x-2">
                                            <input type="password" id="api_pokeapi_key" name="api_pokeapi_key" value="{{ $settings['api_pokeapi_key'] ?? '' }}" class="block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm" placeholder="Optional token">
                                            <button type="button" onclick="testConnection('pokeapi')" class="inline-flex items-center px-3 py-2 border border-transparent text-sm leading-4 font-medium rounded-md text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 transition-colors duration-200" id="pokeapi-test-btn">
                                                <span id="pokeapi-btn-text">Test</span>
                                            </button>
                                        </div>
                                        <div id="pokeapi-result" class="mt-2 text-sm hidden"></div>
                                    </div>
                                </div>

                                <!-- Serper.dev -->
                                <div class="border rounded-lg p-4 bg-white shadow-sm">
                                    <div class="flex items-center mb-4">
                                        <span class="text-2xl mr-2">🔍</span>
                                        <h4 class="font-bold text-gray-800">Serper.dev</h4>
                                    </div>
                                    <div>
                                        <label class="block text-sm font-medium text-gray-700">API Key (<a href="https://serper.dev/api-keys" target="_blank" class="text-indigo-600 hover:text-indigo-800 underline text-xs">Get Key</a>)</label>
                                        <div class="mt-1 flex space-x-2">
                                            <input type="password" id="api_serper_key" name="api_serper_key" value="{{ $settings['api_serper_key'] ?? '' }}" class="block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm" placeholder="your-serper-api-key">
                                            <button type="button" onclick="testConnection('serper')" class="inline-flex items-center px-3 py-2 border border-transparent text-sm leading-4 font-medium rounded-md text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 transition-colors duration-200" id="serper-test-btn">
                                                <span id="serper-btn-text">Test</span>
                                            </button>
                                        </div>
                                        <div id="serper-result" class="mt-2 text-sm hidden"></div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="mt-8 flex justify-end">
                            <button type="submit" class="bg-indigo-600 hover:bg-indigo-700 text-white font-bold py-2 px-6 rounded-lg transition duration-150 ease-in-out">
                                Save Configuration
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <script>
        function testConnection(type) {
            const apiKeyInput = document.getElementById(`api_${type}_key`);
            const apiKey = apiKeyInput ? apiKeyInput.value : '';
            const btn = document.getElementById(`${type}-test-btn`);
            const btnText = document.getElementById(`${type}-btn-text`);
            const resultDiv = document.getElementById(`${type}-result`);

            // For PokéAPI, apiKey is optional
            if (type !== 'pokeapi' && !apiKey) {
                resultDiv.textContent = 'দয়া করে আগে API Key প্রদান করুন।';
                resultDiv.className = `mt-2 text-sm text-red-600`;
                resultDiv.classList.remove('hidden');
                return;
            }

            // UI loading state
            btn.disabled = true;
            const originalText = btnText.textContent;
            btnText.textContent = 'Checking...';
            resultDiv.classList.add('hidden');

            const routes = {
                'serper': '{{ route('admin.settings.test-serper') }}',
                'rapidapi': '{{ route('admin.settings.test-rapidapi') }}',
                'openrouter': '{{ route('admin.settings.test-openrouter') }}',
                'numverify': '{{ route('admin.settings.test-numverify') }}',
                'pokeapi': '{{ route('admin.settings.test-pokeapi') }}'
            };

            fetch(routes[type], {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify({ api_key: apiKey })
            })
            .then(response => response.json())
            .then(data => {
                resultDiv.classList.remove('hidden');
                if (data.success) {
                    resultDiv.textContent = data.message;
                    resultDiv.className = `mt-2 text-sm text-green-600 font-medium`;
                } else {
                    resultDiv.textContent = data.message;
                    resultDiv.className = `mt-2 text-sm text-red-600 font-medium`;
                }
            })
            .catch(error => {
                resultDiv.classList.remove('hidden');
                resultDiv.textContent = 'Error: ' + error.message;
                resultDiv.className = `mt-2 text-sm text-red-600 font-medium`;
            })
            .finally(() => {
                btn.disabled = false;
                btnText.textContent = originalText;
            });
        }
    </script>
</x-admin-layout>
