<x-admin-layout>
    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 bg-white border-b border-gray-200">
                    <div class="flex justify-between items-center mb-6">
                        <h2 class="text-2xl font-bold text-gray-800">
                            🔒 SaaS Security Settings
                        </h2>
                    </div>

                    @if (session('success'))
                        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-4" role="alert">
                            <span class="block sm:inline">{{ session('success') }}</span>
                        </div>
                    @endif

                    <form action="{{ route('admin.security.update') }}" method="POST">
                        @csrf
                        @method('PUT')

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <!-- Enable Captcha -->
                            <div class="border rounded-lg p-4 bg-gray-50">
                                <div class="flex items-center justify-between">
                                    <div>
                                        <h3 class="text-lg font-medium text-gray-900">Enable Captcha</h3>
                                        <p class="text-sm text-gray-500">Require Captcha for login and registration forms to prevent bots.</p>
                                    </div>
                                    <div class="flex items-center">
                                        <label for="enable_captcha" class="flex items-center cursor-pointer">
                                            <div class="relative">
                                                <input type="checkbox" id="enable_captcha" name="enable_captcha" class="sr-only" {{ $settings->enable_captcha ? 'checked' : '' }}>
                                                <div class="w-10 h-4 bg-gray-400 rounded-full shadow-inner"></div>
                                                <div class="dot absolute w-6 h-6 bg-white rounded-full shadow -left-1 -top-1 transition"></div>
                                            </div>
                                        </label>
                                    </div>
                                </div>
                            </div>

                            <!-- 3D Verification / 2FA -->
                            <div class="border rounded-lg p-4 bg-gray-50">
                                <div class="flex items-center justify-between">
                                    <div>
                                        <h3 class="text-lg font-medium text-gray-900">3D Verification / 2FA</h3>
                                        <p class="text-sm text-gray-500">Enable Two-Factor Authentication for an extra layer of security.</p>
                                    </div>
                                    <div class="flex items-center">
                                        <label for="enable_2fa" class="flex items-center cursor-pointer">
                                            <div class="relative">
                                                <input type="checkbox" id="enable_2fa" name="enable_2fa" class="sr-only" {{ $settings->enable_2fa ? 'checked' : '' }}>
                                                <div class="w-10 h-4 bg-gray-400 rounded-full shadow-inner"></div>
                                                <div class="dot absolute w-6 h-6 bg-white rounded-full shadow -left-1 -top-1 transition"></div>
                                            </div>
                                        </label>
                                    </div>
                                </div>
                            </div>

                            <!-- IP Block -->
                            <div class="border rounded-lg p-4 bg-gray-50">
                                <div class="flex items-center justify-between">
                                    <div>
                                        <h3 class="text-lg font-medium text-gray-900">IP Blocking</h3>
                                        <p class="text-sm text-gray-500">Enable IP blocking to restrict access from suspicious IP addresses.</p>
                                        <a href="{{ route('admin.blocked-ips.index') }}" class="text-indigo-600 hover:text-indigo-800 text-sm mt-2 inline-block font-medium">Manage Blocked IPs &rarr;</a>
                                    </div>
                                    <div class="flex items-center">
                                        <label for="enable_ip_blocking" class="flex items-center cursor-pointer">
                                            <div class="relative">
                                                <input type="checkbox" id="enable_ip_blocking" name="enable_ip_blocking" class="sr-only" {{ $settings->enable_ip_blocking ? 'checked' : '' }}>
                                                <div class="w-10 h-4 bg-gray-400 rounded-full shadow-inner"></div>
                                                <div class="dot absolute w-6 h-6 bg-white rounded-full shadow -left-1 -top-1 transition"></div>
                                            </div>
                                        </label>
                                    </div>
                                </div>
                            </div>

                            <!-- Honeypot -->
                            <div class="border rounded-lg p-4 bg-gray-50">
                                <div class="flex items-center justify-between">
                                    <div>
                                        <h3 class="text-lg font-medium text-gray-900">Honeypot</h3>
                                        <p class="text-sm text-gray-500">Enable Honeypot traps to catch and block automated bots.</p>
                                    </div>
                                    <div class="flex items-center">
                                        <label for="enable_honeypot" class="flex items-center cursor-pointer">
                                            <div class="relative">
                                                <input type="checkbox" id="enable_honeypot" name="enable_honeypot" class="sr-only" {{ $settings->enable_honeypot ? 'checked' : '' }}>
                                                <div class="w-10 h-4 bg-gray-400 rounded-full shadow-inner"></div>
                                                <div class="dot absolute w-6 h-6 bg-white rounded-full shadow -left-1 -top-1 transition"></div>
                                            </div>
                                        </label>
                                    </div>
                                </div>
                            </div>

                            <!-- Login Log -->
                            <div class="border rounded-lg p-4 bg-gray-50">
                                <div class="flex items-center justify-between">
                                    <div>
                                        <h3 class="text-lg font-medium text-gray-900">Login Logs</h3>
                                        <p class="text-sm text-gray-500">Keep a detailed log of all user login attempts.</p>
                                        <a href="{{ route('admin.login-logs.index') }}" class="text-indigo-600 hover:text-indigo-800 text-sm mt-2 inline-block font-medium">View Login Logs &rarr;</a>
                                    </div>
                                    <div class="flex items-center">
                                        <label for="enable_login_log" class="flex items-center cursor-pointer">
                                            <div class="relative">
                                                <input type="checkbox" id="enable_login_log" name="enable_login_log" class="sr-only" {{ $settings->enable_login_log ? 'checked' : '' }}>
                                                <div class="w-10 h-4 bg-gray-400 rounded-full shadow-inner"></div>
                                                <div class="dot absolute w-6 h-6 bg-white rounded-full shadow -left-1 -top-1 transition"></div>
                                            </div>
                                        </label>
                                    </div>
                                </div>
                            </div>

                            <!-- Data Backup -->
                            <div class="border rounded-lg p-4 bg-gray-50">
                                <div class="flex items-center justify-between">
                                    <div>
                                        <h3 class="text-lg font-medium text-gray-900">Data Backup</h3>
                                        <p class="text-sm text-gray-500">Enable automated daily data backups.</p>
                                        <a href="{{ route('admin.backups.index') }}" class="text-indigo-600 hover:text-indigo-800 text-sm mt-2 inline-block font-medium">Manage Backups &rarr;</a>
                                    </div>
                                    <div class="flex items-center">
                                        <label for="enable_data_backup" class="flex items-center cursor-pointer">
                                            <div class="relative">
                                                <input type="checkbox" id="enable_data_backup" name="enable_data_backup" class="sr-only" {{ $settings->enable_data_backup ? 'checked' : '' }}>
                                                <div class="w-10 h-4 bg-gray-400 rounded-full shadow-inner"></div>
                                                <div class="dot absolute w-6 h-6 bg-white rounded-full shadow -left-1 -top-1 transition"></div>
                                            </div>
                                        </label>
                                    </div>
                                </div>
                            </div>

                            <!-- Site Maintenance Flag -->
                            <div class="border rounded-lg p-4 bg-red-50 border-red-200">
                                <div class="flex items-center justify-between">
                                    <div>
                                        <h3 class="text-lg font-medium text-red-900">Site Maintenance Mode</h3>
                                        <p class="text-sm text-red-500">Put the entire site into maintenance mode. Only admins can access.</p>
                                    </div>
                                    <div class="flex items-center">
                                        <label for="enable_maintenance_mode" class="flex items-center cursor-pointer">
                                            <div class="relative">
                                                <input type="checkbox" id="enable_maintenance_mode" name="enable_maintenance_mode" class="sr-only" {{ $settings->enable_maintenance_mode ? 'checked' : '' }}>
                                                <div class="w-10 h-4 bg-gray-400 rounded-full shadow-inner"></div>
                                                <div class="dot absolute w-6 h-6 bg-white rounded-full shadow -left-1 -top-1 transition"></div>
                                            </div>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="mt-8 flex justify-end">
                            <button type="submit" class="bg-indigo-600 hover:bg-indigo-700 text-white font-bold py-2 px-6 rounded-lg transition duration-150 ease-in-out">
                                Save Security Settings
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <style>
        input:checked ~ .dot {
            transform: translateX(100%);
            background-color: #4f46e5;
        }
        input:checked ~ .bg-gray-400 {
            background-color: #c7d2fe;
        }
    </style>
</x-admin-layout>
