<x-admin-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            Customer Reports
        </h2>
    </x-slot>

    <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
        <!-- Filters -->
        <div class="bg-white shadow-sm rounded-lg mb-6">
            <div class="p-6">
                <form method="GET" action="{{ route('admin.reports.customers') }}">
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Search</label>
                            <input type="text" name="search" value="{{ $search }}" placeholder="Search by name or email" 
                                   class="w-full rounded-md border-gray-300 shadow-sm focus:border-green-500 focus:ring focus:ring-green-200 focus:ring-opacity-50">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Status</label>
                            <select name="status" class="w-full rounded-md border-gray-300 shadow-sm focus:border-green-500 focus:ring focus:ring-green-200 focus:ring-opacity-50">
                                <option value="all" {{ $status == 'all' ? 'selected' : '' }}>All</option>
                                <option value="active" {{ $status == 'active' ? 'selected' : '' }}>Active</option>
                                <option value="expired" {{ $status == 'expired' ? 'selected' : '' }}>Expired</option>
                                <option value="trial" {{ $status == 'trial' ? 'selected' : '' }}>Trial</option>
                            </select>
                        </div>
                        <div class="flex items-end">
                            <button type="submit" class="bg-green-600 text-white px-4 py-2 rounded-md hover:bg-green-700">
                                Apply Filters
                            </button>
                            <a href="{{ route('admin.reports.customers') }}" class="ml-2 text-gray-600 hover:text-gray-800">
                                Clear
                            </a>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <!-- Statistics Cards -->
        <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-6">
            <div class="bg-white overflow-hidden shadow-sm rounded-lg">
                <div class="p-6">
                    <div class="text-sm font-medium text-gray-500">Total Tenants</div>
                    <div class="text-2xl font-bold text-gray-900">{{ $totalTenants }}</div>
                </div>
            </div>
            <div class="bg-white overflow-hidden shadow-sm rounded-lg">
                <div class="p-6">
                    <div class="text-sm font-medium text-gray-500">Active</div>
                    <div class="text-2xl font-bold text-green-600">{{ $activeTenants }}</div>
                </div>
            </div>
            <div class="bg-white overflow-hidden shadow-sm rounded-lg">
                <div class="p-6">
                    <div class="text-sm font-medium text-gray-500">Expired</div>
                    <div class="text-2xl font-bold text-red-600">{{ $expiredTenants }}</div>
                </div>
            </div>
            <div class="bg-white overflow-hidden shadow-sm rounded-lg">
                <div class="p-6">
                    <div class="text-sm font-medium text-gray-500">Trial</div>
                    <div class="text-2xl font-bold text-yellow-600">{{ $trialTenants }}</div>
                </div>
            </div>
        </div>

        <!-- Customers Table -->
        <div class="bg-white shadow-sm rounded-lg">
            <div class="p-6">
                <h3 class="text-lg font-medium text-gray-900 mb-4">Customer List</h3>
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Name</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Email</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Plan</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Ends At</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Users</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @foreach($tenants as $tenant)
                                <tr>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="text-sm font-medium text-gray-900">{{ $tenant->name }}</div>
                                        <div class="text-sm text-gray-500">ID: {{ $tenant->id }}</div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                        {{ $tenant->domain }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                        @if($tenant->subscription)
                                            {{ $tenant->subscription->plan->name }}
                                        @else
                                            <span class="text-gray-400">No Plan</span>
                                        @endif
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        @if($tenant->subscription)
                                            <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full
                                                @if($tenant->subscription->status === 'active' && $tenant->subscription->ends_at && $tenant->subscription->ends_at > now()) bg-green-100 text-green-800
                                                @elseif($tenant->subscription->ends_at && $tenant->subscription->ends_at < now()) bg-red-100 text-red-800
                                                @elseif($tenant->subscription->status === 'trialing') bg-yellow-100 text-yellow-800
                                                @else bg-gray-100 text-gray-800 @endif">
                                                @if($tenant->subscription->status === 'active' && $tenant->subscription->ends_at && $tenant->subscription->ends_at > now())
                                                    Active
                                                @elseif($tenant->subscription->ends_at && $tenant->subscription->ends_at < now())
                                                    Expired
                                                @elseif($tenant->subscription->status === 'trialing')
                                                    Trial
                                                @else
                                                    {{ ucfirst($tenant->subscription->status) }}
                                                @endif
                                            </span>
                                        @else
                                            <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-gray-100 text-gray-800">
                                                No Subscription
                                            </span>
                                        @endif
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                        @if($tenant->subscription && $tenant->subscription->ends_at)
                                            {{ $tenant->subscription->ends_at->format('M d, Y') }}
                                        @else
                                            <span class="text-gray-400">No end date</span>
                                        @endif
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                        {{ $tenant->users->count() }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                        <a href="{{ route('admin.reports.customer-details', $tenant->id) }}" 
                                           class="text-green-600 hover:text-green-900 mr-3">View Details</a>
                                        <button onclick="startChat({{ $tenant->id }})" 
                                                class="text-blue-600 hover:text-blue-900">Chat</button>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                
                <!-- Pagination -->
                <div class="mt-4">
                    {{ $tenants->links() }}
                </div>
            </div>
        </div>
    </div>

    <!-- Start Chat Modal -->
    <div id="startChatModal" class="hidden fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50">
        <div class="relative top-20 mx-auto p-5 border w-96 shadow-lg rounded-md bg-white">
            <div class="mt-3">
                <h3 class="text-lg font-medium text-gray-900">Start Chat</h3>
                <div class="mt-2 text-sm text-gray-500">
                    Are you sure you want to start a chat with this tenant?
                </div>
                <div class="mt-4 flex justify-end space-x-3">
                    <button onclick="closeChatModal()" 
                            class="px-4 py-2 bg-gray-300 text-gray-800 rounded hover:bg-gray-400">
                        Cancel
                    </button>
                    <button onclick="confirmStartChat()" 
                            class="px-4 py-2 bg-blue-600 text-white rounded hover:bg-blue-700">
                        Start Chat
                    </button>
                </div>
            </div>
        </div>
    </div>

    <script>
        let selectedTenantId = null;

        function startChat(tenantId) {
            selectedTenantId = tenantId;
            document.getElementById('startChatModal').classList.remove('hidden');
        }

        function closeChatModal() {
            document.getElementById('startChatModal').classList.add('hidden');
            selectedTenantId = null;
        }

        function confirmStartChat() {
            if (selectedTenantId) {
                const form = document.createElement('form');
                form.method = 'POST';
                form.action = '{{ route('admin.chat.start') }}';
                
                const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
                const csrfInput = document.createElement('input');
                csrfInput.type = 'hidden';
                csrfInput.name = '_token';
                csrfInput.value = csrfToken;
                form.appendChild(csrfInput);
                
                const tenantInput = document.createElement('input');
                tenantInput.type = 'hidden';
                tenantInput.name = 'tenant_id';
                tenantInput.value = selectedTenantId;
                form.appendChild(tenantInput);
                
                document.body.appendChild(form);
                form.submit();
            }
        }
    </script>
</x-admin-layout>
