<x-admin-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between">
            <h2 class="text-xl font-semibold text-gray-800">
                Customer Details: {{ $tenant->name }}
            </h2>
            <div class="flex items-center space-x-4">
                <a href="{{ route('admin.reports.customers') }}" 
                   class="text-gray-600 hover:text-gray-800">
                    ← Back to Customers
                </a>
                <form action="{{ route('admin.chat.start') }}" method="POST" class="inline">
                    @csrf
                    <input type="hidden" name="tenant_id" value="{{ $tenant->id }}">
                    <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-md hover:bg-blue-700 text-sm">
                        Start Chat
                    </button>
                </form>
            </div>
        </div>
    </x-slot>

    <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
        <!-- Customer Overview -->
        <div class="bg-white shadow-sm rounded-lg mb-6">
            <div class="p-6">
                <div class="flex items-center justify-between mb-6">
                    <div class="flex items-center">
                        <div class="flex-shrink-0">
                            <div class="h-12 w-12 rounded-full bg-blue-500 flex items-center justify-center">
                                <span class="text-white font-medium text-lg">
                                    {{ substr($tenant->name ?? 'Unknown', 0, 1) }}
                                </span>
                            </div>
                        </div>
                        <div class="ml-4">
                            <h3 class="text-lg font-medium text-gray-900">{{ $tenant->name ?? 'Unknown Tenant' }}</h3>
                            <p class="text-sm text-gray-500">{{ $tenant->domain ?? 'No domain' }}</p>
                            <div class="flex items-center mt-1">
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium
                                    @if($tenant->status === 'active') bg-green-100 text-green-800
                                    @elseif($tenant->status === 'trialing') bg-blue-100 text-blue-800
                                    @else bg-red-100 text-red-800 @endif">
                                    {{ ucfirst($tenant->status ?? 'unknown') }}
                                </span>
                                @if($tenant->trial_ends_at)
                                    <span class="ml-2 text-xs text-gray-500">
                                        Trial ends: {{ $tenant->trial_ends_at->format('M d, Y') }}
                                    </span>
                                @endif
                            </div>
                        </div>
                    </div>
                    <div class="text-right">
                        <p class="text-sm text-gray-500">Created</p>
                        <p class="text-lg font-medium text-gray-900">{{ $tenant->created_at->format('M d, Y') }}</p>
                    </div>
                </div>

                <!-- Subscription Info -->
                @if($tenant->subscription)
                    <div class="border-t pt-4">
                        <h4 class="text-sm font-medium text-gray-900 mb-3">Current Subscription</h4>
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                            <div>
                                <p class="text-sm text-gray-500">Plan</p>
                                <p class="font-medium">{{ $tenant->subscription->plan->name ?? 'Unknown Plan' }}</p>
                            </div>
                            <div>
                                <p class="text-sm text-gray-500">Status</p>
                                <p class="font-medium">{{ ucfirst($tenant->subscription->status ?? 'unknown') }}</p>
                            </div>
                            <div>
                                <p class="text-sm text-gray-500">Amount</p>
                                <p class="font-medium">${{ number_format($tenant->subscription->amount ?? 0, 2) }}</p>
                            </div>
                            <div>
                                <p class="text-sm text-gray-500">Period</p>
                                <p class="font-medium">{{ ucfirst($tenant->subscription->billing_cycle ?? 'monthly') }}</p>
                            </div>
                            <div>
                                <p class="text-sm text-gray-500">Gateway</p>
                                <p class="font-medium">{{ ucfirst($tenant->subscription->payment_gateway ?? 'unknown') }}</p>
                            </div>
                            <div>
                                <p class="text-sm text-gray-500">Next Payment</p>
                                <p class="font-medium">
                                    {{ $tenant->subscription->ends_at ? $tenant->subscription->ends_at->format('M d, Y') : 'N/A' }}
                                </p>
                            </div>
                        </div>
                    </div>
                @else
                    <div class="border-t pt-4">
                        <p class="text-sm text-gray-500">No active subscription</p>
                    </div>
                @endif

                <!-- Users -->
                @if($tenant->users && $tenant->users->count() > 0)
                    <div class="border-t pt-4 mt-4">
                        <h4 class="text-sm font-medium text-gray-900 mb-3">Users ({{ $tenant->users->count() }})</h4>
                        <div class="space-y-2">
                            @foreach($tenant->users as $user)
                                <div class="flex items-center justify-between py-2 px-3 bg-gray-50 rounded">
                                    <div class="flex items-center">
                                        <div class="h-8 w-8 rounded-full bg-gray-300 flex items-center justify-center">
                                            <span class="text-gray-600 text-sm font-medium">
                                                {{ substr($user->name ?? 'U', 0, 1) }}
                                            </span>
                                        </div>
                                        <div class="ml-3">
                                            <p class="text-sm font-medium text-gray-900">{{ $user->name ?? 'Unknown User' }}</p>
                                            <p class="text-xs text-gray-500">{{ $user->email ?? 'No email' }}</p>
                                        </div>
                                    </div>
                                    <span class="text-xs text-gray-500">
                                        {{ $user->created_at->format('M d, Y') }}
                                    </span>
                                </div>
                            @endforeach
                        </div>
                    </div>
                @endif
            </div>
        </div>

        <!-- Transaction History -->
        <div class="bg-white shadow-sm rounded-lg">
            <div class="p-6">
                <h3 class="text-lg font-medium text-gray-900 mb-4">Transaction History</h3>
                
                @if($transactions->count() > 0)
                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                        Date
                                    </th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                        Plan
                                    </th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                        Amount
                                    </th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                        Gateway
                                    </th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                        Status
                                    </th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                        Actions
                                    </th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                @foreach($transactions as $transaction)
                                    <tr>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                            {{ $transaction->created_at->format('M d, Y h:i A') }}
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                            {{ $transaction->plan ? $transaction->plan->name : 'Unknown Plan' }}
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">
                                            ${{ number_format($transaction->amount ?? 0, 2) }}
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                            {{ ucfirst($transaction->payment_gateway ?? 'unknown') }}
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap">
                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium
                                                @if($transaction->payment_status === 'paid') bg-green-100 text-green-800
                                                @elseif($transaction->payment_status === 'pending') bg-yellow-100 text-yellow-800
                                                @else bg-red-100 text-red-800 @endif">
                                                {{ ucfirst($transaction->payment_status ?? 'unknown') }}
                                            </span>
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                            <a href="#" class="text-blue-600 hover:text-blue-900">View</a>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    
                    <!-- Pagination -->
                    <div class="mt-4">
                        {{ $transactions->links() }}
                    </div>
                @else
                    <div class="text-center py-8">
                        <div class="text-6xl text-gray-300 mb-4">💳</div>
                        <p class="text-gray-500">No transactions found</p>
                        <p class="text-sm text-gray-400">This customer hasn't made any payments yet.</p>
                    </div>
                @endif
            </div>
        </div>
    </div>
</x-admin-layout>
