<x-admin-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            Payment Gateway Settings
        </h2>
    </x-slot>

    <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
        <div class="bg-white shadow-sm rounded-lg">
            <div class="px-4 py-5 sm:p-6">
                <h3 class="text-lg font-medium text-gray-900">Active Payment Gateways</h3>
                
                @if(empty($gateways))
                    <div class="text-center py-8">
                        <div class="text-6xl text-gray-300 mb-4">💳</div>
                        <p class="text-gray-500">No payment gateways configured</p>
                        <p class="text-sm text-gray-400">Configure payment settings below to enable payment processing.</p>
                    </div>
                @else
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                        @foreach($gateways as $gateway => $gatewayData)
                        <div class="border rounded-lg p-4 {{ !empty($gatewayData['enabled']) ? 'border-green-200 bg-green-50' : 'border-gray-200' }}">
                            <div class="flex items-center justify-between mb-2">
                                <h4 class="font-semibold text-gray-900">{{ $gatewayData['name'] }}</h4>
                                @if($gatewayData['enabled'])
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                        Active
                                    </span>
                                @else
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-gray-100 text-gray-800">
                                        Inactive
                                    </span>
                                @endif
                            </div>
                            <div class="space-y-1 text-sm">
                                <p><span class="font-medium">Type:</span> {{ $gatewayData['type'] }}</p>
                                @if(isset($gatewayData['sandbox']))
                                    <p><span class="font-medium">Mode:</span> {{ $gatewayData['sandbox'] ? 'Sandbox' : 'Live' }}</p>
                                @endif
                                @if(isset($gatewayData['number']))
                                    <p><span class="font-medium">Number:</span> {{ $gatewayData['number'] }}</p>
                                @endif
                            </div>
                        </div>
                        @endforeach
                    </div>
                @endif
            </div>
        </div>

        <div class="bg-white shadow-sm rounded-lg mt-6">
            <div class="px-4 py-5 sm:p-6">
                <h3 class="text-lg font-medium text-gray-900 mb-4">Payment Configuration</h3>
                
                <form method="POST" action="{{ route('admin.payment.update') }}" class="space-y-6">
                    @csrf
                    @method('PUT')
                    
                    <!-- Primary Gateway -->
                    <div>
                        <label for="payment_gateway" class="block text-sm font-medium text-gray-700">Primary Payment Gateway</label>
                        <select id="payment_gateway" name="payment_gateway" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-green-500 focus:ring focus:ring-green-200 focus:ring-opacity-50">
                            <option value="stripe" {{ ($settings['payment_gateway'] ?? '') == 'stripe' ? 'selected' : '' }}>Stripe</option>
                            <option value="sslcommerz" {{ ($settings['payment_gateway'] ?? '') == 'sslcommerz' ? 'selected' : '' }}>SSLCommerz</option>
                        </select>
                    </div>

                    <!-- Stripe Settings -->
                    <div class="border-t pt-6">
                        <h4 class="text-md font-medium text-gray-900 mb-4">Stripe Configuration</h4>
                        
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label for="payment_key" class="block text-sm font-medium text-gray-700">Publishable Key</label>
                                <input type="text" id="payment_key" name="payment_key" value="{{ $settings['payment_key'] ?? '' }}" 
                                       class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-green-500 focus:ring focus:ring-green-200 focus:ring-opacity-50">
                            </div>
                            
                            <div>
                                <label for="payment_secret" class="block text-sm font-medium text-gray-700">Secret Key</label>
                                <input type="password" id="payment_secret" name="payment_secret" value="{{ $settings['payment_secret'] ?? '' }}" 
                                       class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-green-500 focus:ring focus:ring-green-200 focus:ring-opacity-50">
                            </div>
                        </div>
                        
                        <div class="flex items-center">
                            <input type="checkbox" id="stripe_sandbox" name="stripe_sandbox" value="1" {{ ($settings['stripe_sandbox'] ?? '') == '1' ? 'checked' : '' }}
                                    class="h-4 w-4 text-green-600 focus:ring-green-500 border-gray-300 rounded">
                            <label for="stripe_sandbox" class="ml-2 block text-sm text-gray-900">Use Sandbox Mode</label>
                        </div>
                    </div>

                    <!-- SSLCommerz Settings -->
                    <div class="border-t pt-6">
                        <h4 class="text-md font-medium text-gray-900 mb-4">SSLCommerz Configuration</h4>
                        
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label for="sslcommerz_store_id" class="block text-sm font-medium text-gray-700">Store ID</label>
                                <input type="text" id="sslcommerz_store_id" name="sslcommerz_store_id" value="{{ $settings['sslcommerz_store_id'] ?? '' }}" 
                                       class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-green-500 focus:ring focus:ring-green-200 focus:ring-opacity-50">
                            </div>
                            
                            <div>
                                <label for="sslcommerz_store_password" class="block text-sm font-medium text-gray-700">Store Password</label>
                                <input type="password" id="sslcommerz_store_password" name="sslcommerz_store_password" value="{{ $settings['sslcommerz_store_password'] ?? '' }}" 
                                       class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-green-500 focus:ring focus:ring-green-200 focus:ring-opacity-500">
                            </div>
                        </div>
                        
                        <div class="flex items-center">
                            <input type="checkbox" id="sslcommerz_sandbox" name="sslcommerz_sandbox" value="1" {{ ($settings['sslcommerz_sandbox'] ?? '') == '1' ? 'checked' : '' }}
                                    class="h-4 w-4 text-green-600 focus:ring-green-500 border-gray-300 rounded">
                            <label for="sslcommerz_sandbox" class="ml-2 block text-sm text-gray-900">Use Sandbox Mode</label>
                        </div>
                    </div>

                    <!-- Manual Payment Methods -->
                    <div class="border-t pt-6">
                        <h4 class="text-md font-medium text-gray-900 mb-4">Manual Payment Methods</h4>
                        
                        <!-- bKash -->
                        <div class="border-t pt-4">
                            <h5 class="text-sm font-medium text-gray-900 mb-3">bKash</h5>
                            <div class="flex items-center mb-4">
                                <input type="checkbox" id="enable_bkash_manual" name="enable_bkash_manual" value="1" {{ ($settings['enable_bkash_manual'] ?? '') == '1' ? 'checked' : '' }}
                                    class="h-4 w-4 text-green-600 focus:ring-green-500 border-gray-300 rounded">
                                <label for="enable_bkash_manual" class="ml-2 block text-sm text-gray-900">Enable bKash Manual Payments</label>
                            </div>
                            
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div>
                                    <label for="bkash_number" class="block text-sm font-medium text-gray-700">bKash Number</label>
                                    <input type="text" id="bkash_number" name="bkash_number" value="{{ $settings['bkash_number'] ?? '' }}" 
                                           class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-green-500 focus:ring focus:ring-green-200 focus:ring-opacity-500">
                                </div>
                                
                                <div>
                                    <label for="bkash_type" class="block text-sm font-medium text-gray-700">Account Type</label>
                                    <select id="bkash_type" name="bkash_type" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-green-500 focus:ring focus:ring-green-200 focus:ring-opacity-500">
                                        <option value="personal" {{ ($settings['bkash_type'] ?? '') == 'personal' ? 'selected' : '' }}>Personal</option>
                                        <option value="business" {{ ($settings['bkash_type'] ?? '') == 'business' ? 'selected' : '' }}>Business</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <!-- Nagad -->
                        <div class="border-t pt-4">
                            <h5 class="text-sm font-medium text-gray-900 mb-3">Nagad</h5>
                            <div class="flex items-center mb-4">
                                <input type="checkbox" id="enable_nagad_manual" name="enable_nagad_manual" value="1" {{ ($settings['enable_nagad_manual'] ?? '') == '1' ? 'checked' : '' }}
                                    class="h-4 w-4 text-green-600 focus:ring-green-500 border-gray-300 rounded">
                                <label for="enable_nagad_manual" class="ml-2 block text-sm text-gray-900">Enable Nagad Manual Payments</label>
                            </div>
                            
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div>
                                    <label for="nagad_number" class="block text-sm font-medium text-gray-700">Nagad Number</label>
                                    <input type="text" id="nagad_number" name="nagad_number" value="{{ $settings['nagad_number'] ?? '' }}" 
                                           class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-green-500 focus:ring focus:ring-green-200 focus:ring-opacity-500">
                                </div>
                                
                                <div>
                                    <label for="nagad_type" class="block text-sm font-medium text-gray-700">Account Type</label>
                                    <select id="nagad_type" name="nagad_type" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-green-500 focus:ring focus:ring-green-200 focus:ring-opacity-500">
                                        <option value="personal" {{ ($settings['nagad_type'] ?? '') == 'personal' ? 'selected' : '' }}>Personal</option>
                                        <option value="business" {{ ($settings['nagad_type'] ?? '') == 'business' ? 'selected' : '' }}>Business</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <!-- Rocket -->
                        <div class="border-t pt-4">
                            <h5 class="text-sm font-medium text-gray-900 mb-3">Rocket</h5>
                            <div class="flex items-center mb-4">
                                <input type="checkbox" id="enable_rocket_manual" name="enable_rocket_manual" value="1" {{ ($settings['enable_rocket_manual'] ?? '') == '1' ? 'checked' : '' }}
                                    class="h-4 w-4 text-green-600 focus:ring-green-500 border-gray-300 rounded">
                                <label for="enable_rocket_manual" class="ml-2 block text-sm text-gray-900">Enable Rocket Manual Payments</label>
                            </div>
                            
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div>
                                    <label for="rocket_number" class="block text-sm font-medium text-gray-700">Rocket Number</label>
                                    <input type="text" id="rocket_number" name="rocket_number" value="{{ $settings['rocket_number'] ?? '' }}" 
                                           class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-green-500 focus:ring focus:ring-green-200 focus:ring-opacity-500">
                                </div>
                                
                                <div>
                                    <label for="rocket_type" class="block text-sm font-medium text-gray-700">Account Type</label>
                                    <select id="rocket_type" name="rocket_type" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-green-500 focus:ring focus:ring-green-200 focus:ring-opacity-500">
                                        <option value="personal" {{ ($settings['rocket_type'] ?? '') == 'personal' ? 'selected' : '' }}>Personal</option>
                                        <option value="business" {{ ($settings['rocket_type'] ?? '') == 'business' ? 'selected' : '' }}>Business</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="flex justify-end">
                        <button type="submit" class="inline-flex justify-center py-2 px-4 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-green-600 hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500 focus:ring-opacity-50 transition-colors">
                            Save Settings
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</x-admin-layout>
