<x-admin-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            Notifications
            @if($unreadCount > 0)
                <span class="ml-2 inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-red-100 text-red-800">
                    {{ $unreadCount }} unread
                </span>
            @endif
        </h2>
    </x-slot>

    <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
        <!-- Actions -->
        <div class="mb-6 flex justify-between items-center">
            <div>
                <a href="{{ route('admin.notifications.create') }}" 
                   class="bg-blue-600 text-white px-4 py-2 rounded-md hover:bg-blue-700">
                    Send New Notification
                </a>
                @if($unreadCount > 0)
                    <button onclick="markAllAsRead()" 
                            class="ml-3 text-gray-600 hover:text-gray-800">
                        Mark All as Read
                    </button>
                @endif
            </div>
            <div class="text-sm text-gray-500">
                Total: {{ $notifications->total() }} notifications
            </div>
        </div>

        <!-- Notifications List -->
        <div class="bg-white shadow-sm rounded-lg">
            <div class="divide-y divide-gray-200">
                @foreach($notifications as $notification)
                    <div class="p-6 hover:bg-gray-50 {{ !$notification->is_read ? 'bg-blue-50' : '' }}">
                        <div class="flex items-start justify-between">
                            <div class="flex-1">
                                <div class="flex items-center">
                                    <div class="flex-shrink-0">
                                        <div class="inline-flex items-center justify-center w-8 h-8 rounded-full
                                            @if($notification->type === 'info') bg-blue-100 text-blue-600
                                            @elseif($notification->type === 'success') bg-green-100 text-green-600
                                            @elseif($notification->type === 'warning') bg-yellow-100 text-yellow-600
                                            @elseif($notification->type === 'error') bg-red-100 text-red-600
                                            @else bg-gray-100 text-gray-600 @endif">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                @if($notification->type === 'info')
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                                @elseif($notification->type === 'success')
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                                @elseif($notification->type === 'warning')
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L4.082 15.5c-.77.833.192 2.5 1.732 2.5z"></path>
                                                @elseif($notification->type === 'error')
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                                @else
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                                @endif
                                            </svg>
                                        </div>
                                    </div>
                                    <div class="ml-3">
                                        <h3 class="text-lg font-medium text-gray-900">
                                            {{ $notification->title }}
                                            @if(!$notification->is_read)
                                                <span class="ml-2 inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
                                                    New
                                                </span>
                                            @endif
                                        </h3>
                                        <p class="mt-1 text-sm text-gray-600">{{ $notification->message }}</p>
                                        <div class="mt-2 flex items-center space-x-4 text-xs text-gray-500">
                                            <span>
                                                @if($notification->target_type === 'all')
                                                    All tenants
                                                @elseif($notification->target_type === 'tenant')
                                                    Specific tenant
                                                @else
                                                    Customer
                                                @endif
                                            </span>
                                            <span>Sent by {{ $notification->sender->name ?? 'System' }}</span>
                                            <span>{{ $notification->sent_at->diffForHumans() }}</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="ml-4 flex-shrink-0 flex space-x-2">
                                <a href="{{ route('admin.notifications.show', $notification->id) }}" 
                                   class="text-blue-600 hover:text-blue-900 text-sm">
                                    View
                                </a>
                                @if(!$notification->is_read)
                                    <button onclick="markAsRead({{ $notification->id }})" 
                                            class="text-green-600 hover:text-green-900 text-sm">
                                        Mark Read
                                    </button>
                                @endif
                                <form action="{{ route('admin.notifications.destroy', $notification->id) }}" 
                                      method="POST" onsubmit="return confirm('Are you sure?')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="text-red-600 hover:text-red-900 text-sm">
                                        Delete
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>

            <!-- Pagination -->
            <div class="p-4 border-t">
                {{ $notifications->links() }}
            </div>
        </div>
    </div>

    <script>
        function markAsRead(id) {
            fetch(`{{ route('admin.notifications.read', ':id') }}`.replace(':id', id), {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    location.reload();
                }
            });
        }

        function markAllAsRead() {
            if (confirm('Mark all notifications as read?')) {
                fetch('{{ route('admin.notifications.read-all') }}', {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                    }
                })
                .then(() => {
                    location.reload();
                });
            }
        }
    </script>
</x-admin-layout>
