<x-app-layout>
    <div class="min-h-screen flex flex-col sm:justify-center items-center pt-6 sm:pt-0 bg-gray-100">
        <div class="w-full sm:max-w-md mt-6 px-6 py-4 bg-white shadow-md overflow-hidden sm:rounded-lg">
            <div class="mb-4 text-center">
                <h2 class="text-xl font-bold text-gray-900">{{ __('Two-Factor Authentication') }}</h2>
                <p class="mt-2 text-sm text-gray-600">
                    {{ __('Please enter the code from your authenticator app to verify your identity.') }}
                </p>
            </div>

            <form method="POST" action="{{ route('admin.2fa.verify') }}">
                @csrf
                <div>
                    <label for="code" class="block font-medium text-sm text-gray-700">{{ __('Authentication Code') }}</label>
                    <input id="code" class="block mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50" type="text" name="code" required autofocus autocomplete="off" placeholder="Enter 6-digit code" />
                    @error('code')
                        <span class="text-red-600 text-sm mt-1 block">{{ $message }}</span>
                    @enderror
                </div>

                <div class="flex items-center justify-end mt-4">
                    <button type="submit" class="inline-flex items-center px-4 py-2 bg-indigo-900 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-indigo-800 active:bg-indigo-950 focus:outline-none focus:border-indigo-950 focus:ring ring-indigo-300 disabled:opacity-25 transition ease-in-out duration-150">
                        {{ __('Verify') }}
                    </button>
                </div>
            </form>

            <div class="mt-6 text-center border-t pt-4">
                <form method="POST" action="{{ route('logout') }}">
                    @csrf
                    <button type="submit" class="text-sm text-gray-600 hover:text-gray-900 underline">
                        {{ __('Log Out') }}
                    </button>
                </form>
            </div>
        </div>
    </div>
</x-app-layout>
