# Implementation Plan: Product Variants Database Schema

## Goal
Implement the database schema changes required to support complex product variants and multi-unit management as defined in the master plan.

## 1. Database Schema Changes

### A. Modify `products` Table
- Add `has_variants` (boolean, default false)

### B. Update `product_variants` Table
- Add `is_active`.

### C. Create `variant_attributes` Table
- `id` (PK)
- `variant_id` (FK -> product_variants)
- `name` (string: Color, Size, etc.)
- `value` (string: Red, Large, etc.)

### D. Create `product_units` Table
- `id` (PK)
- `product_id` (FK -> products)
- `name` (string: Case, Pack)
- `conversion_factor` (decimal: 24, 6)
- `is_base` (boolean)
- `is_purchase` (boolean)
- `is_sale` (boolean)

### E. Create `variant_prices` Table
- `id` (PK)
- `variant_id` (FK -> product_variants)
- `product_unit_id` (FK -> product_units)
- `price` (decimal)
- `cost` (decimal)

## 2. Models to Create/Update
- `App\Models\Tenant\Product` (Update relations)
- `App\Models\Tenant\ProductVariant` (Update relations)
- `App\Models\Tenant\VariantAttribute` (New)
- `App\Models\Tenant\ProductUnit` (New)
- `App\Models\Tenant\VariantPrice` (New)

## 3. Execution Steps
1. Create Migration File.
2. Run Migration.
3. Generate Models.
