# Implementation Plan: Product Creation UI (Frontend)

## Goal
Implement a dynamic, multi-step interface for creating products with complex variants using Alpine.js.

## 1. UI Structure

### A. Basic Information Section
- Name, Category, Brand.
- Base Unit Selection (from global units).
- Toggle: "This product has multiple options (variants)".

### B. Variant Configuration (Visible if Toggle = True)
- **Attributes Section**:
  - Dynamic list of attributes (e.g., Color, Size).
  - Input for Attribute Name.
  - Input for Attribute Values (comma separated or tags).
  - Button: "Generate Variants".

### C. Unit Configuration (Visible if Toggle = True)
- **Additional Units**:
  - List of custom units (e.g., Case).
  - Input for Name, Conversion Factor (e.g., 24).
  - Checkbox: Is Sale Unit?

### D. Variant Matrix & Pricing
- Table displaying generated variants.
- SKU generation logic (Auto-fill).
- **Pricing**:
  - Nested table or modal to set prices for each unit (Base, Case, etc.) for each variant.
  - Columns: Variant Name, Unit, Price, Cost, Stock.

## 2. Alpine.js Data Model
```javascript
data() {
    return {
        hasVariants: false,
        attributes: [{ name: '', values: '' }],
        customUnits: [],
        variants: [],
        
        generateVariants() {
            // Combinatorial logic
        },
        
        addUnit() {
            this.customUnits.push({ name: '', factor: 1 });
        }
    }
}
```

## 3. Execution Steps
1. Update `create.blade.php` with the new layout.
2. Implement Alpine.js logic for attribute combination and matrix generation.
3. Ensure form submission structure matches the Controller's expected JSON structure.
