# Implementation Plan: Product Creation Logic (Backend)

## Goal
Implement the backend logic in `ProductController` to handle the creation of products with complex variants, attributes, multi-units, and pricing.

## 1. Controller Changes (`ProductController.php`)

### A. `create` Method
- No major changes needed if we load data via API or just standard blade.
- Ensure `units`, `categories`, `brands` are passed.

### B. `store` Method (The Core Logic)
- **Validation**:
  - Validate basic product info.
  - Validate `has_variants` flag.
  - If `has_variants` is true:
    - Validate `variants` array.
    - Validate `attributes` inside variants.
    - Validate `units` array (custom units).
    - Validate `prices` array (matrix of variant x unit).
- **Transaction**:
  - Create `Product`.
  - Create `ProductUnit`s (Base + Custom).
  - Loop `variants`:
    - Create `ProductVariant`.
    - Create `VariantAttribute`s.
    - Create `VariantPrice`s.

## 2. Request Data Structure (Expected from Frontend)
```json
{
  "name": "Pepsi",
  "has_variants": true,
  "base_unit_id": 1, // Piece
  "units": [
    { "name": "Case", "conversion_factor": 24, "is_sale": true }
  ],
  "variants": [
    {
      "sku": "PEP-CAN-250",
      "stock": 100,
      "attributes": [
        { "name": "Type", "value": "Can" },
        { "name": "Size", "value": "250ml" }
      ],
      "prices": [
        { "unit_name": "Piece", "price": 0.50, "cost": 0.30 },
        { "unit_name": "Case", "price": 10.00, "cost": 7.00 }
      ]
    }
  ]
}
```

## 3. Execution Steps
1. Update `ProductController::store` method.
2. Ensure `ProductRequest` (if exists) or inline validation handles the nested structure.
