# Debugging & Seeding Plan: Product Variants

## Goal
Investigate why the product creation with variants is failing, fix the issues, and provide seed data for testing.

## 1. Investigation Strategy
- **Backend Verification**: Create a standalone script to simulate a POST request payload to the `ProductController` logic.
- **Frontend Verification**: Review the Alpine.js logic in `create.blade.php`.

## 2. Action Plan
1.  **Create Test Script**: `debug_product_creation.php` to manually trigger the creation logic.
2.  **Run Script**: Analyze the output/error log.
3.  **Fix Code**: Update Controller or Blade file based on findings.
4.  **Create Seeder**: `database/seeders/Tenant/ComplexProductSeeder.php` to populate the "Pepsi" example.
5.  **Documentation**: Update the technical docs with the fix details.
